<form id="basicform" class="kt-form">
  <div class="form-group row">
    <label class="col-4 col-form-label">Interest Rate</label>
    <div class="col-3">
      <input class="form-control" type="text" value="<?php echo number_format($loan->loan_interest_default_amount);?>" name="loan_interest_default_amount" placeholder="Default Amount">
    </div>
    <div class="col-2">
      <input class="form-control" type="text" value="<?php echo number_format($loan->loan_interest_min_amount);?>" name="loan_interest_min_amount" placeholder="Min Amount" >
    </div>
    <div class="col-3">
      <input class="form-control" type="text" value="<?php echo number_format($loan->loan_interest_max_amount);?>" name="loan_interest_max_amount" placeholder="Max Amount" >
    </div>
  </div>
  <div class="form-group row">
    <label class="col-4 col-form-label">Interest Rate Period</label>
    <div class="col-8">
      <select class="form-control" name="loan_interest_rate_period" >
        <option value=""></option>
        <option <?php if(strtolower($loan->loan_interest_rate_period) == 'daily') echo 'selected';?> value="daily">Daily</option>
        <option  <?php if(strtolower($loan->loan_interest_rate_period) == 'weekly') echo 'selected';?> value="weekly">weekly</option>
        <option <?php if(strtolower($loan->loan_interest_rate_period) == 'monthly') echo 'selected';?> value="monthly">Monthly</option>
        <option <?php if(strtolower($loan->loan_interest_rate_period) == 'annually') echo 'selected';?> value="annually">Annually</option>
      </select>
    </div>
  </div>
  <div class="form-group row">
    <label class="col-4 col-form-label">Interest Method</label>
    <div class="col-8">
      <select class="form-control" name="loan_interest_method" >
        <option value=""></option>
        <option <?php if(strtolower($loan->loan_interest_method) == 'flat') echo 'selected';?> value="flat">Flat Rate</option>
        <option <?php if(strtolower($loan->loan_interest_method) == 'interest') echo 'selected';?> value="interest">Interest</option>
      </select>
    </div>
  </div>
  <div class="form-group row">
    <label class="col-4 col-form-label">Interest Overide</label>
    <div class="col-8">
      <div class="kt-radio-inline">
        <label class="kt-radio">
          <input type="radio" value="yes" <?php if(strtolower($loan->loan_interest_overide) == 'yes') echo 'checked';?> name="loan_interest_overide"> YES
          <span></span>
        </label>
        <label class="kt-radio">
          <input type="radio"  value="no" <?php if(strtolower($loan->loan_interest_overide) == 'no') echo 'checked';?> name="loan_interest_overide"> NO
          <span></span>
        </label>
      </div>
    </div>
  </div>
      <div class="form-group">
        <button type="submit" class="btn btn-brand pull-right" name="button">SAVE CHANGES</button><br/>
      </div>
    </form>
</div>
<script type="text/javascript">
(function($, undefined) {
    "use strict";
    // When ready.
    $(function() {
      var $input = $( "input.number" );
      $input.on( "keyup", function( event ) {
          // When user select text in the document, also abort.
          var selection = window.getSelection().toString();
          if ( selection !== '' ) {
              return;
          }
          // When the arrow keys are pressed, abort.
          if ( $.inArray( event.keyCode, [38,40,37,39] ) !== -1 ) {
              return;
          }
          var $this = $( this );
          // Get the value.
          var input = $this.val();
          var input = input.replace(/[\D\s\._\-]+/g, "");
          input = input ? parseInt( input, 10 ) : 0;
          $this.val( function() {
              return ( input === 0 ) ? "" : input.toLocaleString( "en-US" );
          } );
      });
    });
})(jQuery);

  $('select.form-control').css('width','100%');
  $('select.form-control').select2({placeholder: 'select option'});

  $(function(){
    $('form#basicform').submit( function(event){
    event.preventDefault();
      let form = $( this );
      let $div =  $('div#details');
      let formdata = form.serialize();
      $.ajax({
       url: '<?php echo base_url($auth_role.'/loans/index/loadinterestAction/'.$loan->loan_key);?>' ,
        type: 'get',
        data: formdata,
        beforeSend: function(){
            KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Updating interest information ...."
                });
          },
         success: function(r){
              var obj = JSON.parse(r);
              if(obj.status == 'ok'){
              Swal.fire('',obj.message,'success');
                $div.load("<?php echo base_url($auth_role.'/loans/index/loadinterest/'.$loan->loan_key);?>");
                }else{
                    Swal.fire('',obj.message,'warning');
                }
                KTApp.unblock($div);
             },
          error: function(){
            Swal.fire('',obj.message,'success');
              KTApp.unblock($div);
              }
      });
    })
  })
</script>
