<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<h4>Application details</h4> <hr/>



<table class="table table-info table-bordered">
	<thead>
		<tr>
			<th>Date</th>
			<th>Employee</th>
			<th>Action</th>
		</tr>
	</thead>
	<tbody>
		<tr>
			<td><?php echo date('Y M d H:i:s',strtotime($application->app_date));?></td>
			<td><?php echo profile($application->app_registra)->firstname.' '.profile($application->app_registra)->lastname;?></td>
			<td>Registered Application</td>
		</tr>
		<?php if(!empty($application->app_updator)){?>
		<tr>
			<td><?php echo date('Y M d H:i:s',strtotime($application->app_updated_at));?></td>
			<td><?php echo profile($application->app_updator)->firstname.' '.profile($application->app_updator)->lastname;?></td>
			<td>Updated Application</td>
		</tr>
	<?php } ?>
	</tbody>
</table><br/>
	<form class="kt-form kt-padding-30" id="loanApplication" action="#">
		<input type="hidden" value="<?php echo $application->app_customer;?>" name="app_customer";?>
							<div class="form-group row">
										<label class="col-4 col-form-label">Referee</label>
								<div class="col-8">
									<select class="form-control" name="app_referees[]" multiple>
										<option value=""></option>
										<?php
											$referees = json_decode($application->app_referees);
												foreach ($customers as $key => $customer) { ?>
													<option <?php if(in_array_r($customer['user_id'],$referees)) echo 'selected';?>  value="<?php echo $customer['user_id'];?>"><?php echo $customer['firstname'].' '.$customer['lastname'].' - '.$customer['group_name'];?></option>
												<?php }
										 ?>
									</select>
								</div>
							</div>
					<div class="form-group row">
							<label class="col-4 col-form-label">Loan product</label>
							<div class="col-8">
								<select class="form-control" name="app_loan" onchange="loadproductoptions(this.value)">
									<option value=""></option>
									<?php if($loans){
										foreach ($loans as $key => $loan) {?>
											<option  <?php if($loan['loan_key'] == $application->app_loan) echo 'selected';?> value="<?php echo $loan['loan_key'];?>"><?php echo $loan['loan_name'];?></option>
										<?php }
									} ?>
								</select>
							</div>
					</div>
					<div class="form-group row">
								<label class="col-4 col-form-label">Interest Rate</label>
						<div class="col-8">
							<input class="form-control number" name="app_interest_rate" value="<?php echo number_format(to_money($application->app_interest_rate));?>" />
						</div>
					</div>
					<div class="form-group row">
								<label class="col-4 col-form-label">Interest Amount</label>
						<div class="col-8">
							<input class="form-control number" readonly name="app_interest" value="<?php echo number_format(to_money($application->app_interest));?>" />
						</div>
					</div>
					<div class="form-group row">
								<label class="col-4 col-form-label">Principal Amount</label>
						<div class="col-8">
							<input class="form-control number" value="<?php echo number_format(to_money($application->app_principal));?>" name="app_principal" />
						</div>
					</div>
					<div class="form-group row">
		        <label class="col-4 col-form-label">Payment Schedule</label>
		        <div class="col-8">
		          <select class="form-control" name="app_schedule" >
		            <option value=""></option>
		            <option <?php if(strtolower($application->loan_payment_schedule) == 'daily') echo 'selected';?> value="daily">Daily</option>
		            <option  <?php if(strtolower($application->loan_payment_schedule) == 'weekly') echo 'selected';?> value="weekly">weekly</option>
		            <option <?php if(strtolower($application->loan_payment_schedule) == 'monthly') echo 'selected';?> value="monthly">Monthly</option>
		            <option <?php if(strtolower($application->loan_payment_schedule) == 'yearly') echo 'selected';?> value="annually">Annually</option>
		          </select>
		        </div>
		      </div>
		      <div class="form-group row">
		        <label class="col-4 col-form-label">Loan term</label>
		        <div class="col-3">
		          <input class="form-control" type="number" value="<?php echo $application->app_term_count;?>" name="app_term_count" placeholder="">
		        </div>
		        <div class="col-5">
		          <select class="form-control" name="app_term" id="loan-term">
		            <option value=""></option>
		            <option <?php if(strtolower($application->app_term) == 'days') echo 'selected';?> value="days">Days</option>
		            <option <?php if(strtolower($application->app_term) == 'weeks') echo 'selected';?> value="weeks">Weeks</option>
		            <option <?php if(strtolower($application->app_term) == 'months') echo 'selected';?> value="months">Months</option>
		            <option <?php if(strtolower($application->app_term) == 'years') echo 'selected';?> value="years">Years</option>
		          </select>
		        </div>
		      </div>
					<div class="form-group row">
						<label class="col-4 col-form-label">Release Date</label>
						<div class="col-8">
							<div class="input-group date">
								<input type="datetime-datetime-local" name="app_date" class="form-control" value="<?php echo $application->app_date;?>" id="kt_datetimepicker_3">
								<div class="input-group-append">
									<span class="input-group-text">
										<i class="la la-calendar glyphicon-th"></i>
									</span>
								</div>
							</div>
						</div>
					</div>
					<div class="form-group row">
						<label class="col-4 col-form-label">Disburse Method</label>
						<div class="col-8">
							<select class="form-control" name="app_disburse_method" >
								<option value=""></option>
                                                                <option <?php if(strtolower($application->app_disburse_method) == 'cash') echo 'selected';?> value="cash">Cash</option>
							</select>
						</div>
					</div>
					<div class="form-group row">
						<label class="col-4 col-form-label"></label>
						<div class="col-4">
							<button type="button" id="previewApplication" class="text-uppercase btn btn-block btn-success">Preview</button>
						</div>
						<div class="col-4">
							<button type="submit" class="text-uppercase btn btn-block btn-info">Save Changes</button>
						</div>
					</div>
	</form>

<script type="text/javascript">
(function($, undefined) {
		"use strict";
		// When ready.
		$(function() {
			var $input = $( "input.number" );
			$input.on( "keyup", function( event ) {
					// When user select text in the document, also abort.
					var selection = window.getSelection().toString();
					if ( selection !== '' ) {
							return;
					}
					// When the arrow keys are pressed, abort.
					if ( $.inArray( event.keyCode, [38,40,37,39] ) !== -1 ) {
							return;
					}
					var $this = $( this );
					// Get the value.
					var input = $this.val();
					var input = input.replace(/[\D\s\._\-]+/g, "");
					input = input ? parseInt( input, 10 ) : 0;
					$this.val( function() {
							return ( input === 0 ) ? "" : input.toLocaleString( "en-US" );
					} );
			});
		});
})(jQuery);

	$(function(){
		$('#previewApplication').click( function(event){
			let form = $('form#loanApplication');
			event.preventDefault();
			let formData = form.serialize();
			$.ajax({
			 url: '<?php echo base_url($auth_role.'/loans/applications/updatepreview');?>',
				type: 'get',
				data: formData,
				beforeSend: function(){
					KTApp.block(form,{
									overlayColor:"#000000",
									type:"loader",
									state:"warning",
									message:"Generating preview ..."
							});
				},
				success: function(r){
					KTApp.unblock(form);
								let modal = $('div#previewModal');
								modal.find('.preview-content').html(r);
								modal.modal('show');
						 },
						error: function(xhr){
							KTApp.unblock(form);
							swal.fire('failed');
						}
			});
		})

		$('form#loanApplication').submit( function(event){
			let form = $('form#loanApplication');
			event.preventDefault();
			let formData = form.serialize();
			$.ajax({
			 url: '<?php echo base_url($auth_role.'/loans/applications/updateapplication/'.$application->app_key);?>',
				type: 'get',
				data: formData,
				beforeSend: function(){
					KTApp.block(form,{
									overlayColor:"#000000",
									type:"loader",
									state:"success",
									message:"Processing application ..."
							});
				 },
				 success: function(r){
					 KTApp.unblock(form);
							var obj = JSON.parse(r);
							if(obj.status == 'ok'){
								$('div#details').load('<?php echo base_url($auth_role.'/loans/applications/loadDetails/'.$application->app_key);?>')
								notifySuccess(obj.message);
							}else{
								Swal.fire('',obj.message,'warning');
							}
						 },
						error: function(xhr){
							KTApp.unblock(form);
							swal.fire('Problem Occured at our END');
						}
			});
		})

		$('select').select2({placeholder:'Select option'});
	});

	function loadproductoptions(loan){
	  $.ajax({
	   url: '<?php echo base_url($auth_role.'/loans/applications/loadproductoptions/');?>',
	    type: 'get',
	    data: {'loan':loan},
	     success: function(r){
	          var obj = JSON.parse(r);
	          if(obj.status == 'ok'){
	            $('input[name="app_principal"]').val(obj.principal.toLocaleString("<?php echo runnCurrency()->currency_code;?>"));
	            $('input[name="app_interest_rate"]').val(obj.interest);
	          }
	         },
	  });
	}
</script>

<div class="modal fade" id="previewModals" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterCharge" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
			<div class="modal-content" style="border:0px;">
					<div class="kt-scroll lm_max_height" data-scroll="true" style=" overflow-y: scroll; padding:5px;">
					<div class="modal-body text-back" id="printArea">
						<a data-dismiss="modal" href="javascript:(0);" modal-dismiss="modal" class="pull-right modal-title text-white">
							<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
									<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
											<rect id="bound" x="0" y="0" width="24" height="24"/>
											<path d="M7.62302337,5.30262097 C8.08508802,5.000107 8.70490146,5.12944838 9.00741543,5.59151303 C9.3099294,6.05357769 9.18058801,6.67339112 8.71852336,6.97590509 C7.03468892,8.07831239 6,9.95030239 6,12 C6,15.3137085 8.6862915,18 12,18 C15.3137085,18 18,15.3137085 18,12 C18,9.99549229 17.0108275,8.15969002 15.3875704,7.04698597 C14.9320347,6.73472706 14.8158858,6.11230651 15.1281448,5.65677076 C15.4404037,5.20123501 16.0628242,5.08508618 16.51836,5.39734508 C18.6800181,6.87911023 20,9.32886071 20,12 C20,16.418278 16.418278,20 12,20 C7.581722,20 4,16.418278 4,12 C4,9.26852332 5.38056879,6.77075716 7.62302337,5.30262097 Z" id="Oval-25" fill="#000000" fill-rule="nonzero"/>
											<rect id="Rectangle" fill="#000000" opacity="0.3" x="11" y="3" width="2" height="10" rx="1"/>
									</g>
							</svg></a>
							<br/>
						<div class="preview-content"></div>
					</div>
			</div>
		</div>
		</div>
	</div>
