<script type="text/javascript">
"use strict";

// Class definition
var KTLockminds = function() {

    // Daterangepicker Init
    var daterangepickerInit = function() {

        if ($('#kt_dashboard_daterangepicker').length == 0) {
            return;
        }

        var picker = $('#kt_dashboard_daterangepicker');
        var start = moment();
        var end = moment();

        function cb(start, end, label) {
            var title = '';
            var range = '';

            if ((end - start) < 100 || label == 'Today') {
              // window.location.href = "<?php echo base_url($auth_role.'/dashboard?when=today');?>";
            } else if (label == 'Yesterday') {
              window.location.href = "<?php echo base_url($auth_role.'/dashboard?when=yesterday');?>";
            } else {
                range = start.format('MMM D') + ' - ' + end.format('MMM D');
                window.location.href = "<?php echo base_url($auth_role.'/dashboard?when=custome&start=');?>" + start + ' &end=' + end;
            }

        }

        picker.daterangepicker({
            direction: KTUtil.isRTL(),
            minYear: '<?php echo date('Y',strtotime(config_item('config_fiscal_year')));?>',
            minDate: '<?php echo date('m/d/Y',strtotime(config_item('config_fiscal_year')));?>',
            startDate: start,
            endDate: end,
            opens: 'left',
            showDropdowns: true,
            linkedCalendars: false,
            ranges: {
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
            }
        }, cb);

        cb(start, end, '');
    }


    return {
        // Init demos
        init: function() {

            // init daterangepicker
            daterangepickerInit();

        }
    };
}();

// Class initialization on page load
jQuery(document).ready(function() {

  $('select').css('width','100%');
  $('select').select2({placeholder: 'select option'});

  $('.kt-portlet').draggable({
      handle: ".kt-portlet__head"
    });

  $( "#draggable" ).draggable({
      handle: ".handle"
    });

  $( ".draggable" ).draggable({
      handle: ".handle"
    });

  $(".timeago").timeago();

  $('.config-item-select').change( function(){
      var $handle = $( this );
      var key = $handle.data('key');
      var val = $handle.val();
       KTApp.block("#config-item-wrapper",{
                      overlayColor:"#000000",
                      type:"loader",
                      state:"success",
                      message:"Saving..."
                  });
      update_config_item(key,val);
      KTApp.unblock("#config-item-wrapper");
  });

  $('.config-item-check-box').change( function(e){

    var $input = $( this );

    e.preventDefault();

    var $url = $input.data('url');

    if( $input.prop('checked')){

        if(update_config_item($url,1)){
            $input.prop('checked',true);
          }

      }else{
        if(update_config_item($url,0)){
            $input.prop('checked',false);
          }
    }

  });
  <?php if($this->uri->segment(1) != 'locked'){?>
    $( document ).idleTimer( {
          timeout:300000,
          idle:false
      });
      $( document ).on( "idle.idleTimer", function(event, elem, obj){
        $.sessionTimeout({
            title: 'Session Timeout Notification',
            message: 'Your session is about to expire.',
            keepAliveUrl: '<?php echo current_url();?>',
            redirUrl: '<?php echo base_url('locked');?>',
            logoutUrl: '<?php echo base_url('logout');?>',
            warnAfter: 500000, //warn after 5 seconds
            redirAfter: 600000, //redirect after 10 secons,
            ignoreUserActivity: true,
            countdownMessage: 'Redirecting in {timer} seconds.',
            countdownBar: true
        });
      });
  <?php }?>

  <?php
   if(!empty($_SESSION['noaccess'])){?>
    $('div#nonAccessControl').modal({backdrop: 'static',keyboard: false});
  <?php  } ?>

  $('div#contactSystemAdmin').on('show.bs.modal', function (event) {
   $('div#nonAccessControl').hide();
   $('.modal-backdrop').remove() // removes the grey overlay.
  })

  $('div#nonAccessControl').on('hide.bs.modal', function (event) {
    $.ajax({
        dataType: 'text', // what to expect back from the server
        cache: false,
        contentType: false,
        processData: false,
        type: 'get',
        url: '<?php echo base_url('clearaccesscontrol');?>',
        beforeSend: function(){
            window.onbeforeunload = function(event) {
                var message = "Wait until i finish uploading data to the database";
                    var e = e || window.event;
                    if (e) {
                        e.returnValue = message;
                    }
                    return message;
                };
        },
        success: function (){
          window.onbeforeunload = null;
        },
        error: function(){
          window.onbeforeunload = null;
        }

      });
  })

  $('div#contactSystemAdmin').on('hide.bs.modal', function (event) {
    $.ajax({
        dataType: 'text', // what to expect back from the server
        cache: false,
        contentType: false,
        processData: false,
        type: 'get',
        url: '<?php echo base_url('clearaccesscontrol');?>',
        beforeSend: function(){
            window.onbeforeunload = function(event) {
                var message = "Wait until i finish uploading data to the database";
                    var e = e || window.event;
                    if (e) {
                        e.returnValue = message;
                    }
                    return message;
                };
        },
        success: function (){
          window.onbeforeunload = null;
        },
        error: function(){
          window.onbeforeunload = null;
        }

      });
  })

  KTLockminds.init();

});

function to_money(money){
  let unit = '<?php echo 1 * (!empty($currency = runnCurrency())) ? $currency->currency_convention : 1;?>';
  let result = money * unit;
  return result.toFixed(<?php echo (!empty($config = $this->configurationModel->loadConfigs())) ? $config->decimal_display : 2;?>);
}

function ucfirst(string){
  var str = string.toLowerCase();
  return str.charAt(0).toUpperCase() + str.slice(1);
}

function update_config_item(url,val){
   $.ajax({
      url: url + '/' + val,
      type: 'get',
      success: function(r){
        if( r == 'ok'){
            return true;
        }else{
            return false;
        }
      },
     error: function(){
        return false;
     }
   });
 }

 (function($, undefined) {
     "use strict";
     // When ready.
     $(function() {
       var $input = $( "input.number" );
       $input.on( "keyup", function( event ) {
           // When user select text in the document, also abort.
           var selection = window.getSelection().toString();
           if ( selection !== '' ) {
               return;
           }
           // When the arrow keys are pressed, abort.
           if ( $.inArray( event.keyCode, [38,40,37,39] ) !== -1 ) {
               return;
           }
           var $this = $( this );
           // Get the value.
           var input = $this.val();
           var input = input.replace(/[\D\s\._\-]+/g, "");
           input = input ? parseInt( input, 10 ) : 0;
           $this.val( function() {
               return ( input === 0 ) ? "" : input.toLocaleString( "en-US" );
           } );
       });
     });
 })(jQuery);

  function searchAnyRecord(record){
    let div = document.getElementById('searchResult');
    let searchLoader = document.getElementById('searchLoader');
    let searchContainer = document.getElementById('searchContainer');
    let search = record.replace(/^\s|\s+$/, "");
    if(search.length > 2){
      div.style.display = 'block';
      $.ajax({
        url:'<?php echo base_url('admin/expenses/expenses/searchexpense/');?>' + search,
        type:'get',
        beforeSend: function(){
          searchLoader.style.display = 'block';
          searchContainer.style.display = 'block';
        },
        success: function(r){
          searchContainer.style.display = 'block';
          searchLoader.style.display = 'none';
          div.innerHTML = r;
        }
      })
    }else{
      searchContainer.style.display = 'none';
      div.style.display = 'none';
      searchLoader.style.display = 'none';
      div.innerHTML = '';
    }
  }

  function notifySuccess(message){
		$.notify({
				// options
				message: message,
			},{
				// settings
				element: 'body',
				position: null,
				type: "success",
				allow_dismiss: true,
				newest_on_top: true,
				showProgressbar: false,
				placement: {
					from: "bottom",
					align: "right"
				},
				offset: 20,
				spacing: 10,
				z_index: 1031,
				delay: 500,
				timer: 500,
				url_target: '_blank',
				mouse_over: null,
				animate: {
					enter: 'animated fadeInDown',
					exit: 'animated fadeOutUp'
				},
				onShow: null,
				onShown: null,
				onClose: null,
				onClosed: null,
				icon_type: 'class',
				template: '<div data-notify="container" class="col-xs-11 col-sm-3 alert alert-{0}" role="alert">' +
					'<span data-notify="icon"></span> ' +
					'<span data-notify="title">{1}</span> ' +
					'<span data-notify="message">{2}</span>' +
					'<div class="progress" data-notify="progressbar">' +
						'<div class="progress-bar progress-bar-{0}" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width: 0%;"></div>' +
					'</div>' +
				'</div>'
			});
	}

  function notifySuccessUnlock(message,urlData){
		$.notify({
				// options
				message: message,
        url: urlData,
			},{
				// settings
				element: 'body',
				position: null,
				type: "success",
				allow_dismiss: true,
				newest_on_top: true,
				showProgressbar: false,
				placement: {
					from: "bottom",
					align: "right"
				},
				offset: 20,
				spacing: 10,
				z_index: 1031,
				delay: 500,
				timer: 3600000,
				url_target: '_self',
				mouse_over: null,
				animate: {
					enter: 'animated fadeInDown',
					exit: 'animated fadeOutUp'
				},
				onShow: null,
				onShown: null,
				onClose: null,
				onClosed: null,
				icon_type: 'class',
			});
	}

	function notifyWarning(message){
		$.notify({
				// options
				message: message,
			},{
				// settings
				element: 'body',
				position: null,
				type: "warning",
				allow_dismiss: true,
				newest_on_top: true,
				showProgressbar: false,
				placement: {
					from: "bottom",
					align: "right"
				},
				offset: 20,
				spacing: 10,
				z_index: 1031,
				delay: 500,
				timer: 2000,
				url_target: '_blank',
				mouse_over: null,
				animate: {
					enter: 'animated fadeInDown',
					exit: 'animated fadeOutUp'
				},
				onShow: null,
				onShown: null,
				onClose: null,
				onClosed: null,
				icon_type: 'class',
				template: '<div data-notify="container" class="col-xs-11 col-sm-3 alert alert-{0}" role="alert">' +
					'<span data-notify="icon"></span> ' +
					'<span data-notify="title">{1}</span> ' +
					'<span data-notify="message">{2}</span>' +
					'<div class="progress" data-notify="progressbar">' +
						'<div class="progress-bar progress-bar-{0}" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width: 0%;"></div>' +
					'</div>' +
				'</div>'
			});
	}


  function addElement(parentId, elementTag, elementId,elementClass) {
      // Adds an element to the document
      var p = document.getElementById(parentId);
      var newElement = document.createElement(elementTag);
      newElement.setAttribute('id', elementId);
      newElement.setAttribute('class', elementClass);
      p.appendChild(newElement);
  }

  function removeElement(elementId) {
    // Removes an element from the document
      var element = document.getElementById(elementId);
      element.parentNode.removeChild(element);
  }

  function showTime(){
      var date = new Date();
      var h = date.getHours(); // 0 - 23
      var m = date.getMinutes(); // 0 - 59
      var s = date.getSeconds(); // 0 - 59
      var session = "AM";

      if(h == 0){
          h = 12;
      }

      if(h > 12){
          h = h - 12;
          session = "PM";
      }

      h = (h < 10) ? "0" + h : h;
      m = (m < 10) ? "0" + m : m;
      s = (s < 10) ? "0" + s : s;

      var time = h + ":" + m + ":" + s + " " + session;
      document.getElementById("MyClockDisplay").innerText = time;
      document.getElementById("MyClockDisplay").textContent = time;

      setTimeout(showTime, 1000);

  }


  function lmNumber(number){
  return number.toString().replace(/[\D\s\._\-]+/g, "");
  }

  showTime();

</script>

