<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>

  <form id="employeesForm" onsubmit="return false;" class="kt-form">
    <div class="kt-section kt-section--first">
      <div class="kt-section__body">
          <div class="form-group row">
            <label class="col-3 col-form-label">Language</label>
            <div class="col-9">
              <select name="user_lang" class="form-control">
                  <option value=""></option>
                  <option <?php if(strtolower($employee->user_lang) == 'sw-tz') echo 'selected';?> value="sw-tz">Swahili TZ</option>
                  <option <?php if(strtolower($employee->user_lang) == 'english') echo 'selected';?> value="english">English US</option>
              </select>
            </div>
          </div>
          <div class="form-group row">
            <label class="col-3 col-form-label">Username</label>
            <div class="col-9">
              <div id="spinnerUsername" class="kt-spinner--sm kt-spinner--warning kt-spinner--right kt-spinner--input">
  							<input autocomplete="off" required onkeyup="checkusername(<?php echo $employee->user_id;?>, this.value)" id="username" name="username" class="form-control" type="text" value="<?php echo $employee->username;?>">
  						</div>
            </div>
          </div>
        <div class="form-group row">
          <label class="col-3 col-form-label">Password</label>
          <div class="col-9">
            <div class="input-group">
              <input id="passwordInput"  readonly onfocus="this.removeAttribute('readonly');"  type="password" class="form-control" placeholder="Password" aria-describedby="basic-addon1" name="password">
              <div class="input-group-append"><button class="btn btn-sm btn-warning text-dark" type="button" onmouseup="hidePassword()" onmousedown="showPassword()" class="input-group-text"><i class="la la-eye text-dark"></i></button></div>
            </div>
          </div>
        </div>
        <div class="form-group row">
          <label class="col-3 col-form-label">Administration</label>
          <div class="col-9">
            <div class="input-group">
              <select  required id="levels" name="auth_level" class="form-control" style="width:100%">
                <option value=""></option>
                <option <?php if($employee->auth_level == 9) echo 'selected';?> value="9">Administrator</option>
                <option <?php if($employee->auth_level == 8) echo 'selected';?> value="8">Employee</option>
              </select>
            </div>
          </div>
        </div>
        <div class="form-group row">
          <label class="col-3 col-form-label">Title</label>
          <div class="col-9">
            <div class="input-group">
              <select id="titles"  name="user_title" class="form-control" style="width:100%">
                <option value="">Select title</option>
                <?php if(!empty($titles)){
                  foreach ($titles as $key => $title) {?>
                    <option <?php if($title['category_key'] == $employee->user_title) echo 'selected';?> value="<?php echo $title['category_key'];?>"><?php echo $title['category_name'];?></option>
                  <?php }
                } ?>
              </select>
            </div>
          </div>
        </div>
        <div class="form-group row">
          <label class="col-3 col-form-label">Email</label>
          <div class="col-9">
            <div id="spinnerEmail" class="kt-spinner--sm kt-spinner--warning kt-spinner--right kt-spinner--input">
							<input autocomplete="off" onkeyup="checkemail(<?php echo $employee->user_id;?>, this.value)" id="email" name="email" class="form-control" type="email" value="<?php echo $employee->email;?>">
						</div>
          </div>
        </div>
        <div class="form-group row">
          <label class="col-3 col-form-label">Communication</label>
          <div class="col-9">
            <div class="kt-checkbox-inline">
								<label class="kt-checkbox">
									<input type="checkbox" value="1" <?php if($employee->communicate_email) echo 'checked="checked"';?> name="communicate_email" checked=""> Email
									<span></span>
								</label>
								<label class="kt-checkbox">
									<input type="checkbox" value="1" <?php if($employee->communicate_sms) echo 'checked="checked"';?> name="communicate_sms" checked=""> SMS
									<span></span>
								</label>
								<label class="kt-checkbox">
									<input type="checkbox" value="1" name="communicate_phone" <?php if($employee->communicate_phone) echo 'checked="checked"';?>> Phone
									<span></span>
								</label>
							</div>
          </div>
        </div>
        <div class="form-group row">
          <label class="col-9 col-form-label"></label>
          <div class="col-3">
            <button type="submit" class="btn btn-sm btn-block btn-warning" name="button"><b>Save Changes</b></button>
          </div>
        </div>
      </div>
    </div>
  </form>
<script type="text/javascript">

function showPassword(){
  let input = $("#passwordInput");
  input.prop({type:"text"});
}

function hidePassword(){
  let input = $("#passwordInput");
  input.prop({type:"password"});
}

function checkemail(employee,email){
  let spinner = $('div#spinnerEmail');
  let input = $('input#email');
  event.preventDefault();
  $.ajax({
   url: '<?php echo base_url($auth_role.'/hrm/employees/index/checkemail/'.$employee->user_id.'/');?>' + encodeURIComponent(email),
    type: 'get',
    beforeSend: function(){
        spinner.addClass('kt-spinner');
        input.removeClass('is-valid is-invalid');
      },
     success: function(r){
          var obj = JSON.parse(r);
          spinner.removeClass('kt-spinner');
          if(obj.status == 'ok'){
            input.addClass('is-valid');
            }else{
              input.addClass('is-invalid');
            }
         },
      error: function(){
        spinner.removeClass('kt-spinner');
        Swal.fire('',obj.message,'warning');
          }
  });
}

function checkusername(employee,username){
  let spinner = $('div#spinnerUsername');
  let input = $('input#username');
  event.preventDefault();
  $.ajax({
   url: '<?php echo base_url($auth_role.'/hrm/employees/index/checkusername/'.$employee->user_id.'/');?>' + encodeURIComponent(username),
    type: 'get',
    beforeSend: function(){
        spinner.addClass('kt-spinner');
        input.removeClass('is-valid is-invalid');
      },
     success: function(r){
          var obj = JSON.parse(r);
          spinner.removeClass('kt-spinner');
          if(obj.status == 'ok'){
            input.addClass('is-valid');
            }else{
              input.addClass('is-invalid');
            }
         },
      error: function(xhr){
        spinner.removeClass('kt-spinner');
        Swal.fire('',xhr.statusText,'warning');
          }
  });
}

$('form#employeesForm').submit( function(event){
  let form = $( this );
  let $div =  $('div#kt_page_portlet');
  event.preventDefault();
  let formdata = form.serialize();
  $.ajax({
   url: '<?php echo base_url($auth_role.'/hrm/employees/index/loadInformationSecurityAction/'.$employee->user_id);?>' ,
    type: 'get',
    data: formdata,
    beforeSend: function(){
        KTApp.block($div,{
                overlayColor:"#000000",
                type:"loader",
                state:"success",
                message:"Updating Security information ...."
            });
      },
     success: function(r){
          var obj = JSON.parse(r);
          if(obj.status == 'ok'){
            $div.load("<?php echo base_url($auth_role.'/hrm/employees/index/loadInformationSecurity/'.$employee->user_id);?>");
            Swal.fire('',obj.message,'success');
            }else{
                Swal.fire('',obj.message,'warning');
            }
            KTApp.unblock($div);
         },
      error: function(){
        Swal.fire('',obj.message,'success');
          KTApp.unblock($div);
          }
  });
})
$( function(){
  $('select#levels').select2({placeholder: 'Select level'});
  $('select#titles').select2({placeholder: 'Select title'});
})
</script>
