<?php
  $totalper = $total_advance > 0 ? ($total_advance/$total_advance) * 100 : 0;
  $due = $total_advance - $paid_advance;
  $dueper = $total_advance > 0 ? ($due/$total_advance) * 100 : 0;
  $paidper = $total_advance > 0 ? ($paid_advance/$total_advance) * 100 : 0;
?>
<div class="" id="summary">
  <div class="kt-widget25" style="margin-top:0px;">
  		<span class="kt-widget25__stats m-font-brand"><?php echo runnCurrency()->currency_symbol;?><?php echo number_format(to_money($due));?></span>
  		<span class="kt-widget25__subtitle">Total Amount Allowable</span>
  		<div class="kt-widget25__items">
  			<div class="kt-widget25__item">
  				<span class="kt-widget25__number">
  					<?php echo number_format(to_money($paid_advance));?>
  				</span>
  				<div class="progress kt-progress--sm">
  					<div class="progress-bar kt-bg-success" role="progressbar" style="width:<?php echo $paidper;?>%;" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100"></div>
  				</div> 
  				<span class="kt-widget25__desc">
  					Advance Allowable
  				</span>
  			</div>
  			<div class="kt-widget25__item">
  				<span class="kt-widget25__number">
  					<?php echo number_format(to_money($due));?>
  				</span>
  				<div class="progress m-progress--sm">
  					<div class="progress-bar kt-bg-danger" role="progressbar" style="width: <?php echo $dueper;?>%;" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100"></div>
  				</div>
  				<span class="kt-widget25__desc">
  				Advance Taken
  				</span>
  			</div>
  			<div class="kt-widget25__item">
  				<span class="kt-widget25__number">
  					<?php echo number_format(to_money($total_advance));?>
  				</span>
  				<div class="progress m-progress--sm">
  					<div class="progress-bar kt-bg-brand" role="progressbar" style="width: <?php echo $totalper;?>%;" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100"></div>
  				</div>
  				<span class="kt-widget25__desc">
  					Available Sallary
  				</span>
  			</div>
  		</div>
  	</div>
    <hr/>
</div>
<form id="employeesForm" onsubmit="return false;" class="kt-form">
      <div class="kt-section kt-section--first">
        <div class="kt-section__body">
          <div class="row">
            <div class="col-5">
              <div class="alert alert-outline-brand" role="alert">
                <div class="alert-text">
                  <h4 class="alert-heading">NOTE</h4>
                  <p>All depts added here will apply on the next <b>Sallary Slip</b></p>
                </div>
              </div>
            </div>
            <div class="col-7">
              <div class="form-group row">
                <div class="col-12">
                  <textarea rows="2" name="details" class="form-control" type="text" placeholder="Dept details"></textarea>
                </div>
              </div>
              <div class="form-group row">
                <div class="col-8">
                  <input name="amount" class="form-control number" placeholder="Enter advance amount">
                </div>
                <div class="col-4">
                  <button type="submit" class="btn btn-block btn-brand text-uppercase"><b>process</b></button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
</form>
<div class="row">
    <div class="col-md-8">
      <input style="border:1px solid white;"  class="form-control bg-dark" placeholder="Search a record" id="generalSearch">
    </div>
    <button type="button" class="btn btn-label-danger col-md-2" name="button">Delete All</button>
</div><br/>
<div class="kt-datatable" id="api_methods"></div>
<div class="modal fade" id="modify" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterCharge" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-md" role="document">
      <div class="modal-content" style="border:0px;">
        <div class="modal-header bg-dark">
          <h5 class="modal-title text-white" id="exampleModalLongCharge">Dept Details</h5>
          <a data-dismiss="modal" href="javascript:(0);" modal-dismiss="modal" class="pull-right modal-title text-white">
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon">
                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <rect id="bound" x="0" y="0" width="24" height="24"/>
                    <path d="M7.62302337,5.30262097 C8.08508802,5.000107 8.70490146,5.12944838 9.00741543,5.59151303 C9.3099294,6.05357769 9.18058801,6.67339112 8.71852336,6.97590509 C7.03468892,8.07831239 6,9.95030239 6,12 C6,15.3137085 8.6862915,18 12,18 C15.3137085,18 18,15.3137085 18,12 C18,9.99549229 17.0108275,8.15969002 15.3875704,7.04698597 C14.9320347,6.73472706 14.8158858,6.11230651 15.1281448,5.65677076 C15.4404037,5.20123501 16.0628242,5.08508618 16.51836,5.39734508 C18.6800181,6.87911023 20,9.32886071 20,12 C20,16.418278 16.418278,20 12,20 C7.581722,20 4,16.418278 4,12 C4,9.26852332 5.38056879,6.77075716 7.62302337,5.30262097 Z" id="Oval-25" fill="#000000" fill-rule="nonzero"/>
                    <rect id="Rectangle" fill="#000000" opacity="0.3" x="11" y="3" width="2" height="10" rx="1"/>
                </g>
            </svg></a>
        </div>
        <div class="kt-scroll lm_max_height">
          <div class="modal-body text-back" id="printArea">

          </div>
        </div>
        <div class="modal-footer bg-dark">
        <small> &copy <?php echo date('Y') ;?> <?php echo config_item('application_name');?> | Dept details</small>
        </div>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript">
function modify(dept){
  let $modal =  $('div#modify');
  let $div = $modal.find('.modal-body');
  $div.html('');
  $modal.modal('show');
  $.ajax({
    url: '<?php echo base_url($auth_role.'/hrm/employees/index/modifysallaryadvance/'.$employee->user_id);?>' + '/' + dept,
    type: 'get',
    beforeSend: function(){
    KTApp.block($div,{
            overlayColor:"#000000",
            type:"loader",
            state:"success",
            message:"Loading dept details ...."
        });
    },
    success: function (result){
      $div.html(result);
      KTApp.unblock($div);
    },
    error: function (xhr){
      $modal.modal('hide');
      KTApp.unblock($div);
      Swal.fire('',xhr.statusText,'warning');
    }
  })
}
(function($, undefined) {
    "use strict";
    // When ready.
    $(function() {
      var $input = $( "input.number" );
      $input.on( "keyup", function( event ) {
          // When user select text in the document, also abort.
          var selection = window.getSelection().toString();
          if ( selection !== '' ) {
              return;
          }
          // When the arrow keys are pressed, abort.
          if ( $.inArray( event.keyCode, [38,40,37,39] ) !== -1 ) {
              return;
          }
          var $this = $( this );
          // Get the value.
          var input = $this.val();
          var input = input.replace(/[\D\s\._\-]+/g, "");
          input = input ? parseInt( input, 10 ) : 0;
          $this.val( function() {
              return ( input === 0 ) ? "" : input.toLocaleString( "en-US" );
          } );
      });
    });
})(jQuery);

$('form#employeesForm').submit( function(event){
  let form = $( this );
  let $div =  $('div.kt-datatable');
  event.preventDefault();
  let formdata = form.serialize();
  $.ajax({
   url: '<?php echo base_url($auth_role.'/hrm/employees/index/loadInformationsallaryadvances/'.$employee->user_id);?>' ,
    type: 'get',
    data: formdata,
    beforeSend: function(){
        KTApp.block($div,{
                overlayColor:"#000000",
                type:"loader",
                state:"success",
                message:"Adding dept information ...."
            });
      },
     success: function(r){
          var obj = JSON.parse(r);
          if(obj.status == 'ok'){
            $('form#employeesForm')[0].reset();
            reloadsummary();
            $('.kt-datatable').KTDatatable('reload');
            notifySuccess(obj.message);
            }else{
                Swal.fire('',obj.message,'brand');
            }
            KTApp.unblock($div);
         },
      error: function(){
        Swal.fire('',obj.message,'success');
          KTApp.unblock($div);
          }
  });
})

function deleteItem(dept){
  Swal.fire({
    title: 'Are you sure?',
    text: "You won't be able to revert this!",
    type: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'Yes, delete it!'
  }).then((result) => {
    if (result.value) {
      $.ajax({
          url: '<?php echo base_url($auth_role.'/hrm/employees/index/delete/sallaryadvance')?>/' + dept,
          type: 'get',
          beforeSend: function(){
              KTApp.block(".kt-datatable",{
                      overlayColor:"#000000",
                      type:"loader",
                      state:"danger",
                      message:"Deleting Dept ..."
                  });
            },
           success: function(result){
               let obj = JSON.parse(result);
                   if( obj.status == 'ok'){
                      notifySuccess(obj.message);
                      reloadsummary();
                      $('.kt-datatable').KTDatatable('reload');
                    }else{
                      Swal.fire('',obj.message,'warning');
                    }
               KTApp.unblock('.kt-datatable');
               },
            error: function(xhr){
                KTApp.unblock('.kt-datatable');
                Swal.fire('',xhr.statusText,'warning');
                }
      });
    }
  })
}

function reloadsummary(){
  $('div#summary').load('<?php echo base_url($auth_role.'/hrm/employees/index/employeesallaryadvancesummary/'.$employee->user_id);?>');
}

"use strict";
// Class definition

var KTDefaultDatatableDemo = function() {
  // Private functions

  // basic demo
  var demo = function() {

    var options = {
      // datasource definition
      data: {
        type: 'remote',
        source: {
          read: {
            url: '<?php echo base_url($auth_role.'/hrm/employees/index/datasourcesallaryadvances/'.$employee->user_id);?>',
          },
        },
        pageSize: 10, // display 20 records per page
        serverPaging: true,
        serverFiltering: true,
        serverSorting: true,
      },

      // layout definition
      layout: {
        scroll: false, // enable/disable datatable scroll both horizontal and vertical when needed.
        //height: 400, // datatable's body's fixed height
        footer: false, // display/hide footer
      },

      // column sorting
      sortable: true,

      pagination: true,

      search: {
        input: $('#generalSearch'),
      },

      // columns definition
      columns: [
        {
          field: 'id',
          title: '#',
          sortable: false,
          width: 30,
          type: 'number',
          selector: {class: 'kt-checkbox--solid'},
          textAlign: 'center',
          locked: {left: 'lg'},
        }, {
          field: 'ad_amount',
          title: 'Amount',
          template: function(row) {
            return to_money(row.ad_amount);
          },
          locked: {left: 'lg'},
        },{
          field: 'ad_date',
          title: 'Date',
        }, {
          field: 'ad_details',
          title: 'Description',
        },{
          field: 'ad_actions',
          title: 'Actions',
          locked: {right: 'lg'},
        }
      ],
    };

    var datatable = $('.kt-datatable').KTDatatable(options);

    $('#kt_form_status,#kt_form_type').selectpicker();

  };

  return {
    // public functions
    init: function() {
      demo();
    },
  };
}();

jQuery(document).ready(function() {
  KTDefaultDatatableDemo.init();
});


</script>
