<?php
if(!empty($_GET['when'])) {
    $when = htmlspecialchars(strtolower(urldecode(trim($_GET['when']))));
}else{
    $when ='';
}
?>
<script type="text/javascript">

  //== Class definition
  $.fn.dataTable.Api.register('column().title()', function() {
      return $(this.header()).text().trim();
  });

var Datatable = function() {

	var initTable = function() {
		var table = $('#lm_table');

		// begin first table
		table.DataTable({
			responsive: true,
            buttons: [
                'print',
                'copyHtml5',
                'excelHtml5',
                'csvHtml5',
                'pdfHtml5',
            ],
            dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
			<'row'<'col-sm-12'tr>>
			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
			searchDelay: 500,
			processing: true,
			serverSide: true,
			ajax: '<?php echo base_url($auth_role.'/expenses/index/datasource/'.$when);?>',
			columns: [
				{data: 'expense_key'},
                {data: 'expense_date'},
				{data: 'employee'},
                {data: 'category_title'},
				{data: 'type_title'},
                {data: 'expense_amount'},
                {data: 'expense_paid'},
                {data: 'expense_payee'},
                {data: 'expense_details'},
                {data: 'expense_status'},
                {data: 'budget_title'},
			],
            initComplete: function() {
                this.api().columns().every(function() {
                    var column = this;

                    switch (column.title()) {
                        case 'Employee':
                            column.data().unique().sort().each(function(d, j) {
                                $('.kt-input[data-col-index="2"]').append('<option value="' + d + '">' + d + '</option>');
                            });
                            break;
                        case 'Type':
                            column.data().unique().sort().each(function(d, j) {
                                $('.kt-input[data-col-index="4"]').append('<option value="' + d + '">' + d + '</option>');
                            });
                            break;
                        case 'Category':
                            column.data().unique().sort().each(function(d, j) {
                                $('.kt-input[data-col-index="3"]').append('<option value="' + d + '">' + d + '</option>');
                            });
                            break;
                        case 'Status':
                            var status = {
                                "Pending": {'expense_status': 'Pending', 'class': 'kt-badge--brand'},
                                "Approved": {'expense_status': 'Approved', 'class': 'kt-badge--success'},
                                "Rejected": {'expense_status': 'Rejected', 'class': 'kt-badge--danger'},
                                "Pending Reject": {'expense_status': 'Pending Reject', 'class': 'kt-badge--warning'},
                            };
                            column.data().unique().sort().each(function(d, j) {
                                $('.kt-input[data-col-index="6"]').append('<option value="' + d + '">' + status[d].expense_status + '</option>');
                            });
                            break;
                    }
                });
            },
            columnDefs: [
                {
                    targets: 0,
                    "width": "3%",render: function(data, type, full, meta) {
                        return  '<a href="#expense-details" data-toggle="modal" data-backdrop="static" data-key="'+ full.expense_key +'">' + full.expense_key + '</a>';
                    },

                },
                {
                    targets: 1,
                    "width": "7%",
                },
                {
                    targets: 2,
                    "width": "10%",
                    render: function(data, type, full, meta) {
                        return  '<a  href="<?php echo base_url($auth_role.'/expenses/employees');?>">' + full.employee + '</a>';
                    },
                },
                {
                    targets: 3,
                    "width": "10%",
                    render: function(data, type, full, meta) {
                        return  '<a  href="<?php echo base_url($auth_role.'/expenses/categories');?>">' + full.category_title + '</a>';
                    },
                },
                {
                    targets: 4,
                    "width": "10%",
                    render: function(data, type, full, meta) {
                        return  '<a  href="<?php echo base_url($auth_role.'/expenses/types');?>">' + full.type_title + '</a>';
                    },
                },{
                    targets: 5,
                    "width": "5%",
                    render: function(data, type, full, meta) {
                        return  numeral(to_money(full.expense_amount)).format('0,0') ;
                    },
                },{
                    targets: 6,
                    "width": "5%",
                    render: function(data, type, full, meta) {
                        return  numeral(to_money(full.expense_paid)).format('0,0') ;
                    },
                },
                {
                    // hide columns by index number
                    targets: 7,
                    "width": "15%",

                },{
                    // hide columns by index number
                    targets: 8,
                    "width": "10%",
                    visible: false,
                },
                {
                    targets: 9,
                    "width": "15%",
                    render: function(data, type, full, meta) {
                        var status = {
                            "Approved": {'expense_status': 'Approved', 'class': 'kt-badge--success'},
                            "Pending": {'expense_status': 'Pending', 'class': ' kt-badge--warning'},
                            "Rejected": {'expense_status': 'Rejected', 'class': ' kt-badge--danger'},
                            "Pending Reject": {'expense_status': 'Pending Rejected', 'class': ' kt-badge--dark'},
                        };
                        if (typeof status[data] === 'undefined') {
                            return data;
                        }
                        return '<a href="#expense-details" data-toggle="modal" data-backdrop="static" data-key="'+ full.expense_key +'"><span class="kt-badge ' + status[data].class + ' kt-badge--wide kt-badge--inline kt-font-bolder">' + status[data].expense_status + '</span></a> ' +
                            '<div class="dropdown dropdown-inline">\n' +
                            '                            <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                            '                                <i class="flaticon-more"></i>\n' +
                            '                            </span>\n' +
                            '                            <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                            '                                <a class="dropdown-item"  href="javascript:setExpenseStatusApproved('+ full.expense_key + ');"><i class="la la-toggle-off kt-font-success"></i> Set Approved</a>\n' +
                            '                                <a class="dropdown-item"  href="javascript:setExpenseStatusPending('+ full.expense_key +');"><i class="la la-toggle-off kt-font-warning"></i> Set Pending</a>\n' +
                            '                                <a class="dropdown-item" href="javascript:setExpenseStatusRejected('+ full.expense_key +');"><i class="la la-toggle-off kt-font-danger"></i> Set Rejected</a>\n' +
                            '                                <a class="dropdown-item" href="javascript:setExpenseStatusPendingReject('+ full.expense_key +');"><i class="la la-toggle-off kt-font-dark"></i> Set Pending Rejected</a>\n' +
                            '                                <div class="dropdown-divider"></div>' +
                            '                                <a class="dropdown-item" data-backdrop="static" data-toggle="modal" data-key="'+ full.expense_key +'" href="#expense-details"><i class="la la-cog"></i> Details</a>\n' +
                            '                            </div>\n' +
                            '                        </div>';
                    },
                },

                {
                    targets: 10 ,
                    "width": "10%",
                    render: function(data, type, full, meta) {
                        return  '<a  href="<?php echo base_url($auth_role.'/expenses/budgets/detailsr/');?>' + full.budget_key + '">' + full.budget_title + '</a>';
                    },
                },
            ],
		});

        var filter = function() {
            var val = $.fn.dataTable.util.escapeRegex($(this).val());
            let table = $.fn.dataTable.tables( { api: true } );
            table.column($(this).data('col-index')).search(val ? val : '', false, false).draw();
        };

        var asdasd = function(value, index) {
            let table = $.fn.dataTable.tables( { api: true } );
            var val = $.fn.dataTable.util.escapeRegex(value);
            table.column(index).search(val ? val : '', false, true);
        };

        $('#m_search').on('click', function(e) {
            e.preventDefault();
            let table = $.fn.dataTable.tables( { api: true } );
            var params = {};
            $('.kt-input').each(function() {
                var i = $(this).data('col-index');
                if (params[i]) {
                    params[i] += '|' + $(this).val();
                }
                else {
                    params[i] = $(this).val();
                }
            });
            $.each(params, function(i, val) {
                // apply search params to datatable
                table.column(i).search(val ? val : '', false, false);
            });
            table.table().draw();
        });

        $('#m_reset').on('click', function(e) {
            e.preventDefault();
            let table = $.fn.dataTable.tables( { api: true } );
            $('.kt-input').each(function() {
                $(this).val('');
                table.column($(this).data('col-index')).search('', false, false);
            });
            table.table().draw();
        });

        $('#kts_datepicker').datepicker({
            todayHighlight: true,
            templates: {
                leftArrow: '<i class="la la-angle-left"></i>',
                rightArrow: '<i class="la la-angle-right"></i>',
            },
        });
	};

	return {

		//main function to initiate the module
		init: function() {
			initTable();
		},

	};

}();

    jQuery(document).ready(function() {
        Datatable.init();
    });
</script>
