<?php
$lm =& get_instance();
$budgets = $lm->expensesBudgetsModel->budgets();
$categories = $lm->expensesCategoriesModel->categories();
$accounts = $lm->accountingModel->cashAccounts();
?>
<?php echo form_open('#',['id'=>'expense-form','onsubmit'=>'submitform(); return false;']);?>
<div class="row form-group">
    <div class="col-4">
        <select name="expense_budget" class="form-control" required style="width: 100%;" >
            <option value="">Select Budget</option>
            <?php if(!empty($budgets)){
                foreach ($budgets as $b => $budget){?>
                    <option value="<?php echo $budget['budget_key'];?>"><?php echo $budget['budget_title'];?></option>
                <?php }
            } ?>
        </select>
    </div>
    <div class="col-4" >
        <select name="expense_category" class="form-control" required id="expense-categories" style="width: 100%;">
            <option value="">Select Category</option>
            <?php if(!empty($categories)){
                foreach ($categories as $b => $category){?>
                    <option value="<?php echo $category['category_key'];?>"><?php echo $category['category_title'];?></option>
                <?php }
            } ?>
        </select>
    </div>
    <div class="col-4" id="expense-types">
        <select name="expense_type" class=" form-control" required style="width: 100%;">
            <option value="">Select Type</option>
        </select>
    </div>
</div>
<div class="row form-group">
    <div class="col-4">
        <input type="text" required  name="expense_amount" placeholder="Expense Amount " class="form-control number" />
    </div>
    <div class="col-4">
        <input type="text" required  name="expense_paid" placeholder="Expense Paid" class="form-control number" />
    </div>
    <div class="col-4" >
        <select name="expense_withdraw_account" class="form-control" required style="width: 100%;">
            <option value="">Withdraw Account</option>
            <?php if(!empty($accounts)){
                foreach ($accounts as $b => $acc){?>
                    <option value="<?php echo $acc['account_id'];?>"><?php echo $acc['account_name'];?></option>
                <?php }
            } ?>
        </select>
    </div>
</div>
<div class="row form-group">
    <div class="col-4">
        <select required name="expense_status" class="form-control">
            <option value="">Select Status</option>
            <option  value="Approved">Approved</option>
            <option  value="Pending">Pending</option>
            <option  value="Rejected">Rejected</option>
            <option  value="Pending Reject">Pending Reject</option>
        </select>
    </div>
    <div class="col-md-4 col-sm-12">
        <input type="date" required  name="expense_date_posted" placeholder="Date posted" class="form-control" />
    </div>
    <div class="col-md-4 col-sm-12">
        <input type="text" required  name="expense_payee" placeholder="Enter Expense payee" class="form-control" />
    </div>
</div>
<div class="row form-group">
    <div class="col-12">
        <textarea required name="expense_details" class="form-control" placeholder="Enter expense description" ></textarea>
    </div>
</div>
<div class="row form-group">
    <div class="col-12">
        <div class="m-dropzone dropzone m-dropzone--primary dz-clickable"  id="expense-docs">
            <div class="m-dropzone__msg dz-message needsclick">
                <h3 class="m-dropzone__msg-title">Drop files here or click to upload.</h3>
                <span class="m-dropzone__msg-desc">Upload up to 10 files</span>
            </div>
        </div>
    </div>
</div>
<div class="row form-group">
    <div class="col-4"></div>
    <div class="col-4">
        <button type="button" data-dismiss="modal" class="btn btn-dark btn-block text-uppercase">Close</button>
    </div>
    <div class="col-4">
        <button type="submit" class="btn btn-success btn-block text-uppercase">Register Expense</button>
    </div>
</div>
<input type="hidden" class="form-control" id="uploadedfiles" name="uploadedfiles" />
<?php form_close();?>
<script type="text/javascript">

    $(function(){
        $('select').select2();

        $('select#expense-categories').change( function(){
            let val = $( this ).val();
            if(val == '')
                return;
            let form =  $('form#expense-form');
            let types = $('div#expense-types');

            $.ajax({
                url: '<?php echo base_url($auth_role.'/expenses/index/getselecttypes/');?>' + val ,
                type: 'get',
                beforeSend: function(){
                    KTApp.block(form,{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"success",
                        message:"Loading ..."
                    });
                },
                success: function (result){
                    types.html(result);
                    KTApp.unblock(form);
                },
                error: function (xhr){
                    KTApp.unblock(form);
                    Swal.fire('',xhr.statusText,'warning');
                }
            })
        })
    })

    Dropzone.autoDiscover = false;
    var options = {
        url: "<?php echo base_url($auth_role.'/expenses/index/uploadexpensedocs');?>",
        paramName: "file", // The name that will be used to transfer the file
        maxFiles: 10,
        maxFilesize: 3, // MB
        success: function(file, response){
            let oldValue = $('input#uploadedfiles').val();
            if(oldValue.length > 0){
                oldValue = oldValue + 'LM-55';
            }
            let newValue =  oldValue + response.files;
            $('input#uploadedfiles').val(newValue);
        },
    };
    var expsenseDocs = new Dropzone("div#expense-docs",options);
</script>