<?php
$budgets = $this->expensesModel->budgets();
$categories = $this->expensesModel->categories();
?>
<?php echo form_open('#',['id'=>'saveexpenserequest','onsubmit'=>'saveexpenserequest(); return false;']);?>
<div class="row">
    <div class="col-12 alert alert-danger alert-dismissible fade show   m-alert m-alert--air m-alert--outline m-alert--outline-2x">
        <input required type="password" class="form-control" placeholder="Enter administrator password" name="kelly">
    </div>
</div>
<div class="row form-group">
    <div class="col-4">
        <label>Expense Badget</label>
        <select readonly  name="expense_budget" class="form-control" required >
            <option value="">Select Budget</option>
            <?php if(!empty($budgets)){
                foreach ($budgets as $b => $budget){?>
                    <option <?php if($expense->expense_budget == $budget['budget_id']) echo 'selected';?> value="<?php echo $budget['budget_id'];?>"><?php echo $budget['budget_title'];?></option>
                <?php }
            } ?>
        </select>
    </div>
    <div class="col-4" >
        <label>Expense Category</label>
        <select readonly name="expense_category" class="form-control" required id="expense-categories">
            <option value="">Select Category</option>
            <?php if(!empty($categories)){
                foreach ($categories as $b => $category){?>
                    <option <?php if($expense->expense_category == $category['category_id']) echo 'selected';?> value="<?php echo $category['category_id'];?>"><?php echo $category['category_title'];?></option>
                <?php }
            } ?>
        </select>
    </div>
    <div class="col-4" id="expense-types">
        <label>Expense Type</label>
        <select  readonly name="expense_type" class=" form-control" required>
            <option value="">Select Type</option>
            <option selected value="<?php echo $expense->expense_type;?>"><?php echo $expense->type_title;?></option>

        </select>
    </div>
</div>
<div class="row form-group">
    <div class="col-6">
        <label>Expense Amount</label>
        <input readonly type="text" required  name="expense_amount" placeholder="Expense Amount " class="form-control number" value="<?php echo number_format($expense->expense_amount);?>" />
    </div>
    <div class="col-6">
        <label>Expense Amount Paid</label>
        <input  readonly type="text" required  name="expense_paid" placeholder="Expense Amount Paid" class="form-control number" value="<?php echo number_format($expense->expense_paid);?>" />
    </div>
</div>
<div class="row form-group">
    <div class="col-12">
        <label>Expense Payee</label>
        <input readonly type="text" required  name="expense_payee" placeholder="Enter Expense payee" class="form-control" value="<?php echo $expense->expense_payee;?>" />
    </div>
</div>
<div class="row form-group">
    <div class="col-12">
        <label>Expense Details</label>
        <textarea readonly required name="expense_details" class="form-control" ><?php echo nl2br($expense->expense_admin_remark);?></textarea>
    </div>
</div>
<div class="row form-group">
    <div class="col-12">
        <label>Cancel Resoan</label>
        <textarea readonly required name="expense_details" class="form-control" ><?php echo nl2br($expense->expense_request_cancel_reason);?></textarea>
    </div>
</div>
<div class="row form-group">
    <div class="col-12">
        <label>Administrator Remark</label>
        <textarea required name="expense_details" class="form-control" ><?php echo nl2br($expense->expense_admin_remark);?></textarea>
    </div>
</div>
<?php if($files = $this->expensesModel->expenseDocs($expense->expense_id)){?>
    <div class="row form-group">
        <div class="col-12">
            <div class="m-alert m-alert--icon alert alert-primary-outline" role="alert">
                <div class="m-alert__icon">
                    <i class="la la-warning"></i>
                </div>
                <div class="m-alert__text">
                    <strong>This expense has documents</strong><br/>
                        <?php foreach ($files as $key =>  $file){?>
                                <a href="<?php echo base_url('uploads/expenses/'.$file['doc_name']);?>" download><?php echo $key+1;?> View file</a>&nbsp;
                        <?php } ?>
                </div>
            </div>
        </div>
    </div>
<?php } ?>

<div class="row form-group">
    <div class="col-6">
        <label>Status</label>
        <select class="form-control" name="expense_status">
            <option>Select Status</option>
            <option value="0">Pending</option>
            <option value="1">Approved</option>
            <option value="2">Rejected</option>
        </select>
    </div>
    <div class="col-3">
        <label>&nbsp</label>
        <button type="submit" class="btn btn-success btn-block text-uppercase">Save Changes</button>
    </div>
    <div class="col-3">
        <label>&nbsp</label>
        <button type="button" data-dismiss="modal" class="btn btn-dark btn-block text-uppercase">cancel</button>
    </div>
</div>
<?php form_close();?>
<script>

    $('select').select2();
    $('select#expense-categories').change( function(){
        let val = $( this ).val();
        if(val == '')
            return;
        let form =  $('form#expense-form');
        let types = $('div#expense-types');

        $.ajax({
            url: '<?php echo base_url('admin/managers/expenses/index/getselecttypes/');?>' + val ,
            type: 'get',
            beforeSend: function(){
                mApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Loading ..."
                });
            },
            success: function (result){
                types.html(result);
                mApp.unblock(form);
            },
            error: function (xhr){
                mApp.unblock(form);
                Swal('',xhr.statusText,'warning');
            }
        })
    })

    function saveexpenserequest(){
        let form = $('form#saveexpenserequest');
        let formData = form.serialize();
        $.ajax({
            url: '<?php echo base_url('admin/managers/expenses/index/saveexpenserequest/'.$expense->expense_id);?>',
            type: 'get',
            data: formData,
            beforeSend: function(){
                mApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Saving data ..."
                });
            },
            success: function (result){
                if(result.status == true){
                    $('#expense-details').modal('hide');
                    Swal('',result.msg,'success');
                    form[0].reset();
                    let table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                }else{
                    Swal('',result.msg,'warning');
                }
                mApp.unblock(form);

            },
            error: function (xhr){
                mApp.unblock(form);
                Swal('',xhr.statusText,'warning');
            }
        })
    }

    (function($, undefined) {

        "use strict";

        // When ready.
        $(function() {

            var $input = $( "input.number" );

            $input.on( "keyup", function( event ) {


                // When user select text in the document, also abort.
                var selection = window.getSelection().toString();
                if ( selection !== '' ) {
                    return;
                }

                // When the arrow keys are pressed, abort.
                if ( $.inArray( event.keyCode, [38,40,37,39] ) !== -1 ) {
                    return;
                }


                var $this = $( this );

                // Get the value.
                var input = $this.val();

                var input = input.replace(/[\D\s\._\-]+/g, "");
                input = input ? parseInt( input, 10 ) : 0;

                $this.val( function() {
                    return ( input === 0 ) ? "" : input.toLocaleString( "en-US" );
                } );
            } );

        });
    })(jQuery);
</script>

