<?php
if(!empty($_GET['when'])) {
    $when = htmlspecialchars(strtolower(urldecode(trim($_GET['when']))));
}else{
    $when ='';
}
?>
<script type="text/javascript">

    //== Class definition
    $.fn.dataTable.Api.register('column().title()', function() {
        return $(this.header()).text().trim();
    });

    var Datatable = function() {

        var initTable = function() {
            var table = $('#lm_categories');

            // begin first table
            table.DataTable({
                responsive: true,
                buttons: [
                    'print',
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                ],
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
        <'row'<'col-sm-12'tr>>
        <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                searchDelay: 500,
                processing: true,
                serverSide: true,
                ajax: '<?php echo base_url($auth_role.'/expenses/categories/index/datasource/'.$when);?>',
                columns: [
                    {data: 'category_title'},
                    {data: 'category_date'},
                    {data: 'account_name'},
                    {data: 'category_spent'},
                    {data: 'category_status'},
                ],
                columnDefs: [
                    {
                        targets: 0,
                        "width": "15%",
                        render: function(data, type, full, meta) {
                            return  '<a  href="#category-details" data-toggle="modal" data-key="'+ full.category_key +'">' + full.category_title + '</a>';
                        },
                    },{
                        targets: 3,
                        "width": "5%",
                        render: function(data, type, full, meta) {
                            return  numeral(to_money(full.category_spent)).format('0,0') ;
                        },
                    },{
                        targets: 4,
                        "width": "10%",
                        render: function(data, type, full, meta) {
                            var status = {
                                "Active": {'category_status': 'Active', 'class': 'kt-badge--success'},
                                "Pending": {'category_status': 'Approved', 'class': ' kt-badge--warning'},
                                "Rejected": {'category_status': 'Rejected', 'class': ' kt-badge--danger'},
                                "Pending Reject": {'category_status': 'Rejected', 'class': ' kt-badge--info'},
                            };
                            if (typeof status[data] === 'undefined') {
                                return data;
                            }
                            return '<a href="#category-details" data-toggle="modal" data-backdrop="static" data-key="'+ full.category_key +'"><span class="kt-badge ' + status[data].class + ' kt-badge--wide kt-badge--inline kt-font-bolder">' + status[data].category_status + '</span></a> ' +
                                '<div class="dropdown dropdown-inline">\n' +
                                '                            <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                '                                <i class="flaticon-more"></i>\n' +
                                '                            </span>\n' +
                                '                            <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                '                                <a class="dropdown-item" data-backdrop="static" data-toggle="modal" data-key="'+ full.category_key +'" href="#expenditure-details"><i class="la la-money"></i> Expenditure</a>\n' +
                                '                                <div class="dropdown-divider"></div>' +
                                '                                <a class="dropdown-item" class="kt-font-danger kt-font-bolder"  href="javascript:deleteCategory('+ full.category_key +');"><i class="la la-trash kt-font-danger kt-font-bolder"></i> Delete</a>\n' +
                                '                                <a class="dropdown-item" data-backdrop="static" data-toggle="modal" data-key="'+ full.category_key +'" href="#category-details"><i class="la la-cog"></i> Details</a>\n' +
                                '                            </div>\n' +
                                '                        </div>';
                        },
                    }
                ],
            });

            var filter = function() {
                var val = $.fn.dataTable.util.escapeRegex($(this).val());
                let table = $.fn.dataTable.tables( { api: true } );
                table.column($(this).data('col-index')).search(val ? val : '', false, false).draw();
            };

            var asdasd = function(value, index) {
                let table = $.fn.dataTable.tables( { api: true } );
                var val = $.fn.dataTable.util.escapeRegex(value);
                table.column(index).search(val ? val : '', false, true);
            };

            $('#kt_search').on('click', function(e) {
                e.preventDefault();
                let table = $.fn.dataTable.tables( { api: true } );
                var params = {};
                $('.kt-input').each(function() {
                    var i = $(this).data('col-index');
                    if (params[i]) {
                        params[i] += '|' + $(this).val();
                    }
                    else {
                        params[i] = $(this).val();
                    }
                });
                $.each(params, function(i, val) {
                    // apply search params to datatable
                    table.column(i).search(val ? val : '', false, false);
                });
                table.table().draw();
            });

            $('#kt_reset').on('click', function(e) {
                e.preventDefault();
                let table = $.fn.dataTable.tables( { api: true } );
                $('.kt-input').each(function() {
                    $(this).val('');
                    table.column($(this).data('col-index')).search('', false, false);
                });
                table.table().draw();
            });

            $('#kti_datepicker').datepicker({
                todayHighlight: true,
                templates: {
                    leftArrow: '<i class="la la-angle-left"></i>',
                    rightArrow: '<i class="la la-angle-right"></i>',
                },
            });
        };

        return {

            //main function to initiate the module
            init: function() {
                initTable();
            },

        };

    }();

    jQuery(document).ready(function() {
        Datatable.init();
    });
</script>
