<?php include VIEWPATH.'includes/css/base_style.php';?>
<?php include VIEWPATH.'includes/header.php';?>
<div class="m-content">
    <div class="m-portlet__body--fit">
        <?php expenseSummary();?>
    </div>

    <div class="m-portlet">
        <div class="m-portlet__body  m-portlet__body--no-padding">
            <div class="row m-row--no-padding m-row--col-separator-xl">
                <div class="col-md-3">
                    <!--begin:: Widgets/Profit Share-->
                    <div class="m-widget1">
                        <div class="m-widget1__item">
                            <h5>Report summary | <b><?php echo ucwords(datesWhen()['label']);?></b></h5><hr/>
                            <?php if(!empty($categories)){
                                foreach ($categories as $key => $category){?>
                                    <div class="m-widget1__item">
                                        <div class="row m-row--no-padding align-items-center">
                                            <div class="col">
                                                <h3 class="m-widget1__title">
                                                    <a href="<?php echo base_url('admin/managers/expenses/categories/details/'.$category['category_id']);?>"><?php echo $category['category_title'];?></a>
                                                </h3>
                                                <span class="m-widget1__desc">
                                                      Total expense
                                                </span>
                                            </div>
                                            <div class="col m--align-right">
                                                <span class="m-widget1__number m--font-brand">
                                                  <strong><?php echo moneyUnit($this->expensesModel->expenseTotalCategory($category['category_id'],datesWhen()['text']));?></strong>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                <?php }
                            }   ?>

                    </div>
                    <!--end:: Widgets/Profit Share-->
                </div>
                </div>
                <div class="col-md-9">
                    <div class="m-portlet__body">
                    <?php echo form_open(current_url());?>
                        <?php if(!empty($msg)){?>
                            <div class="form-group row">
                                <div class="col-12">
                                    <div class="alert alert-info"><?php echo $msg;?></div>
                                </div>
                            </div>
                        <?php } ?>
<!--                    <div class="row form-group">-->
<!--                        <div class="col-12">-->
<!--                            <textarea name="category_details" placeholder="Enter category details" class="form-control"></textarea>-->
<!--                        </div>-->
<!--                    </div>-->
                        <div class="row form-group">
                        <div class="col-8">
                            <input type="text" name="category_title" placeholder="Enter category name" class="form-control">
                        </div>
                        <div class="col-4">
                            <button type="submit" class="btn btn-success">Create category</button>
                        </div>
                    </div>
                    <?php echo form_close();?>
                    </div>
                <div class="m-portlet__body">
                    <table class="table table-striped">
                        <thead>
                            <tr><th>#</th>
                                <th>Category</th>
                                <th>Spent</th>
                                <th>Created</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(!empty($categories)){
                                foreach ($categories as $i => $cat){?>
                                    <tr><td><?php echo $i+1;?></td>
                                        <td><?php echo ucfirst($cat['category_title']);?></td>
                                        <td><?php echo number_format($this->expensesModel->expenseTotalCategory($cat['category_id']));?></td>
                                        <td><?php echo $cat['category_created_at'];?></td>
                                        <td>
                                            <a href="<?php echo base_url('admin/managers/expenses/categories/details/'.$cat['category_id']);?>" class="btn btn-sm btn-success">details</a>
                                            <a href="<?php echo base_url('admin/managers/expenses/categories?remove=true&cat='.$cat['category_id']);?>" class="btn btn-sm btn-danger">delete</a></td>
                                    </tr>
                                <?php }
                            } ?>
                        </tbody>
                    </table>
                </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
<!-- end:: Body -->
<?php include VIEWPATH.'includes/footer.php';?>
<?php include VIEWPATH.'includes/js/base_scripts.php';?>
<?php include __DIR__.'/scripts.php';?>
</body>
<!-- end::Body -->
</html>
