<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<link href="<?php echo base_url('resources');?>/assets/css/pages/wizard/wizard-2.css" rel="stylesheet" type="text/css" />
<!-- end::Head -->

<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?>
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <?php topToolBarCustomers('newcustomer');?>
    <!-- begin:: Content -->

    <div class="kt-container  kt-container--fluid  kt-grid__item kt-grid__item--fluid">
        <div class="kt-portlet">
            <div class="kt-portlet__body kt-portlet__body--fit">
                <div class="kt-grid  kt-wizard-v2 kt-wizard-v2--white" id="kt_wizard_v2" data-ktwizard-state="step-first">
                    <div class="kt-grid__item kt-wizard-v2__aside">

                        <!--begin: Form Wizard Nav -->
                        <div class="kt-wizard-v2__nav">

                            <!--doc: Remove "kt-wizard-v2__nav-items--clickable" class and also set 'clickableSteps: false' in the JS init to disable manually clicking step titles -->
                            <div class="kt-wizard-v2__nav-items kt-wizard-v2__nav-items--clickable">
                                <div class="kt-wizard-v2__nav-item" data-ktwizard-type="step" data-ktwizard-state="current">
                                    <div class="kt-wizard-v2__nav-body">
                                        <div class="kt-wizard-v2__nav-icon">
                                            <i class="flaticon-globe"></i>
                                        </div>
                                        <div class="kt-wizard-v2__nav-label">
                                            <div class="kt-wizard-v2__nav-label-title">
                                                Account Settings
                                            </div>
                                            <div class="kt-wizard-v2__nav-label-desc">
                                                Setup Your Account Details
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="kt-wizard-v2__nav-item" data-ktwizard-type="step">
                                    <div class="kt-wizard-v2__nav-body">
                                        <div class="kt-wizard-v2__nav-icon">
                                            <i class="flaticon-bus-stop"></i>
                                        </div>
                                        <div class="kt-wizard-v2__nav-label">
                                            <div class="kt-wizard-v2__nav-label-title">
                                                Setup Locations
                                            </div>
                                            <div class="kt-wizard-v2__nav-label-desc">
                                                Choose Your Location Map
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="kt-wizard-v2__nav-item" href="#" data-ktwizard-type="step">
                                    <div class="kt-wizard-v2__nav-body">
                                        <div class="kt-wizard-v2__nav-icon">
                                            <i class="flaticon-responsive"></i>
                                        </div>
                                        <div class="kt-wizard-v2__nav-label">
                                            <div class="kt-wizard-v2__nav-label-title">
                                                Business Information
                                            </div>
                                            <div class="kt-wizard-v2__nav-label-desc">
                                                Add customer business
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="kt-wizard-v2__nav-item" data-ktwizard-type="step">
                                    <div class="kt-wizard-v2__nav-body">
                                        <div class="kt-wizard-v2__nav-icon">
                                            <i class="flaticon-trophy"></i>
                                        </div>
                                        <div class="kt-wizard-v2__nav-label">
                                            <div class="kt-wizard-v2__nav-label-title">
                                                Security & Account
                                            </div>
                                            <div class="kt-wizard-v2__nav-label-desc">
                                                Username, Email, Password
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="kt-wizard-v2__nav-item" data-ktwizard-type="step">
                                    <div class="kt-wizard-v2__nav-body">
                                        <div class="kt-wizard-v2__nav-icon">
                                            <i class="flaticon-truck"></i>
                                        </div>
                                        <div class="kt-wizard-v2__nav-label">
                                            <div class="kt-wizard-v2__nav-label-title">
                                                Details Submit
                                            </div>
                                            <div class="kt-wizard-v2__nav-label-desc">
                                                register customer
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <!--end: Form Wizard Nav -->
                    </div>
                    <div class="kt-grid__item kt-grid__item--fluid kt-wizard-v2__wrapper">

                        <!--begin: Form Wizard Form-->
                        <form class="kt-form" id="new_customer">

                            <!--begin: Form Wizard Step 1-->
                            <div class="kt-wizard-v2__content" data-ktwizard-type="step-content" data-ktwizard-state="current">
                                <div class="kt-heading kt-heading--md">Enter your Account Details</div>
                                <div class="kt-form__section kt-form__section--first">
                                    <div class="kt-wizard-v2__form">
                                        <div class="form-group">
                                            <label>First Name</label>
                                            <input type="text" class="form-control" name="firstname" placeholder="First Name" value="">
                                            <span class="form-text text-muted">Please enter your first name.</span>
                                        </div>
                                        <div class="form-group">
                                            <label>Middle Name</label>
                                            <input type="text" class="form-control" name="middlename" placeholder="Middle Name" value="">
                                            <span class="form-text text-muted">Please enter your middle name.</span>
                                        </div>
                                        <div class="form-group">
                                            <label>Last Name</label>
                                            <input type="text" class="form-control" name="lastname" placeholder="Last Name" value="">
                                            <span class="form-text text-muted">Please enter your last name.</span>
                                        </div>
                                        <div class="form-group row">
                                            <label class="col-md-3 col-form-label">Gender</label>
                                            <div class="col-md-8">
                                                <div class="kt-radio-inline">
                                                    <label class="kt-radio">
                                                        <input required type="radio" value="Male" name="gender"> Male
                                                        <span></span>
                                                    </label>
                                                    <label class="kt-radio">
                                                        <input required type="radio"  value="Female" name="gender"> Female
                                                        <span></span>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-xl-6">
                                                <div class="form-group">
                                                    <label>Marital Status</label>
                                                    <select required id="maritals"  name="marital_status" class="form-control" style="width:100%">
                                                        <option value="">Select status</option>
                                                        <option selected value="Single">Single</option>
                                                        <option value="Married">Marrired</option>
                                                        <option value="Widow">Widow</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-xl-6">
                                                <div class="form-group">
                                                    <label>Date of Birth</label>
                                                    <input required class="form-control" type="date" value="<?php echo date('Y-m-d');?>" name="dob" >
                                                    <span class="form-text text-muted">Please enter your email address.</span>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label>Education </label>
                                            <select id="titles"  name="education_level" class="form-control" style="width:100%">
                                                <option value="">Select education</option>
                                                <?php if(!empty($educations = educationLevels())){
                                                    foreach ($educations as $key => $level) {?>
                                                        <option selected value="<?php echo $level['level_id'];?>"><?php echo $level['level_name'];?></option>
                                                    <?php }
                                                } ?>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label>Contact Phone</label>
                                            <input required id="phonenumber" type="text" class="form-control" placeholder="Phone" aria-describedby="basic-addon1"  name="phonenumber">
                                            <span class="form-text text-muted">Please enter your phone number.</span>
                                        </div>

                                    </div>
                                </div>
                            </div>
                            <!--end: Form Wizard Step 1-->

                            <!--begin: Form Wizard Step 2-->
                            <div class="kt-wizard-v2__content" data-ktwizard-type="step-content">
                                <div class="kt-heading kt-heading--md">Setup Location</div>
                                <div class="kt-form__section kt-form__section--first">
                                    <div class="kt-wizard-v2__form">

                                        <div class="form-group">
                                            <label>Country</label>
                                            <select required name="country" class="countries order-alpha form-control " id="countryId" style="width:100%;">
                                                <option value="Tanzania">Tanzania</option>
                                            </select>
                                        </div>

                                        <div class="form-group">
                                            <label>State:</label>
                                            <select required name="state" class="states order-alpha form-control " id="stateId" style="width:100%;">
                                                <option value="Dar es salaam">Dar es salaam</option>
                                            </select>
                                        </div>

                                        <div class="form-group">
                                            <label>City:</label>
                                            <select required name="city" class="cities order-alpha form-control " id="cityId" style="width:100%;">
                                                <option value="Dar es salaam">Dar es salaam</option>
                                            </select>
                                        </div>

                                        <div class="form-group">
                                            <label>Home Address</label>
                                            <input required type="text" value="Home address" name="home_address" class="form-control"  placeholder="Home address">
                                        </div>

                                        <div class="form-group">
                                            <label>Residential Address</label>
                                            <input required type="text" value="Residential address" name="residential_address" class="form-control"  placeholder="residential address">
                                        </div>

                                        <div class="form-group row">
                                            <label>Identification</label>
                                            <div class="form-group ">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <select required class="form-control" name="identity_type" id="identity_type" style="width:100px;">
                                                            <option value=""></option>
                                                            <option value="National ID">National Identification</option>
                                                            <option value="Voter ID">Voter Card</option>
                                                        </select>
                                                    </div>
                                                    <input type="text" name="identity_value" class="form-control" placeholder="Enter identification number">
                                                </div>
                                            </div>

                                        </div>

                                    </div>
                                </div>
                            </div>
                            <!--end: Form Wizard Step 2-->

                            <!--begin: Form Wizard Step 3-->
                            <div class="kt-wizard-v2__content" data-ktwizard-type="step-content">
                                <div class="kt-heading kt-heading--md">Enter <b> Business </b> information</div>
                                <div class="kt-form__section kt-form__section--first">
                                    <div class="kt-wizard-v2__form">
                                        <div class="form-group">
                                            <label>Business Name</label>
                                            <input name="business_name" class="form-control" type="text" >
                                        </div>
                                        <div class="form-group">
                                            <label>Business Location</label>
                                            <input class="form-control" type="text" name="business_location" >
                                        </div>
                                        <div class="form-group">
                                            <label>Business type</label>
                                            <textarea name="business_type" class="form-control" rows="2" cols="80"></textarea>
                                        </div>
                                        <div class="form-group">
                                            <label>Business Age</label>
                                            <input class="form-control" type="text" name="business_age" value="0" >
                                        </div>
                                        <div class="form-group">
                                            <label>Registered Business</label>
                                            <div class="kt-radio-inline">
                                                <label class="kt-radio">
                                                    <input type="radio" value="Yes" name="business_registered"> Yes
                                                    <span></span>
                                                </label>
                                                <label class="kt-radio">
                                                    <input type="radio" checked  value="No" name="business_registered"> No
                                                    <span></span>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label>Business Lisence Number</label>
                                            <div class="input-group">
                                                <div class="input-group-prepend"><span class="input-group-text"><i class="la la-file"></i></span></div>
                                                <input type="text" class="form-control" placeholder="license number" aria-describedby="basic-addon1"  name="business_lisence">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label>Sales Avarage Per Day</label>
                                            <input name="business_sales_average_day" class="form-control number"/>
                                        </div>
                                        <div class="form-group">
                                            <label>Expense Avarage Per Day</label>
                                            <input class="form-control number" type="text" name="business_expense_average_day" >
                                        </div>
                                        <div class="form-group">
                                            <label>Other Income</label>
                                            <textarea name="business_other_income" class="form-control" rows="2" cols="80"></textarea>
                                        </div>

                                    </div>
                                </div>
                            </div>
                            <!--end: Form Wizard Step 3-->

                            <!--begin: Form Wizard Step 4-->
                            <div class="kt-wizard-v2__content" data-ktwizard-type="step-content">
                                <div class="kt-heading kt-heading--md">Security & Access details</div>
                                <div class="kt-form__section kt-form__section--first">
                                    <div class="kt-wizard-v2__form">
                                        <div class="row">
                                            <div class="col-xl-6">
                                                <div class="form-group">
                                                    <label>Username</label>
                                                    <div id="spinnerUsername" class="kt-spinner--sm kt-spinner--warning kt-spinner--right kt-spinner--input">
                                                        <input autocomplete="off" onchange="checkusername(this.value)"  onkeyup="checkusername(this.value)" id="username" name="username" class="form-control" type="text" >
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-6">
                                                <div class="form-group">
                                                    <label>Password</label>
                                                    <div class="input-group">
                                                        <input id="passwordInput"  readonly onfocus="this.removeAttribute('readonly');"  type="password" class="form-control" placeholder="Password" aria-describedby="basic-addon1" name="password">
                                                        <div class="input-group-append"><button class="btn btn-sm btn-warning text-dark" type="button" onmouseup="hidePassword()" onmousedown="showPassword()" class="input-group-text"><i class="la la-eye text-dark"></i></button></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label>Email</label>
                                            <div id="spinnerEmail" class="kt-spinner--sm kt-spinner--warning kt-spinner--right kt-spinner--input">
                                                <input autocomplete="off" onchange="checkemail(this.value)" onkeyup="checkemail(this.value)" id="email" name="email" class="form-control" type="email" value="">
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-xl-6">
                                                <div class="form-group">
                                                    <label>Branch</label>
                                                    <select required id="branches" required name="user_branch" class="form-control" style="width:100%">
                                                        <option value="">Select Branch</option>
                                                        <?php if(!empty($branches = $this->branchesModel->branches())){
                                                            foreach ($branches as $key => $branch) {?>
                                                                <option <?php if($branch['branch_key'] == runningBranch()->branch_key) echo 'selected';?> value="<?php echo $branch['branch_key'];?>"><?php echo $branch['branch_name'];?></option>
                                                            <?php }
                                                        } ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-xl-6">
                                                <div class="form-group">
                                                    <label>Administration:</label>
                                                    <select required  id="levels" name="auth_level" class="form-control" style="width:100%">
                                                        <option value=""></option>
                                                        <option selected  value="1">Customer</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label>Category</label>
                                            <div class="input-group">
                                                <select required  name="user_group" class="form-control" style="width:100%">
                                                    <option value="">Select Category</option>
                                                    <?php if(!empty($groups)){
                                                        foreach ($groups as $key => $group) {?>
                                                            <option  value="<?php echo $group['group_key'];?>"><?php echo $group['group_name'];?></option>
                                                        <?php }
                                                    } ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label>Communication</label>
                                            <div class="kt-checkbox-inline">
                                                <label class="kt-checkbox">
                                                    <input type="checkbox" value="1"  name="communicate_email" checked=""> Email
                                                    <span></span>
                                                </label>
                                                <label class="kt-checkbox">
                                                    <input type="checkbox" value="1"  name="communicate_sms" checked=""> SMS
                                                    <span></span>
                                                </label>
                                                <label class="kt-checkbox">
                                                    <input type="checkbox" value="1" name="communicate_phone" checked="" > Phone
                                                    <span></span>
                                                </label>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                            <!--end: Form Wizard Step 4-->

                            <!--begin: Form Wizard Step 5-->
                            <div class="kt-wizard-v2__content" data-ktwizard-type="step-content">
                                <div class="kt-heading kt-heading--md">Submit Your Details</div>

                            </div>
                            <!--end: Form Wizard Step 5-->


                            <!--begin: Form Actions -->
                            <div class="kt-form__actions">
                                <button class="btn btn-secondary btn-md btn-tall btn-wide kt-font-bold kt-font-transform-u" data-ktwizard-type="action-prev">
                                    Previous
                                </button>
                                <button type="submit" class="btn btn-success btn-md btn-tall btn-wide kt-font-bold kt-font-transform-u">
                                    Submit
                                </button>
                                <button class="btn btn-brand btn-md btn-tall btn-wide kt-font-bold kt-font-transform-u" data-ktwizard-type="action-next">
                                    Next Step
                                </button>
                            </div>

                            <!--end: Form Actions -->
                        </form>

                        <!--end: Form Wizard Form-->
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- end:: Content -->
</div>

<?php include VIEWPATH.'includes/footer.php';?>
<script src="<?php echo base_url('resources')?>/assets/js/pages/custom/wizard/wizard-2.js" type="text/javascript"></script>
<script src="//geodata.solutions/includes/countrystatecity.js"></script>
<script type="text/javascript">

    jQuery(document).ready(function() {
        $("#phonenumber").inputmask('+ 999 999 999999', {
            numericInput: true
        });
        const form = $('form#new_customer');
        form.submit( function(event){
            event.preventDefault();
            const formData = form.serialize();
            $.ajax({
                url: '<?php echo base_url('/customers/index/createCustomer/');?>',
                type: 'get',
                data: formData,
                beforeSend: function(){
                    KTApp.block(form,{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Please wait ..."
                    });
                },
                success: function(result){
                    KTApp.unblock(form);
                    if(result.status == true){
                        Swal.fire('',result.message,'success');
                        let table = $.fn.dataTable.tables( { api: true } );
                        table.clear().draw();
                    }else{
                        Swal.fire('',result.message,'warning');
                    }
                },
                error: function(xhr){
                    Swal.fire('',xhr.statusText,'warning');
                }
            });
        })
    });

    function showRequest(formData, jqForm, options) {
        // formData is an array; here we use $.param to convert it to a string to display it
        // but the form plugin does this for you automatically when it submits the data
        var queryString = $.param(formData);
        KTApp.block(jqForm,{
            overlayColor:"#000000",
            type:"loader",
            state:"danger",
            message:"Sending request to register an employee ..."
        });
        // here we could return false to prevent the form from being submitted;
        // returning anything other than false will allow the form submit to continue
        return true;
    }

    // post-submit callback
    function showResponse(responseText, statusText, xhr, $form)  {
        KTApp.unblock($form);
        var obj = JSON.parse(responseText);
        if(obj.status == 'ok'){
            Swal.fire('',obj.message,'success');
        }else{
            Swal.fire('',obj.message,'warning');
        }
    }

    function showPassword(){
        let input = $("#passwordInput");
        input.prop({type:"text"});
    }

    function hidePassword(){
        let input = $("#passwordInput");
        input.prop({type:"password"});
    }

    function checkemail(email){
        let spinner = $('div#spinnerEmail');
        let input = $('input#email');
        event.preventDefault();
        $.ajax({
            url: '<?php echo base_url('/administration/employees/index/checkemailonly/');?>' + encodeURIComponent(email),
            type: 'get',
            beforeSend: function(){
                spinner.addClass('kt-spinner');
                input.removeClass('is-valid is-invalid');
            },
            success: function(r){
                var obj = JSON.parse(r);
                spinner.removeClass('kt-spinner');
                if(obj.status == 'ok'){
                    input.addClass('is-valid');
                }else{
                    input.addClass('is-invalid');
                }
            },
            error: function(){
                spinner.removeClass('kt-spinner');
                Swal.fire('',obj.message,'warning');
            }
        });
    }

    function checkusername(username){
        let spinner = $('div#spinnerUsername');
        let input = $('input#username');
        event.preventDefault();
        $.ajax({
            url: '<?php echo base_url('/administration/employees/index/checkusernameonly/');?>' + encodeURIComponent(username),
            type: 'get',
            beforeSend: function(){
                spinner.addClass('kt-spinner');
                input.removeClass('is-valid is-invalid');
            },
            success: function(r){
                var obj = JSON.parse(r);
                spinner.removeClass('kt-spinner');
                if(obj.status == 'ok'){
                    input.addClass('is-valid');
                }else{
                    input.addClass('is-invalid');
                }
            },
            error: function(){
                spinner.removeClass('kt-spinner');
                Swal.fire('',obj.message,'warning');
            }
        });
    }
</script>
<!--end::Page Scripts -->
</body>

<!-- end::Body -->
</html>