<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="kt-portlet kt-portlet--head-md kt-portlet--responsive-mobile" id="kt_page_portlet">

    <div class="kt-portlet__body">
        <!-- <div class="kt-datatable" id="applicationTable"></div> -->
        <table class="table table-bordered table-hover table-checkable" id="lm_table_freight">
            <thead>
            <tr>
                <th>File No:</th>
                <th>Cargo Details</th>
                <th>ETA/ETD</th>
                <th>Status</th>
            </tr>
            </thead>
        </table>
    </div>
</div>

<script type="text/javascript">
    //== Class definition
    $.fn.dataTable.Api.register('column().title()', function() {
        return $(this.header()).text().trim();
    });

    var Datatable = function() {
        var initTable = function() {
            var events = $('#lm_table_freight');
            // begin first table
            events.DataTable({
                responsive: true,
                buttons: [
                    'print',
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                ],
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
			<'row'<'col-sm-12'tr>>
			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                searchDelay: 500,
                processing: true,
                serverSide: false,
                ajax: '<?php echo base_url('crm/customers/index/datasourceFreight/'.$customer->user_key);?>',
                columns: [
                    {data: 'fr_key'},
                    {data: 'fr_cargo_details'},
                    {data: 'fr_eta_etd'},
                    {data: 'fr_status'},
                ],
                initComplete: function() {
                    this.api().columns().every(function() {
                        var column = this;

                        switch (column.title()) {
                            case 'Status':
                                column.data().unique().sort().each(function(d, j) {
                                    $('.kt-input[data-col-index="6"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'Region':
                                column.data().unique().sort().each(function(d, j) {
                                    $('.kt-input[data-col-index="4"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'District':
                                column.data().unique().sort().each(function(d, j) {
                                    $('.kt-input[data-col-index="5"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                        }
                    });
                },
                columnDefs: [
                    {
                        targets: 0,
                        render: function(data, type, full, meta) {
                            return '<a  href="<?php echo base_url('freight/details/');?>' + full.fr_key + '">'+full.fr_key+'</a>';
                        }
                    },
                    {
                        targets: 1,
                        render: function(data, type, full, meta) {
                            return (data);
                        }
                    },

                ],
            });

            var filter = function() {
                var val = $.fn.dataTable.util.escapeRegex($(this).val());
                let table = $.fn.dataTable.tables( { api: true } );
                table.column($(this).data('col-index')).search(val ? val : '', false, false).draw();
            };

            var asdasd = function(value, index) {
                let table = $.fn.dataTable.tables( { api: true } );
                var val = $.fn.dataTable.util.escapeRegex(value);
                table.column(index).search(val ? val : '', false, true);
            };

            $('#m_search').on('click', function(e) {
                e.preventDefault();
                let table = $.fn.dataTable.tables( { api: true } );
                var params = {};
                $('.kt-input').each(function() {
                    var i = $(this).data('col-index');
                    if (params[i]) {
                        params[i] += '|' + $(this).val();
                    }
                    else {
                        params[i] = $(this).val();
                    }
                });
                $.each(params, function(i, val) {
                    // apply search params to datatable
                    table.column(i).search(val ? val : '', false, false);
                });
                table.table().draw();
            });

            $('#m_reset').on('click', function(e) {
                e.preventDefault();
                let table = $.fn.dataTable.tables( { api: true } );
                $('.kt-input').each(function() {
                    $(this).val('');
                    table.column($(this).data('col-index')).search('', false, false);
                });
                table.table().draw();
            });

        };

        return {
            //main function to initiate the module
            init: function() {
                initTable();
            },

        };

    }();

    jQuery(document).ready(function() {
        Datatable.init();
    });


</script>

