<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<form id="sendCustomerForm" class="kt-form" action="#" method="get" onsubmit="return false" enctype="multipart/form-data">
<div class="kt-inbox__form" id="kt_inbox_compose_form">
    <div class="kt-inbox__head">
        <div class="kt-inbox__title">Compose</div>
        <div class="kt-inbox__actions">
            <button type="button" class="kt-inbox__icon kt-inbox__icon--md kt-inbox__icon--light">
                <i class="flaticon2-arrow-1"></i>
            </button>
            <button type="button" class="kt-inbox__icon kt-inbox__icon--md kt-inbox__icon--light" data-dismiss="modal">
                <i class="flaticon2-cross"></i>
            </button>
        </div>
    </div>
    <div class="kt-inbox__body">
        <div class="kt-inbox__to">
            <div class="kt-inbox__wrapper">
                <div class="kt-inbox__field kt-inbox__field--to">
                    <div class="kt-inbox__label">
                        To:
                    </div>
                    <div class="kt-inbox__input">
                        <input type="text" name="email" value="<?php echo $customer->email;?>" placeholder="<?php echo $customer->firstname;?> <?php echo $customer->lastname;?>">
                    </div>
                    <div class="kt-inbox__tools">
                        <span class="kt-inbox__tool kt-inbox__tool--cc">Cc</span>
                        <span class="kt-inbox__tool kt-inbox__tool--bcc">Bcc</span>
                    </div>
                </div>
                <div class="kt-inbox__field kt-inbox__field--cc">
                    <div class="kt-inbox__label">
                        Cc:
                    </div>
                    <div class="kt-inbox__input">
                        <input type="text" name="email">
                    </div>
                    <div class="kt-inbox__tools">
                        <button type="button" class="kt-inbox__icon kt-inbox__icon--delete kt-inbox__icon--sm kt-inbox__icon--light">
                            <i class="flaticon2-cross"></i>
                        </button>
                    </div>
                </div>
                <div class="kt-inbox__field kt-inbox__field--bcc">
                    <div class="kt-inbox__label">
                        Bcc:
                    </div>
                    <div class="kt-inbox__input">
                        <input type="text" name="email">
                    </div>
                    <div class="kt-inbox__tools">
                        <button type="button" class="kt-inbox__icon kt-inbox__icon--delete kt-inbox__icon--sm kt-inbox__icon--light">
                            <i class="flaticon2-cross"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <div class="kt-inbox__subject">
            <input class="form-control" name="subject" placeholder="Subject">
        </div>

        <div class="kt-chat__editor">
            <textarea name="message" placeholder="Type here..." style="height: 300px; width: 100%"></textarea>
        </div>
        <div class="kt-inbox__attachments">
            <div class="dropzone dropzone-multi" id="kt_inbox_compose_attachments">
                <div class="dropzone-items">
                    <div class="dropzone-item" style="display:none">
                        <div class="dropzone-file">
                            <div class="dropzone-filename" title="some_image_file_name.jpg">
                                <span data-dz-name>some_image_file_name.jpg</span> <strong>(<span  data-dz-size>340kb</span>)</strong>
                            </div>
                            <div class="dropzone-error" data-dz-errormessage></div>
                        </div>
                        <div class="dropzone-progress">
                            <div class="progress">
                                <div class="progress-bar kt-bg-brand" role="progressbar" aria-valuemin="0" aria-valuemax="100" aria-valuenow="0" data-dz-uploadprogress></div>
                            </div>
                        </div>
                        <div class="dropzone-toolbar">
                            <span class="dropzone-delete" data-dz-remove><i class="flaticon2-cross"></i></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="kt-inbox__foot">
        <div class="kt-inbox__primary">
            <div class="btn-group">
                <button type="submit" class="btn btn-brand btn-bold" name="button">
                    Send
                </button>
                <button type="button" class="btn btn-brand btn-bold dropdown-toggle dropdown-toggle-split" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                </button>
                <div class="dropdown-menu dropup dropdown-menu-fit dropdown-menu-right">
                    <ul class="kt-nav">
                        <li class="kt-nav__item">
                            <a href="#" class="kt-nav__link">
                                <i class="kt-nav__link-icon flaticon2-writing"></i>
                                <span class="kt-nav__link-text">Schedule Send</span>
                            </a>
                        </li>
                        <li class="kt-nav__item">
                            <a href="#" class="kt-nav__link">
                                <i class="kt-nav__link-icon flaticon2-medical-records"></i>
                                <span class="kt-nav__link-text">Save & archive</span>
                            </a>
                        </li>
                        <li class="kt-nav__item">
                            <a href="#" class="kt-nav__link">
                                <i class="kt-nav__link-icon flaticon2-hourglass-1"></i>
                                <span class="kt-nav__link-text">Cancel</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="kt-inbox__panel">
                <label class="kt-inbox__icon kt-inbox__icon--light" id="kt_inbox_compose_attachments_select">
                    <i class="flaticon2-clip-symbol"></i>
                </label>
                <label class="kt-inbox__icon kt-inbox__icon--light">
                    <i class="flaticon2-pin"></i>
                </label>
            </div>
        </div>
        <div class="kt-inbox__secondary">
            <button class="kt-inbox__icon kt-inbox__icon--light" data-toggle="kt-tooltip" title="More actions">
                <i class="flaticon2-settings"></i>
            </button>
            <button class="kt-inbox__icon kt-inbox__icon--remove kt-inbox__icon--light" data-toggle="kt-tooltip" title="Dismiss reply">
                <i class="flaticon2-rubbish-bin-delete-button"></i>
            </button>
        </div>
    </div>
</div>
</form>


<script type="text/javascript">
    $('form#sendCustomerForm').submit( function(chat){
        let form = $( this );
        chat.preventDefault();
        let formdata = form.serialize();
        $.ajax({
            url: '<?php echo base_url('/crm/customers/index/sendEmail/'.$customer->user_id);?>',
            type: 'get',
            data: formdata,

            cache: false,
            contentType: false,
            processData: false,
            beforeSend: function(){
                KTApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Sending Email ..."
                });
            },
            success: function(results){
                KTApp.unblockPage();
                if(results.status == true){
                    Swal.fire('',results.message,'success');
                    $('div#kt_chat_noely').modal('hide');
                }else{
                    Swal.fire('',results.message,'warning');
                }
            },
            error: function (xhr){
                $('div#kt_chat_noely').modal('hide');
                KTApp.unblock(form);
            }

        });
    })
</script>