
<div class="row">
    <div class="col-12">
        <div class="alert alert-light alert-elevate fade show" role="alert">
            <div class="alert-icon"><i class="flaticon-warning kt-font-brand"></i></div>
            <div class="alert-text">
                <code>Conversion Rates </code> are set equivalent to one <code>Dollar</code>. <b>US Dollar</b> is being used as base currency, setting default currency other that <code>US Dollar</code> require to set conversion rate equivalent ot one <code>US Dollar</code> <b>1$</b>
            </div>
        </div>
        <hr/>
        <div class="kt-portlet">
            <div class="kt-portlet__body">
                <?php
                if(empty($_SESSION['currency_api_requested'])){
                    // set API Endpoint and access key (and any options of your choice)
                    $endpoint = 'live';
                    $access_key = config_item('currency_api_key');

                    // Initialize CURL:
                    $ch = curl_init('http://apilayer.net/api/'.$endpoint.'?access_key='.$access_key.'');
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                    // Store the data:
                    $json = curl_exec($ch);
                    curl_close($ch);

                    // Decode JSON response:
                    $exchangeRates = json_decode($json, true);
                    $_SESSION['currency_api_requested'] = $exchangeRates;
                }else{
                    $exchangeRates = $_SESSION['currency_api_requested'];
                }

                // Access the exchange rate values, e.g. GBP:

                ?>
                <b>e.g 1USD = <?php echo number_format($exchangeRates['quotes']['USDTZS'],2);?>TZS</b>
            </div>
        </div>
    </div>
    <div class="col-12">

        <div class="modal-content">
            <div class="modal-header handle">
                <h5 class="modal-title" id="exampleModalLongTitle">Set Default Currency</h5>
            </div>
            <?php echo form_open('#',['id' => 'setCurrency']);?>
            <div class="modal-body">
                <div class="row">
                    <div class="form-group col-md-6">
                        <label class="text-muted">Currency</label>
                        <select name="bs_currency" required class="form-control">
                            <option  value="">Select Currency</option>
                            <?php if(!empty($currencies = currencies())){
                                foreach ($currencies as $currency){?>
                                    <option <?php if(strtolower($currency->cc) == 'tzs') echo 'selected';?> value="<?php echo $currency->name.'-'.$currency->cc;?>"><?php echo $currency->name.' - '.$currency->cc;?></option>
                                <?php }
                            } ?>
                        </select>
                    </div>
                    <div class="form-group col-md-6">
                        <label class="text-muted">Conversion Rate</label>
                        <input required value="<?php echo number_format($exchangeRates['quotes']['USDTZS']);?>" name="bs_conversion" class="form-control number" type="text" placeholder="Rate" />
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-outline-info" >Submit</button>
            </div>
            <?php echo form_close();?>
        </div>
    </div>
</div>
<script type="text/javascript">
    $( function(){
        $('select').select2({placeholder: 'Select Currency'});
        $('form#setCurrency').submit( function(event){
            event.preventDefault();
            const form = $( this );
            const formData = form.serialize();
            const modal = $('div#setCurrency');
            $.ajax({
                url: "<?php echo base_url('/commonajax/setcurrencyaction');?>",
                type: "get",
                data: formData,
                beforeSend: function(){
                    KTApp.block(modal,{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"warning",
                        message:"Please wait ..."
                    });
                },
                success: function(result){
                    KTApp.unblock(modal);
                    if(result.status == true){
                        modal.modal("hide");
                        Swal.fire('',result.message,'success');
                    }else{
                        Swal.fire('',result.message,'warning');
                    }
                },
                error: function (xhr){
                    KTApp.unblock(modal);
                    Swal.fire('',xhr.statusText,'warning');
                }
            })
        })

        $(function() {
            var $input = $( "input.number" );
            $input.on( "keyup", function( event ) {
                // When user select text in the document, also abort.
                var selection = window.getSelection().toString();
                if ( selection !== '' ) {
                    return;
                }
                // When the arrow keys are pressed, abort.
                if ( $.inArray( event.keyCode, [38,40,37,39] ) !== -1 ) {
                    return;
                }
                var $this = $( this );
                // Get the value.
                var input = $this.val();
                var input = input.replace(/[\D\s\._\-]+/g, "");
                input = input ? parseInt( input, 10 ) : 0;
                $this.val( function() {
                    return ( input === 0 ) ? "" : input.toLocaleString( "en-US" );
                } );
            });
        });
    })


</script>
