<script type="text/javascript">

    var LMDatatableGroups= function() {
        var initTable = function() {
            // begin first table
            var table = $('#lm_table_clock').DataTable({
                responsive: true,
                // Pagination settings
                dom: `<'row'<'col-sm-12'tr>>
    			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                // read more: https://datatables.net/examples/basic_init/dom.html

                lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],

                pageLength: 10,
                language: {
                    'lengthMenu': 'Display _MENU_',
                    buttons: {
                        selectAll: "Select all",
                        selectNone: "Select none"
                    },
                    "emptyTable": "No record found",
                },
                searchDelay: 500,
                processing: true,
                serverSide: true,
                select:true,
                "ajax":"<?php echo base_url('/hrm/attendance/index/datasourceAttendances');?>",
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
    			<'row'<'col-sm-12'tr>>
    			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                buttons: [
                    {
                        text: 'Delete Seleted',
                        action: function ( e, dt, node, config ) {
                            deleteSelected( table);
                        }
                    },
                    'selectAll',
                    'selectNone',
                    'excelHtml5',
                    'pdfHtml5',
                ],
                columns: [
                    {data: 'att_user_id'},
                    {data: 'att_date'},
                    {data: 'att_time_in'},
                    {data: 'att_time_out'},
                    {data: 'action'},
                ],
                columnDefs: [
                    {
                        targets: 0,
                        render: function(data, type, full, meta){
                            return '<a  href="<?php echo base_url('administration/employees/details/');?>' + full.user_id + '"> ' + full.firstname + ' ' + full.lastname + '</a> ';
                        }
                    },
                    {
                        targets: 4,
                        render: function(data, type, full, meta){
                            return '<a href="javascript:details(' + full.att_key + ');"><i class="flaticon-eye text-success"></i></a> | <a href="javascript:modify(' + full.att_key + ');"><i class="flaticon-edit text-warning"></i></a> | <a href="javascript:deleteItem(' + full.att_key + ');"><i class="flaticon-delete text-danger"></i></a>';
                        }
                    }
                ],
            });
        };

        return {
            //main function to initiate the module
            init: function() {
                initTable();
            },

        };

    }();

    jQuery(document).ready(function() {
        $('select').css('width','100%');
        $('select').select2({placeholder: 'select option'});
        let height = $(window).innerHeight()  - 250;
        $('.lm_max_height').css({ height: height });
        $(window).resize(function(){
            $('.lm_max_height').css({ height: height });
        });
        LMDatatableGroups.init();
        $('form#newClockForm').submit( function(event){
            let form = $( this );
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url('clock/index/newClockin/')?>',
                type: 'get',
                data: formdata,
                beforeSend: function(){
                    KTApp.block("form#newClockForm",{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"success",
                        message:"Creating new Clock ...."
                    });
                },
                success: function(r){
                    var obj = JSON.parse(r);
                    if(obj.status == 'ok'){
                        notifySuccess(obj.message);
                        var table = $.fn.dataTable.tables( { api: true } );
                        table.clear().draw();
                        window.location.reload();
                    }else{
                        Swal.fire('',obj.message,'warning');
                    }
                    KTApp.unblock('form#newClockForm');
                    $('div#newClock').modal('hide');
                },
                error: function(){
                    KTApp.unblock('form#newClockForm');
                }
            });
        })

    });

    function wclockOut(wclock){
        let $modal =  $('div#clockDetails');
        let $div = $modal.find('.modal-body');
        $div.html('');
        $modal.modal('show');
        $.ajax({
            url: '<?php echo base_url('clock/index/clockOut/');?>' + wclock,
            type: 'get',
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Loading Working Clock details ...."
                });
            },
            success: function (result){
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr){
                $modal.modal('hide');
                KTApp.unblock($div);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }

    function wclockIn(wclock){
        let $modal =  $('div#clockDetails');
        let $div = $modal.find('.modal-body');
        $div.html('');
        $modal.modal('show');
        $.ajax({
            url: '<?php echo base_url('clock/index/clockIn/');?>' + wclock,
            type: 'get',
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Loading Working clock details ...."
                });
            },
            success: function (result){
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr){
                $modal.modal('hide');
                KTApp.unblock($div);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }

    function details(wclock){
        let $modal =  $('div#clockDetails');
        let $div = $modal.find('.modal-body');
        $div.html('');
        $modal.modal('show');
        $.ajax({
            url: '<?php echo base_url('clock/index/detailsWclock/');?>' + wclock,
            type: 'get',
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Loading working clock details ...."
                });
            },
            success: function (result){
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr){
                $modal.modal('hide');
                KTApp.unblock($div);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }



    function breakClock(wclock){
        Swal.fire({
            title: 'Are you sure?',
            text: "You are about to go break.!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, go BREAK it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?php echo base_url('clock/index/breakClock/');?>" + wclock,
                    type: "get",
                    beforeSend: function(){
                        KTApp.block("#lm_table_task",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Approving Request ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            notifySuccess(obj.message);
                            KTApp.unblock('div#id-');
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_task');
                        Swal.fire('',xhr.statusText,'warning');
                    }

                })
            }
        })
    }

    function continueClock(wclock){
        Swal.fire({
            title: 'Are you sure?',
            text: "You are about to go break.!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, go BREAK it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?php echo base_url('clock/index/continueClock/');?>" + wclock,
                    type: "get",
                    beforeSend: function(){
                        KTApp.block("#lm_table_task",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Approving Request ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            notifySuccess(obj.message);
                            KTApp.unblock('#lm_table_task');
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_task');
                        Swal.fire('',xhr.statusText,'warning');
                    }

                })
            }
        })
    }

    function clockuserOut(wclock){
        Swal.fire({
            title: 'Are you sure?',
            text: "You are about to go break.!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, go BREAK it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?php echo base_url('clock/index/clockuserOut/');?>" + wclock,
                    type: "get",
                    beforeSend: function(){
                        KTApp.block("#lm_table_task",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Approving Request ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            notifySuccess(obj.message);
                            KTApp.unblock('#lm_table_task');
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_task');
                        Swal.fire('',xhr.statusText,'warning');
                    }

                })
            }
        })
    }

    function deleteWorkingClock(wclock){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('clock/index/deleteWclock/clock')?>/'+wclock,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.block("#lm_table_clock",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Deleting working clock ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            $('div#id-' + clock).hide();
                            notifySuccess(obj.message);
                            KTApp.unblock('div#id-');
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_clock');
                        Swal.fire('',xhr.statusText,'warning');
                    }
                });
            }
        })
    }

</script>