<script>

    "use strict";

    var KTCalendarExternalEvents = function() {

        var initExternalEvents = function() {
            $('#kt_calendar_external_events .fc-draggable-handle').each(function() {
                // store data so the calendar knows to render an event upon drop
                $(this).data('event', {
                    title: $.trim($(this).text()), // use the element's text as the event title
                    stick: true, // maintain when user navigates (see docs on the renderEvent method)
                    classNames: [$(this).data('color')],
                    description: 'Lorem ipsum dolor eius mod tempor labore'
                });
            });
        }

        var initCalendar = function() {
            var todayDate = moment().startOf('day');
            var YM = todayDate.format('YYYY-MM');
            var YESTERDAY = todayDate.clone().subtract(1, 'day').format('YYYY-MM-DD');
            var TODAY = todayDate.format('YYYY-MM-DD');
            var TOMORROW = todayDate.clone().add(1, 'day').format('YYYY-MM-DD');

            var calendarEl = document.getElementById('kt_calendar');
            var containerEl = document.getElementById('kt_calendar_external_events');

            var Draggable = FullCalendarInteraction.Draggable;

            new Draggable(containerEl, {
                itemSelector: '.fc-draggable-handle',
                eventData: function(eventEl) {
                    return $(eventEl).data('event');
                }
            });

            var calendar = new FullCalendar.Calendar(calendarEl, {
                plugins: [ 'interaction', 'dayGrid', 'timeGrid', 'list' ],

                isRTL: KTUtil.isRTL(),
                header: {
                    left: 'prev,next today',
                    center: 'title',
                    right: 'dayGridMonth,timeGridWeek,timeGridDay'
                },

                height: 800,
                contentHeight: 780,
                aspectRatio: 3,  // see: https://fullcalendar.io/docs/aspectRatio

                nowIndicator: true,
                now: TODAY + 'T09:25:00', // just for demo

                views: {
                    dayGridMonth: { buttonText: 'month' },
                    timeGridWeek: { buttonText: 'week' },
                    timeGridDay: { buttonText: 'day' },
                    listDay: { buttonText: 'list' },
                    listWeek: { buttonText: 'list' }
                },

                defaultView: 'listWeek',
                defaultDate: TODAY,

                droppable: true, // this allows things to be dropped onto the calendar
                editable: true,

                eventResize: function(info) {
                    if (!confirm("is this okay?")) {
                        info.revert();
                        return;
                    }

                    const event = info.event;
                    const el = info.draggedEl;
                    const view = info.view;
                    var data = {
                        allday: event.allDay,
                        event_key:event.event_key,
                        event_start_datetime: moment(event.event_start_datetime).format('YYYY-MM-DD HH:mm:ss'),
                        event_end_datetime: moment(event.event_end_datetime).format('YYYY-MM-DD HH:mm:ss')
                    };
                    $.ajax({
                        url: "<?php echo base_url('calendar/index/eventresizeajax');?>",
                        type: "get",
                        data: data,
                        beforeSend: function(){
                            KTApp.blockPage({
                                overlayColor:"#000000",
                                type:"loader",
                                state:"success",
                                message:"please wait ..."
                            });
                        },
                        success: function (result){
                            KTApp.unblockPage();
                            if(result.status == true){
                                $('div#app-key').show();
                                Swal.fire('',result.message,'success');
                            }else{
                                info.revert();
                                Swal.fire('',result.message,'warning');
                            }
                        },
                        error: function (xhr){
                            info.revert();
                            KTApp.unblockPage();
                            Swal.fire('',xhr.statusText,'warning');
                        }

                    })
                },
                eventDrop: function(info) {

                    if (!confirm("Are you sure about this change?")) {
                        info.revert();
                        return;
                    }

                    const event = info.event;
                    const el = info.draggedEl;
                    const view = info.view;
                    var data = {
                        allday: event.allDay,
                        event_key:event.event_key,
                        event_start_datetime: moment(event.event_start_datetime).format('YYYY-MM-DD HH:mm:ss'),
                        event_end_datetime: moment(event.event_end_datetime).format('YYYY-MM-DD HH:mm:ss')
                    };
                    $.ajax({
                        url: "<?php echo base_url('calendar/index/eventresizeajax');?>",
                        type: "get",
                        data: data,
                        beforeSend: function(){
                            KTApp.blockPage({
                                overlayColor:"#000000",
                                type:"loader",
                                state:"success",
                                message:"please wait ..."
                            });
                        },
                        success: function (result){
                            KTApp.unblockPage();
                            if(result.status == true){
                                $('div#app-key').show();
                                Swal.fire('',result.message,'success');
                            }else{
                                info.revert();
                                Swal.fire('',result.message,'warning');
                            }
                        },
                        error: function (xhr){
                            info.revert();
                            KTApp.unblockPage();
                            Swal.fire('',xhr.statusText,'warning');
                        }

                    })
                },

                eventLimit: true, // allow "more" link when too many events
                navLinks: true,
                events: [
                    <?php if(!empty($events)){
                    foreach ($events as $key => $value) {?>
                    {
                        id: '<?php echo $value['event_key'];?>',
                        title: '<?php echo $value['event_title'];?>',
                        start: '<?php echo date("Y-m",strtotime($value['event_start_datetime']));?>' + '-<?php echo date("d H:m:i",strtotime($value['event_start_datetime']));?>',
                        end: '<?php echo date("Y-m",strtotime($value['event_end_datetime']));?>' + '-<?php echo date("d H:m:i",strtotime($value['event_end_datetime']));?>',
                        className: "<?php echo $value['event_color'];?>",
                        description: '<?php echo $value['event_desc'];?>'
                    },
                    <?php } }?>
                ],

                eventReceive: function(info){
                    const event = info.event;
                    const el = info.draggedEl;
                    const view = info.view;
                    var data = {
                        allday: event.allDay,
                        event_title: event.event_title,
                        event_desc: event.event_desc,
                        event_start_datetime: moment(event.event_start_datetime).format('YYYY-MM-DD HH:mm:ss'),
                        event_end_datetime: moment(event.event_end_datetime).format('YYYY-MM-DD HH:mm:ss')
                    };
                    $.ajax({
                        url: "<?php echo base_url('calendar/index/addeventajax');?>",
                        type: "get",
                        data: data,
                        beforeSend: function(){
                            KTApp.blockPage({
                                overlayColor:"#000000",
                                type:"loader",
                                state:"success",
                                message:"please wait ..."
                            });
                        },
                        success: function (result){
                            KTApp.unblockPage();
                            if(result.status == true){
                                $('div#app-key').show();
                                Swal.fire('',result.message,'success');
                            }else{
                                Swal.fire('',result.message,'warning');
                            }
                            KTApp.unblock('form#newEventForm');
                            $('div#newEvent').modal('hide');
                        },
                        error: function (xhr){
                            KTApp.unblockPage();
                            Swal.fire('',xhr.statusText,'warning');
                            var eventId = calendar.getEventById(event.id);
                            eventId.remove();
                        }

                    })
                },

                drop: function(arg) {
                    // is the "remove after drop" checkbox checked?
                    if ($('#kt_calendar_external_events_remove').is(':checked')) {
                        // if so, remove the element from the "Draggable Events" list
                        $(arg.draggedEl).remove();
                    }
                },

                eventClick: function(info) {
                    info.jsEvent.preventDefault(); // don't let the browser navigate
                    Swal.fire({
                        title: 'Are you sure?',
                        text: "You want delete this event!",
                        type: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
                        if (result.value) {
                            $.ajax({
                                url: "<?php echo base_url('calendar/index/removeeventajax/');?>" + info.event.id,
                                beforeSend: function(){
                                    KTApp.blockPage({
                                        overlayColor:"#000000",
                                        type:"loader",
                                        state:"success",
                                        message:"please wait ..."
                                    });
                                },
                                success: function (result){
                                    KTApp.unblockPage();
                                    if(result.status == true){
                                        var event = calendar.getEventById(info.event.id);
                                        event.remove();
                                        Swal.fire('',result.message,'success');
                                    }else{
                                        Swal.fire('',result.message,'warning');
                                    }
                                },
                                error: function (xhr){
                                    KTApp.unblockPage();
                                    Swal.fire('',xhr.statusText,'warning');
                                }

                            })
                        }else{
                            info.revert();
                        }
                    })
                },

                eventRender: function(info) {
                    var element = $(info.el);

                    if (info.event.extendedProps && info.event.extendedProps.description) {
                        if (element.hasClass('fc-day-grid-event')) {
                            element.data('content', info.event.extendedProps.description);
                            element.data('placement', 'top');
                            KTApp.initPopover(element);
                        } else if (element.hasClass('fc-time-grid-event')) {
                            element.find('.fc-title').append('<div class="fc-description">' + info.event.extendedProps.description + '</div>');
                        } else if (element.find('.fc-list-item-title').lenght !== 0) {
                            element.find('.fc-list-item-title').append('<div class="fc-description">' + info.event.extendedProps.description + '</div>');
                        }
                    }
                }
            });

            $("form#newEventForm").submit( function(e){
                e.preventDefault();
                const form = $( this );
                let data = form.serialize();
                $.ajax({
                    url: "<?php echo base_url('calendar/index/addeventajax');?>",
                    type: "get",
                    data: data,
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"success",
                            message:"please wait ..."
                        });
                    },
                    success: function (result){
                        KTApp.unblockPage();
                        if(result.status == true){
                            let eventData = {
                                event_tile: result.event_tile,
                                event_desc: result.event_desc,
                                event_key: result.event_key,
                                event_start_datetime: new Date(result.event_start_datetime),
                                event_end_datetime: new Date(result.event_end_datetime),
                                className: "fc-event-danger fc-event-solid-warning"
                            }
                            calendar.addEvent(eventData);
                            Swal.fire('',result.message,'success');
                        }else{
                            Swal.fire('',result.message,'warning');
                        }
                        KTApp.unblock('form#newEventForm');
                        $('div#newEvent').modal('hide');
                    },
                    error: function (xhr){
                        KTApp.unblockPage();
                        Swal.fire('',xhr.statusText,'warning');
                    }

                })

            })
            calendar.render();
        }

        return {
            //main function to initiate the module
            init: function() {
                initExternalEvents();
                initCalendar();
            }
        };
    }();

    jQuery(document).ready(function() {
        KTCalendarExternalEvents.init();
    });

</script>
