<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<link href="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.css" rel="stylesheet" type="text/css" />
<!-- end::Head -->
<style>
    td {word-wrap: break-word}
</style>
<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?>
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <?php //topMenuFreightForward('settings');?>

    <!-- begin:: Content -->
    <div class="kt-container kt-container--fluid">
        <div class="row">
            <div class="col-12">
                <div class="bs-example">
                    <nav >
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:(0);">Assets</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:(0);">Settings</a></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>



        <!--begin:: Widgets/Quick Stats-->
        <?php //include __DIR__.'/top_summary.php';?>
        <!--end:: Widgets/Quick Stats-->

        <div class="kt-portlet kt-portlet--tabs" data-portlet="true">
            <div class="kt-portlet__head">
                <div class="kt-portlet__head-label">
                    <h3 class="kt-portlet__head-title">
                        Asset Types <?php if(!empty($when = $this->input->get("when"))) echo '| <span class="kt-font-brand">'. ucfirst(datesWhen($when)['label'])."</span>";?>
                    </h3> &nbsp;&nbsp;
                    <a href="#asset-types" data-backdrop="false" data-toggle="modal" class="btn btn-outline-brand btn-sm">Add Asset Type</a>
                </div>
                <div class="kt-portlet__head-toolbar">

                    <ul class="nav nav-tabs nav-tabs-bold nav-tabs-line   nav-tabs-line-right nav-tabs-line-brand" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" data-toggle="tab" href="#asset-types-list" role="tab" aria-selected="false">
                                Asset Types
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#asset-types-list-bin" role="tab" aria-selected="true">
                                Recycle Bin
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="kt-portlet__body kt-portlet__body--fullheight">
                <div class="tab-content">
                    <div class="tab-pane  active" id="asset-types-list">
                        <table class="table " id="asset-types-list-table">
                            <thead>
                            <tr>
                                <th>ID #</th>
                                <th>Country</th>
                                <th>Date</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                    <div class="tab-pane" id="asset-types-list-bin">
                        <table id="asset-types-list-bin-table" class="table">
                            <thead>
                            <tr>
                                <th>ID #</th>
                                <th>Country</th>
                                <th>Date</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <!-- end:: Content -->
</div>

<!-- Begin: Modify Countries Modal -->
<div class="modal fade" id="modify-country-modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <?php $attr = array( 'class' => 'kt-form','id'=>'modify-country-form');
        echo form_open('', $attr );?>
        <div class="modal-content">
            <div class="modal-header">
                <h3>Modify Country</h3>
            </div>
            <div class="modal-body">

            </div>
            <div class="modal-footer">
                <div class="kt-form__actions">
                    <div class="row">
                        <div class="col-6"><button type="button" data-dismiss="modal" class="btn btn-secondary">Cancel</button></div>
                        <div class="col-6">
                            <button type="submit" name="submit" class="btn btn-success pull-right">Update</button>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <?php echo form_close();?>
    </div>
</div>
<!-- End: Modify Countries Modal -->


<!-- Begin: Add Countries Modal -->
<div class="modal fade" id="asset-types" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <?php $attr = array( 'class' => 'kt-form','id'=>'asset-type-form');
        echo form_open('', $attr );?>
        <div class="modal-content">
            <div class="modal-header">
                <h3>Add Asset Type</h3>
            </div>
            <div class="modal-body">
                <!--begin::Form-->
                <div class="kt-portlet__body">
                    <div class="form-group">
                        <label style="margin: 10px">Asset Type </label>
                        <input name="country" class="form-control kt-select2" id="kt_select2_3_modal" required>

                        <label style="margin: 10px">Asset Type Name</label>
                        <input name="country" class="form-control kt-select2" id="kt_select2_3_modal" required>
                    </div>
                    <div class="form-group">
                    </div>
                    <div class="form-group">
                        <label style="margin: 10px">Asset Type Category </label>
                        <input name="country" class="form-control kt-select2" id="kt_select2_3_modal" required>
                    </div>
                    <div class="form-group">
                        <label style="margin: 10px">Asset Type Value </label>
                        <input name="country" class="form-control kt-select2" id="kt_select2_3_modal" required>
                    </div>
                    <div class="form-group">
                        <label style="margin: 10px">Asset Type Description </label>
                        <input name="country" class="form-control kt-select2" id="kt_select2_3_modal" required>
                    </div>
                    <div class="form-group">
                        <label style="margin: 10px">Asset Type Account </label>
                        <input name="country" class="form-control kt-select2" id="kt_select2_3_modal" required>
                    </div>

                </div>
            </div>
            <div class="modal-footer">
                <div class="kt-form__actions">
                    <div class="row">
                        <div class="col-6"><button type="button" data-dismiss="modal" class="btn btn-secondary">Cancel</button></div>
                        <div class="col-6">
                            <button type="submit" name="submit" class="btn btn-success pull-right">Add</button>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <?php echo form_close();?>
    </div>
</div>
<!-- End: Add Countries Modal -->


<?php
include VIEWPATH.'includes/footer.php';?>
<script src="<?php echo base_url('resources')?>/assets/plugins/custom/datatables/datatables.bundle.js" type="text/javascript"></script>
<?php
include __DIR__.'/scripts.php';
//include __DIR__.'/common.php';
?>

<script type="text/javascript">
    // Begin : Add Countries, Categories and Plans
    $( function(){

        $("#asset-types").on('show.bs.modal', function (event) {
            $("form#asset-type-form").resetForm();
        })

        $("form#asset-type-form").submit( function(event){
            const  form = $(this);
            event.preventDefault();
            let formData = form.serialize();
            $.ajax({
                url: "<?php echo base_url('assets/index/new_asset_type');?>",
                data: formData,
                type: "post",
                beforeSend: function(){
                    KTApp.block(form,{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Adding asset type ..."
                    });
                },
                success: function(result){
                    KTApp.unblock(form);
                    if( result.status == true){
                        notifySuccess(result.message);
                        $("form#asset-type-form").resetForm();
                        var table = $.fn.dataTable.tables( { api: true } );
                        table.ajax.reload();

                    }else{
                        swal.fire("","An error occurred! "+ result.message,"warning");
                    }
                },
                error: function(xhr){
                    KTApp.unblock(form);
                    <?php if(ENVIRONMENT !== 'production'){?>
                    Swal.fire('Server Error!', xhr.statusText,'warning');
                    <?php }?>
                }

            })
        });

        $("form#modify-country-form").submit( function(event){
            const  form = $(this);
            event.preventDefault();
            let formData = form.serialize();
            $.ajax({
                url: "<?php echo base_url('freight/index/modify_country');?>",
                data: formData,
                type: "post",
                beforeSend: function(){
                    KTApp.block(form,{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Modifying country ..."
                    });
                },
                success: function(result){
                    KTApp.unblock(form);
                    if( result.status == true){
                        $("#modify-country-modal").modal("hide");
                        notifySuccess(result.message);
                        var table = $.fn.dataTable.tables( { api: true } );
                        table.ajax.reload();

                    }else{
                        swal.fire("","An error occurred! "+ result.message,"warning");
                    }
                },
                error: function(xhr){
                    KTApp.unblock(form);
                    <?php if(ENVIRONMENT !== 'production'){?>
                    Swal.fire('Server Error!', xhr.statusText,'danger');
                    <?php }?>
                }

            })
        });

        $("form#modify-category-form").submit( function(event){
            const  form = $(this);
            event.preventDefault();
            let formData = form.serialize();
            $.ajax({
                url: "<?php echo base_url('freight/index/modify_category');?>",
                data: formData,
                type: "post",
                beforeSend: function(){
                    KTApp.block(form,{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Modifying category ..."
                    });
                },
                success: function(result){
                    KTApp.unblock(form);
                    if( result.status == true){
                        $("#modify-category-modal").modal("hide");
                        notifySuccess(result.message);
                        var table = $.fn.dataTable.tables( { api: true } );
                        table.ajax.reload();

                    }else{
                        swal.fire("","An error occurred! "+ result.message,"warning");
                    }
                },
                error: function(xhr){
                    KTApp.unblock(form);
                    <?php if(ENVIRONMENT !== 'production'){?>
                    Swal.fire('Server Error!', xhr.statusText,'danger');
                    <?php }?>
                }

            })
        });

        $("form#modify-plan-form").submit( function(event){
            const  form = $(this);
            event.preventDefault();
            let formData = form.serialize();
            $.ajax({
                url: "<?php echo base_url('freight/index/modify_plan');?>",
                data: formData,
                type: "post",
                beforeSend: function(){
                    KTApp.block(form,{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Modifying plan ..."
                    });
                },
                success: function(result){
                    KTApp.unblock(form);
                    if( result.status == true){
                        $("#modify-plan-modal").modal("hide");
                        notifySuccess(result.message);
                        var table = $.fn.dataTable.tables( { api: true } );
                        table.ajax.reload();

                    }else{
                        swal.fire("","An error occurred! "+ result.message,"warning");
                    }
                },
                error: function(xhr){
                    KTApp.unblock(form);
                    <?php if(ENVIRONMENT !== 'production'){?>
                    Swal.fire('Server Error!', xhr.statusText,'danger');
                    <?php }?>
                }

            })
        });

        $('#modify-country-modal').on('show.bs.modal', function (event) {
            var modal = $(this)
            modal.find('.modal-body').html('Please wait ...');
            var button = $(event.relatedTarget)
            var key = button.data('key')
            modal.find('.modal-body').load('<?php echo base_url('freight/index/country_details/');?>' + key);
        })

        $('#modify-category-modal').on('show.bs.modal', function (event) {
            var modal = $(this)
            modal.find('.modal-body').html('Please wait ...');
            var button = $(event.relatedTarget)
            var key = button.data('key')
            modal.find('.modal-body').load('<?php echo base_url('freight/index/category_details/');?>' + key);
        })

        $('#modify-plan-modal').on('show.bs.modal', function (event) {
            var modal = $(this)
            modal.find('.modal-body').html('Please wait ...');
            var button = $(event.relatedTarget)
            var key = button.data('key')
            modal.find('.modal-body').load('<?php echo base_url('freight/index/plan_details/');?>' + key);
        })

        $("#categories").on('show.bs.modal', function (event) {
            $("form#add-category-form").resetForm();
        })

        $("form#add-category-form").submit( function(event){
            const  form = $(this);
            event.preventDefault();
            let formData = form.serialize();
            $.ajax({
                url: "<?php echo base_url('freight/addcategory');?>",
                data: formData,
                type: "post",
                beforeSend: function(){
                    KTApp.block(form,{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Adding category, Please wait ..."
                    });
                },
                success: function(result){
                    KTApp.unblock(form);
                    if( result.status == true){
                        notifySuccess(result.message);
                        $("form#add-category-form").resetForm();
                        var table = $.fn.dataTable.tables( { api: true } );
                        table.ajax.reload();

                    }else{
                        swal.fire("","An error occurred! "+ result.message,"warning");
                    }
                },
                error: function(xhr){
                    KTApp.unblock(form);
                    <?php if(ENVIRONMENT !== 'production'){?>
                    Swal.fire('Server Error!', xhr.statusText,'danger');
                    <?php }?>
                }

            })
        });

        $("#plans").on('show.bs.modal', function (event) {
            $("form#add-plan-form").resetForm();
        })

        $("form#add-plan-form").submit( function(event){
            const  form = $(this);
            event.preventDefault();
            let formData = form.serialize();
            $.ajax({
                url: "<?php echo base_url('freight/addplan');?>",
                data: formData,
                type: "post",
                beforeSend: function(){
                    KTApp.block(form,{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"danger",
                        message:"Adding plan, Please wait ..."
                    });
                },
                success: function(result){
                    KTApp.unblock(form);
                    if( result.status == true){
                        notifySuccess(result.message);
                        $("form#add-plan-form").resetForm();
                        var table = $.fn.dataTable.tables( { api: true } );
                        table.ajax.reload();

                    }else{
                        swal.fire("","An error occurred! "+ result.message,"warning");
                    }
                },
                error: function(xhr){
                    KTApp.unblock(form);
                    <?php if(ENVIRONMENT !== 'production'){?>
                    Swal.fire('Server Error!', xhr.statusText,'danger');
                    <?php }?>
                }

            })
        });



    })
    // End : Add plans

    function deleteCountry(country){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('freight/index/delete_country')?>/' + country,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Deleting Country ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.ajax.reload();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    function deleteCategory(category){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('freight/index/delete_category')?>/' + category,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Deleting Category ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.ajax.reload();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    function deletePlan(plan){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('freight/index/delete_plan')?>/' + plan,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Deleting Plan ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.ajax.reload();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    function restoreCountry(country){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Restore it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('freight/index/restore_country')?>/' + country,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Restoring Country ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.ajax.reload();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    function restoreCategory(category){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Restore it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('freight/index/restore_category')?>/' + category,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Restoring Category ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.ajax.reload();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    function restorePlan(plan){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Restore it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('freight/index/restore_plan')?>/' + plan,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Restoring Plan ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.ajax.reload();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }


</script>

<!--end::Page Scripts -->
</body>

<!-- end::Body -->
</html>

