<script type="text/javascript">


var Datatable = function() {

	var initTables = function() {
		var ledgers = $('#bms_ledgers');

		if(ledgers != undefined){
            // begin ledgers table
            ledgers.DataTable({
                "ordering": true,
                responsive: true,
                "order": [[ 0, "desc" ]],
                buttons: [
                    'print',
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                ],
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
			<'row'<'col-sm-12'tr>>
			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                searchDelay: 500,
                processing: true,
                serverSide: true,
                ajax: '<?php echo base_url('accounting/gl/index/datasource');?>',
                columns: [
                    {data: 'gl_date'},
                    {data: 'gl_reference'},
                    {data: 'gl_type'},
                    {data: 'gl_account'},
                    {data: 'gl_debit'},
                    {data: 'gl_credit'},
                    {data: 'gl_balance'},
                ],
                drawCallback: function(settings) {
                    var api = this.api();
                    var rows = api.rows({page: 'current'}).nodes();
                    var last = null;
                    api.column(1, {page: 'current'}).data().each(function(group, i) {
                        if (last !== group) {
                            $(rows).eq(i).before(
                                '<tr class="group" style="height: 0px;">' +
                                '<td colspan="9" cellpadding="0" cellspacing="0" style="height: 0px;"> </td>' +
                                '</tr>',
                            );
                            last = group;
                        }
                    });
                },
                columnDefs: [
                    {   orderable: true,
                        targets: 0,
                    },
                    {   orderable: false,
                        targets: 1,
                    },
                    {   orderable: false,
                        targets: 2,
                    },
                    {   orderable: false,
                        targets: 3,
                        render: function (data, type, full, meta) {
                            return '<a  href="<?= base_url('accounting/account/history/') ?>' + full.gl_account + '">' + full.account_name + '</a>';
                        },
                    },

                    {   orderable: false,
                        targets: 4,
                        render: function (data, type, full, meta) {
                            if(full.gl_debit > 0){
                                return "Debit";
                            }else{
                                return "Credit"
                            }

                        },
                    },
                    {
                        targets: 5,
                        orderable: false,
                        render: function (data, type, full, meta) {
                            if(full.gl_debit > 0){
                                var number = numeral(to_money(full.gl_debit));
                            }else{
                                var number = numeral(to_money(full.gl_credit));
                            }

                            return number.format(0,0) ;
                        },
                    },{
                        orderable: false,
                        targets: 6,
                        render: function (data, type, full, meta) {
                            var number = numeral(to_money(full.gl_balance));
                            return number.format(0,0) ;
                        },
                    },
                    {
                        targets: 7,
                        "width": "5%",
                        render: function (data, type, full, meta) {
                          return '<a class=""  href="javascript:deleteGlRecord('+ full.gl_key +');"><i class="la la-trash kt-font-danger"></i></a>\n' ;
                        },
                    },
                ],
            });

        }

        var ledgersBin = $('#bms_ledgers_bin');

        if(ledgersBin != undefined){
            // begin ledgers Bin table
            ledgersBin.DataTable({
                "ordering": false,
                responsive: true,
                buttons: [
                    'print',
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                ],
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
			<'row'<'col-sm-12'tr>>
			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                searchDelay: 500,
                processing: true,
                serverSide: true,
                ajax: '<?php echo base_url('accounting/gl/index/datasourcebin/'.$when);?>',
                columns: [
                    {data: 'gl_date'},
                    {data: 'gl_reference'},
                    {data: 'gl_type'},
                    {data: 'gl_account'},
                    {data: 'gl_debit'},
                    {data: 'gl_credit'},
                    {data: 'gl_balance'},
                ],
                columnDefs: [
                    {   orderable: false,
                        targets: 3,
                        render: function (data, type, full, meta) {
                            return '<a  href="javascript:(0);">' + full.account_name + '</a>';
                        },
                    },

                    {   orderable: false,
                        targets: 4,
                        render: function (data, type, full, meta) {
                            if(full.gl_debit > 0){
                                return "Debit";
                            }else{
                                return "Credit"
                            }

                        },
                    },
                    {
                        targets: 5,
                        orderable: false,
                        render: function (data, type, full, meta) {

                            if(full.gl_debit > 0){
                                var number = numeral(to_money(full.gl_debit));
                            }else{
                                var number = numeral(to_money(full.gl_credit));
                            }

                            return number.format(0,0) ;
                        },
                    },{
                        orderable: false,
                        targets: 6,
                        render: function (data, type, full, meta) {
                            var number = numeral(to_money(full.gl_balance));
                            return number.format(0,0) ;
                        },
                    },
                    {
                        targets: 7,
                        "width": "5%",
                        render: function (data, type, full, meta) {
                            return '<a class=""  href="javascript:restoreGlRecord('+ full.gl_key +');"><i class="la la-reply kt-font-success"></i></a>\n' ;
                        },
                    },
                ],

            });

        }

	};

	return {

		//main function to initiate the module
		init: function() {
			initTables();
		},

	};

}();

    jQuery(document).ready(function() {
        Datatable.init();
    });
</script>
