<script>

    function deleteGlRecord(gl){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('accounting/transactions/deleteledger')?>/' + gl,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Deleting record ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.ajax.reload();
                        }else{
                            swal.fire("Response",result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Response', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    function restoreGlRecord(ledger){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Restore it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('accounting/transactions/restoreledger')?>/' + ledger,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Restoring Record..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }


</script>
