<?php
if (!empty($_GET['when'])) {
    $when = '?when='.htmlspecialchars(strtolower(urldecode(trim($_GET['when']))));
} else {
    $when = '';
}
?>
<script type="text/javascript">

    "use strict";

    //== Class definition
    //$.fn.dataTable.Api.register('column().title()', function() {
        //return $(this.header()).text().trim();
    //});

    var Datatable = function() {

        var initTables = function()
        {
            var financialPeriods = $('#financial-periods-list-table');
            if(financialPeriods != undefined) {
                // begin periods table
                financialPeriods.DataTable({
                    "ordering": false,
                    responsive: true,
                    buttons: [
                        'print',
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        'pdfHtml5',
                    ],
                    dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
                            <'row'<'col-sm-12'tr>>
                            <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                    searchDelay: 500,
                    processing: false,
                    serverSide: false,
                    ajax: '<?php echo base_url('accounting/settings/index/datasource_financial_periods');?>',
                    columns: [
                        {data: 'fp_id'},
                        {data: 'fp_start'},
                        {data: 'fp_end'},
                        {data: 'fp_prefix'},
                        {data: 'fp_status'}
                    ],
                    columnDefs: [
                        {
                            targets: 4,
                            "width": "20%",
                            render: function (data, type, full, meta) {
                                var status = {
                                    "Approved": {'fp_status': 'Approved', 'class': 'kt-badge--success'},
                                    "Active": {'fp_status': 'Active', 'class': 'kt-badge--success'},
                                    "Inactive": {'fp_status': 'Inactive', 'class': ' kt-badge--warning'},
                                    "Rejected": {'fp_status': 'Rejected', 'class': ' kt-badge--danger'},
                                    "Closed": {'fp_status': 'Closed', 'class': ' kt-badge--danger'},
                                    "Pending Reject": {'fp_status': 'Pending Rejected', 'class': ' kt-badge--dark'},
                                };
                                if (typeof status[data] === 'undefined') {
                                    return data;
                                }
                                if (full.fp_status === 'Active') {
                                    return '<a href="javascript:(0);" data-toggle="modal" data-backdrop="static" data-key="' + full.fp_key + '"><span class="kt-badge ' + status[data].class + ' kt-badge--wide kt-badge--inline kt-font-bolder">' + status[data].fp_status + '</span></a> ' +
                                        '<div class="dropdown dropdown-inline">\n' +
                                        '                            <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                        '                                <i class="flaticon-more"></i>\n' +
                                        '                            </span>\n' +
                                        '                            <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                        '                                <a class="dropdown-item"  href="#modify-period" data-toggle="modal" data-backdrop="false" data-key="' + full.fp_key + '"><i class="la la-edit kt-font-info"></i>Modify</a>\n' +
                                        '                                <a class="dropdown-item"  href="javascript:deactivateFinancial(' + full.fp_key + ');"><i class="la la-eye kt-font-danger"></i> Set Inactive</a>\n' +
                                        '                                <a class="dropdown-item"  href="javascript:deleteFinancial(' + full.fp_key + ');"><i class="la la-trash kt-font-danger"></i>Delete</a>\n' +
                                        '                            </div>\n' +
                                        '                        </div>';
                                } else {
                                    return '<a href="javascript:(0);" data-toggle="modal" data-backdrop="static" data-key="' + full.fp_key + '"><span class="kt-badge ' + status[data].class + ' kt-badge--wide kt-badge--inline kt-font-bolder">' + status[data].fp_status + '</span></a> ' +
                                        '<div class="dropdown dropdown-inline">\n' +
                                        '                            <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                                        '                                <i class="flaticon-more"></i>\n' +
                                        '                            </span>\n' +
                                        '                            <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                        '                                <a class="dropdown-item"  href="#modify-period" data-toggle="modal" data-backdrop="false" data-key="' + full.fp_key + '"><i class="la la-edit kt-font-info"></i>Modify</a>\n' +
                                        '                                <a class="dropdown-item"  href="javascript:activateFinancial(' + full.fp_key + ');"><i class="la la-eye kt-font-success"></i> Set Active</a>\n' +
                                        '                                <a class="dropdown-item"  href="javascript:deleteFinancial(' + full.fp_key + ');"><i class="la la-trash kt-font-danger"></i>Delete</a>\n' +
                                        '                            </div>\n' +
                                        '                        </div>';
                                }
                            },
                        }
                    ],
                });
            }
            var financialPeriodsBin = $('#financial-periods-list-bin-table');
            if(financialPeriodsBin != undefined){
                // begin periods bin table
                financialPeriodsBin.DataTable({
                    "ordering": false,
                    responsive: true,
                    buttons: [
                        'print',
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        'pdfHtml5',
                    ],
                    dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
                            <'row'<'col-sm-12'tr>>
                            <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                    searchDelay: 500,
                    processing: false,
                    serverSide: false,
                    ajax: '<?php echo base_url('accounting/settings/index/datasource_financial_periods_bin');?>',
                    columns: [
                        {data: 'fp_id'},
                        {data: 'fp_start'},
                        {data: 'fp_end'},
                        {data: 'fp_prefix'},
                        {data: 'fp_status'},
                    ],
                    columnDefs: [
                        {
                            targets: 4,
                            "width": "15%",
                            render: function (data, type, full, meta) {
                                return  '<a  href="javascript:restoreFinancial('+ full.fp_key  +');"><i class="la la-reply-all kt-font-success"></i> Restore</a>\n';
                            },
                        }
                    ],
                });

            }
        };

        return {
            //main function to initiate the module
            init: function() {
                initTables();
            },

        };

    }();

    jQuery(document).ready(function() {
        Datatable.init();
    });

</script>
