<div class="modal" id="edit-account" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-body" style="min-height: 100px;"> </div>
        </div>
    </div>
</div>

<script type="text/javascript">

    "use strict";

    var KTPortletTools = function () {

        // chat of accounts
        var accounts = function() {
            // This portlet is lazy initialized using data-portlet="true" attribute. You can access to the portlet object as shown below and override its behavior
            let accounts = new KTPortlet('kt_portlet_chat_of_accounts');

            // Toggle event handlers
            accounts.on('beforeCollapse', function(portlet) {

            });

            accounts.on('afterCollapse', function(portlet) {

            });

            accounts.on('beforeExpand', function(portlet) {

            });

            accounts.on('afterExpand', function(portlet) {

            });

            // Remove event handlers
            accounts.on('beforeRemove', function(portlet) {
                return confirm('Are you sure to remove this block ?');
            });

            accounts.on('afterRemove', function(portlet) {

            });

            // Reload event handlers
            accounts.on('reload', function(portlet) {

                KTApp.block(portlet.getSelf(), {
                    overlayColor: '#ffffff',
                    type: 'loader',
                    state: 'success',
                    opacity: 0.3,
                    size: 'lg'
                });

                var table = $.fn.dataTable.tables( { api: true } );
                table.ajax.reload();

                notifySuccess("Reloaded chat of accounts");
                KTApp.unblock(portlet.getSelf());

            });

            // Reload event handlers
            accounts.on('afterFullscreenOn', function(portlet) {
                var scrollable = $(portlet.getBody()).find('> .kt-scroll');

                if (scrollable) {
                    scrollable.data('original-height', scrollable.css('height'));
                    scrollable.css('height', '100%');

                    KTUtil.scrollUpdate(scrollable[0]);
                }
            });

            accounts.on('afterFullscreenOff', function(portlet) {
                var scrollable = $(portlet.getBody()).find('> .kt-scroll');

                if (scrollable) {
                    var scrollable = $(portlet.getBody()).find('> .kt-scroll');
                    scrollable.css('height', scrollable.data('original-height'));

                    KTUtil.scrollUpdate(scrollable[0]);
                }
            });
        }

        return {
            //main function to initiate the module
            init: function () {
                // init portlets
                accounts();
            }
        };
    }();

    var LMDatatableAccounts = function() {

        var initTable = function() {
            // begin first table
            let table = $('#lm_table_accounts');
            if(table != undefined) {
                table.DataTable({
                    responsive: true,
                    serverSide: false,
                    ajax: '<?php echo base_url('accounting/chatofaccounts/datasource');?>',
                    columns: [
                        {data: 'account_number'},
                        {data: 'account_name'},
                        {data: 'type_name'},
                        {data: 'subtype_name'},
                    ],
                    // Pagination settings

                    // dom: `<'row'<'col-sm-12'tr>>
    			    // <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,

                    dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
                    <'row'<'col-sm-12'tr>>
                    <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                    lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
                    pageLength: 10,
                    language: {
                        'lengthMenu': 'Display _MENU_',
                        buttons: {
                            selectAll: "Select all",
                            selectNone: "Select none"
                        },
                        "emptyTable": "No record found",
                    },
                    searchDelay: 500,
                    buttons: [
                        'print',
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        'pdfHtml5',
                    ],
                    columnDefs: [
                        {
                            targets: 1,
                            "width": "25%",
                            render: function (data, type, full, meta) {
                                return '<a href="<?php echo base_url('accounting/account/history/');?>' + full.account_key + '" >' + full.account_name + '</a> ';
                            },
                        },
                        {
                            targets: 4,
                            "width": "15%",
                            render: function (data, type, full, meta) {
                                return '<a href="<?php echo base_url('accounting/account/history/');?>' + full.account_key + '" >Transactions </a> &nbsp' +
                                    '<div class="dropdown dropdown-inline pull-right">\n' +
                                    ' <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                '                                <i class="flaticon-more-v2"></i>\n' +
                '                            </span>\n' +
                                    ' <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                                    ' <a class="dropdown-item"  data-backdrop="false" data-keyboard="false" data-toggle="modal" data-key="' + full.account_key + '" href="#edit-account"><i class="la la-edit"></i> Details</a>\n' +
                                    ' <div class="dropdown-divider"></div>' +
                                    ' <a class="dropdown-item"  href="javascript:deleteAccount(' + full.account_key + ');"><i class="la la-trash kt-font-danger"></i> Delete</a>\n' +
                                    ' </div>\n' +
                                    ' </div>';
                            },
                        },
                    ]
                });
            }
        };

        return {
            //main function to initiate the module
            init: function() {
                initTable();
            },

        };

    }();

  jQuery(document).ready(function() {

      LMDatatableAccounts.init();
      KTPortletTools.init();

  });

    function deleteAccount(account){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('accounting/chatofaccounts/deleteaccount')?>/'+account,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.block("#lm_table_accounts",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Deleting account ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblock('#lm_table_accounts');
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.ajax.reload();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_accounts');
                        <?php if(ENVIRONMENT !== 'production'){?>
                            Swal.fire('Server Error!', xhr.statusText,'danger');
                        <?php }?>
                    }
                });
            }
        })
    }

    function deleteSelected(table){
        if(table.rows('.selected').data().length<1)
            return;
        var data= [];
        $.each(table.rows('.selected').data(), function() {
            data.push(this["account_key"]);
        });
        Swal.fire({
            title: 'Are you sure?',
            text: "You are going to DELETE " + table.rows('.selected').data().length + " accounts",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Delete them!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('accounting/chatofaccounts/deleteselected/');?>',
                    type: 'get',
                    data: {'data':data},
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Please wait ..."
                        });
                    },
                    success: function(result){
                        alert(result);
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.ajax.reload();
                        }else{
                            Swal.fire('Response',result.message,'warning');
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                            Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

</script>
