<script>

    function deleteLedger(ledger){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#dc100b',
            cancelButtonColor: '#09ab04',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('accounting/transactions/deleteledger')?>/' + ledger,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Deleting Record ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    function restoreLedger(ledger){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Restore it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('accounting/transactions/restoreledger')?>/' + ledger,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Restoring Record..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    function approveLedger(ledger){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Approve it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('accounting/transactions/approveledger')?>/' + ledger,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Approving Record..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    function pendingLedger(ledger){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Set Pending!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('accounting/transactions/pendingledger')?>/' + ledger,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Please wait..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

</script>
