<!-- begin::Head -->
<?php include VIEWPATH.'includes/header.php';?>
<!-- end::Head -->
<style>
    td {word-wrap: break-word}
    #journaloice{
        padding: 30px;
    }

    .journaloice {
        position: relative;
        background-color: #FFF;
        min-height: 680px;
        padding: 15px
    }

    .journaloice header {
        padding: 10px 0;
        margin-bottom: 20px;
        border-bottom: 1px solid #3989c6
    }

    .journaloice .company-details {
        text-align: right
    }

    .journaloice .company-details .name {
        margin-top: 0;
        margin-bottom: 0
    }

    .journaloice .contacts {
        margin-bottom: 20px
    }

    .journaloice .journaloice-to {
        text-align: left
    }

    .journaloice .journaloice-to .to {
        margin-top: 0;
        margin-bottom: 0
    }

    .journaloice .journaloice-details {
        text-align: right
    }

    .journaloice .journaloice-details .journaloice-id {
        margin-top: 0;
        color: #3989c6
    }

    .journaloice main {
        padding-bottom: 50px
    }

    .journaloice main .thanks {
        margin-top: -100px;
        font-size: 2em;
        margin-bottom: 50px
    }

    .journaloice main .notices {
        padding-left: 6px;
        border-left: 6px solid #3989c6
    }

    .journaloice main .notices .notice {
        font-size: 1.2em
    }

    .journaloice table {
        width: 100%;
        border-collapse: collapse;
        border-spacing: 0;
        margin-bottom: 20px
    }

    .journaloice table td,.journaloice table th {
        padding: 15px;
        background: #eee;
        border-bottom: 1px solid #fff
    }

    .journaloice table th {
        white-space: nowrap;
        font-weight: 400;
        font-size: 16px
    }

    .journaloice table td h3 {
        margin: 0;
        font-weight: 400;
        color: #3989c6;
        font-size: 1.2em
    }

    .journaloice table .qty,.journaloice table .total,.journaloice table .unit {
        text-align: right;
        font-size: 1.2em
    }

    .journaloice table .no {
        color: #fff;
        font-size: 1.6em;
        background: #3989c6
    }

    .journaloice table .unit {
        background: #ddd
    }

    .journaloice table .total {
        background: #3989c6;
        color: #fff
    }

    .journaloice table tbody tr:last-child td {
        border: none
    }

    .journaloice table tfoot td {
        background: 0 0;
        border-bottom: none;
        white-space: nowrap;
        text-align: right;
        padding: 10px 20px;
        font-size: 1.2em;
        border-top: 1px solid #aaa
    }

    .journaloice table tfoot tr:first-child td {
        border-top: none
    }

    .journaloice table tfoot tr:last-child td {
        color: #3989c6;
        font-size: 1.4em;
        border-top: 1px solid #3989c6
    }

    .journaloice table tfoot tr td:first-child {
        border: none
    }

    .journaloice footer {
        width: 100%;
        text-align: center;
        color: #777;
        border-top: 1px solid #aaa;
        padding: 8px 0
    }

    @media print {
        .journaloice {
            font-size: 11px!important;
            overflow: hidden!important
        }

        .journaloice footer {
            position: absolute;
            bottom: 10px;
            page-break-after: always
        }

        .journaloice>div:last-child {
            page-break-before: always
        }
    }
</style>
<!-- begin:: Aside Menu -->
<?php include VIEWPATH.'menus/left.php';?>
<!-- end:: Aside Menu -->

<!-- begin:: Header Menu -->
<?php include VIEWPATH.'menus/top.php';?>
<!-- end:: Header Menu -->

<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">

    <?php topMenuJournals();?>

    <!-- begin:: Content -->
    <div class="kt-container kt-container--fluid">
        <div class="row">
            <div class="col-12">
                <div class="bs-example">
                    <nav >
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:(0);">Journals</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:(0);">Journal details</a></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>

        <div class="kt-portlet" >
            <!--                onsubmit="create_journaloice(); return false;"-->
            <div class="kt-portlet__body kt-portlet__body--fullheight">
                <!--Author      : @arboshiki-->
                <div >

                    <div class="toolbar hidden-print">
                        <div class="text-right">
                            <?php if(strtolower($journal['journal_status']) == "draft"){?>
                                <a href="<?php echo base_url('accounting/journals/modify/'.$journal['journal_key']);?>" class="btn btn-info"><i class="la la-edit"></i> Modify</a>
                            <?php } ?>
                            <button id="printInvoice" class="btn btn-info"><i class="fa fa-print"></i> Print</button>
                            <button id="printInvoice" class="btn btn-info"><i class="la la-envelope"></i> Send</button>
                        </div>
                        <hr>
                    </div>
                    <div class="journaloice overflow-auto" id="journaloice">
                        <div style="min-width: 600px">
                            <header>
                                <div class="row">
                                    <div class="col">
                                        <a  href="javascript:(0);">
                                            <?php
                                            $text = "{'id':'".$journal['journal_id']."', 'key':'".$journal['journal_key']."','title':'".$journal['journal_title']."', 'date':'".$journal['journal_date']."', 'type':'".$journal['journal_type']."'}";
                                            $path = writablePath('journals/qrimages/'.$journal['journal_key'].'.png');
                                            $qrurl = writablePathUrl('journals/qrimages/'.$journal['journal_key'].'.png');
                                            $this->qrcodes->createImage($text,$path);
                                            ?>
                                            <img data-holder-rendered="true" class="pull-left"  style="display: block; width: 120px; height: auto;  margin-left: 0px;" src="<?php echo $qrurl;?>" />
                                        </a>
                                    </div>
                                    <div class="col company-details">
                                        <h2 class="name">
                                            <a target="_blank" href="https://lobianijs.com">
                                                <?= runningBusiness()->business_name ?><br/>
                                                <?= runningBranch()->branch_name ?>
                                            </a>
                                        </h2>
                                        <div><?= runningBranch()->branch_address ?></div>
                                        <div><?= runningBranch()->branch_phone ?></div>
                                        <div><?= runningBranch()->branch_email ?></div>
                                    </div>
                                </div>
                            </header>
                            <main>
                                <div class="row contacts">
                                    <div class="col journaloice-to">
                                        <div class="text-gray-light">Information:</div>
                                        <h2 class="to"><?=  $journal['journal_title'] ?></h2>
                                    </div>
                                    <div class="col journaloice-details">
                                        <h1 class="journaloice-id">JOURNAL <?=  $journal['journal_id'] ?></h1>
                                        <div class="date">Date : <?=  date("d/m/Y",strtotime($journal['journal_date'])) ?></div>
                                        <div class="date">Type : <?=  $journal['journal_type'] ?></div>
                                    </div>
                                </div>
                                <?php if(!empty($items)){?>
                                <table border="0" cellspacing="0" cellpadding="0">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th class="text-left">DESCRIPTION</th>
                                        <th class="text-right">PRICE</th>
                                        <th class="text-right">QUANTITY</th>
                                        <th class="text-right">ACCOUNT</th>
                                        <th class="text-right">DEBIT</th>
                                        <th class="text-right">CREDIT</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php if(!empty($items)){
                                        foreach ($items as $i => $item){ ?>
                                            <tr>
                                                <td rowspan="2" class="no"><?= $i + 1;?></td>
                                                <td rowspan="2" class="text-left">
                                                    <h3>
                                                        <a  href="javascript:(0);">
                                                            <?= $item['journal_item'];?>
                                                        </a>
                                                    </h3>
                                                    <?= $item['journal_item_details'];?>
                                                </td>
                                                <td rowspan="2" class="unit"><?= number_format(to_money($item['journal_item_price']));?></td>
                                                <td rowspan="2" class="qty"><?= number_format($item['journal_item_qty']);?></td>
                                                <td  class="qty"><?= $this->accountingModel->account($item['journal_item_debit_account'])->account_name;?></td>
                                                <td class="total"><?= number_format(to_money($item['journal_item_total']));?></td>
                                                <td class="total">0</td>
                                            </tr>
                                            <tr>
                                                <td  class="qty"><?= $this->accountingModel->account($item['journal_item_credit_account'])->account_name;?></td>
                                                <td class="total">0</td>
                                                <td class="total"><?= number_format(to_money($item['journal_item_total']));?></td>
                                            </tr>
                                        <?php }
                                    } ?>

                                    </tbody>
                                    <tfoot>

                                    </tfoot>
                                </table>
                                <?php } ?>
                            </main>
                            <footer>
                                Invoice was created on a computer and is valid without the signature and seal.
                            </footer>
                        </div>
                        <!--DO NOT DELETE THIS div. IT is responsible for showing footer always at the bottom-->
                        <div></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- end:: Content -->
</div>

<?php include VIEWPATH.'includes/footer.php';?>

<script>
    $('#printInvoice').click(function(){
        Popup($('#journaloice').outerHTML);
        function Popup(data)
        {
            window.print();
            return true;
        }
    });
</script>

<!--end::Page Scripts -->
</body>
<!-- end::Body -->
</html>

