<?php
$lm =& get_instance();
$amount = 0;
    for($i = 0; $i < count($activityArray); $i++){
        $amount += ($activityArray[$i]['gl_debit'] + $activityArray[$i]['gl_credit'])/2;
    }
?>
<h3 class="kt-font-brand">Journal Entry | Loan Return</h3><hr/>
<?php echo form_open('#',['id'=>'return-form','onsubmit'=>'journalreturnform(); return false;']);?>
<div class="row form-group">
    <div class="col-12">
        <label>Journal Title</label>
        <input class="form-control" value="<?php echo $activity->j_title;?>" name="return_journal_title" placeholder="Journal Title" required />
    </div>
</div>
<div class="row form-group">
    <div class="col-4">
        <label>Customer</label>
        <select name="return_customer" id="return-customer" class="form-control" required style="width: 100%;" >
            <option value="">Select Customer</option>
            <?php if(!empty($customers = customers())){
                foreach ($customers as $customer){?>
                    <option <?php if($customer['user_id'] == $activity->gl_loan_customer) echo 'selected';?> value="<?php echo $customer['user_id'];?>"><?php echo $customer['firstname'].' '.$customer['lastname'].' - '.$customer['group_name'];?></option>
                <?php }
            } ?>
        </select>
    </div>
    <div class="col-5" >
        <label>Loan / Application</label>
        <div id="return-application" class="input-group">
           <?php
           $applications = $this->loanApplicationsModel->customerApplications($activity->gl_loan_customer);?>
            <select id="application" onchange="getInstallment(this.value)" name="return_application" class="form-control" style="width: 100%;">
                <option value="">Select Loan/Application</option>
                <?php if(!empty($applications)){
                    foreach ($applications as $app){?>
                            <option <?php if($app['app_key'] == $activity->gl_loan_app_key) echo "selected";?>  value="<?php echo $app['app_key'];?>"><?php echo $app['product_name'].' - '.$app['loan_name'].' - '.runnCurrency()->currency_symbol.number_format(to_money($app['app_principal']));?></option>
                        <?php  }
                } ?>
            </select>
        </div>
    </div>
    <div class="col-3" >
        <label>Installment #</label>
        <div id="return-installment">
            <?php $returns = $this->loanApplicationsModel->returnsAll($activity->gl_loan_app_key);?>
            <select required multiple name="return_payments[]" class="form-control" id="loan-return-number" style="width: 100%;">
                <?php if(!empty($returns)){
                    foreach ($returns as $return){?>
                        <option <?php if(in_array_r($return['loan_payment_number'],$installments)) echo "selected";?>  value="<?php echo $return['loan_payment_id'];?>"><?php echo '#'.$return
                                ['loan_payment_number'].' '.runnCurrency()->currency_symbol.number_format(to_money($return['loan_payment_amount']));?></option>
                    <?php }
                } ?>
            </select>
        </div>
    </div>
</div>
<div class="row form-group">
    <div class="col-4">
        <label>Return Status</label>
        <select required name="return_status" class="form-control">
            <option value="">Select Status</option>
            <option <?php if(strtolower($activity->gl_status) == "approved") echo "selected";?> value="Approved">Approved</option>
            <option  <?php if(strtolower($activity->gl_status) == "pending") echo "selected";?> value="Pending">Pending</option>
            <option  <?php if(strtolower($activity->gl_status) == "rejected") echo "selected";?> value="Rejected">Rejected</option>
        </select>
    </div>
    <div class="col-md-4 col-sm-12">
        <label>Posting Date</label>
        <input type="date" required value="<?php echo date('Y-m-d',strtotime($activity->gl_date));?>"  name="return_date" placeholder="Date posted" class="form-control" />
    </div>
    <div class="col-md-4 col-sm-12">
        <label>Return Amount</label>
        <input type="text" value="<?php echo number_format(to_money($amount));?>" readonly required id="return-amount" name="return_amount" placeholder="Return Amount" class="form-control" />
    </div>
</div>
<div class="row form-group">
    <div class="col-4"></div>
    <div class="col-4">
        <button data-dismiss="modal" type="button" class="btn btn-dark btn-block text-uppercase">Cancel</button>
    </div>
    <div class="col-4">
        <button type="submit" class="btn btn-brand btn-block text-uppercase">Save Changes</button>
    </div>
</div>
<?php form_close();?>

<script type="text/javascript">

    $(function(){
        $("select").select2({placeholder: "select option"});
        $('select#return-customer').change( function(){
            let val = $( this ).val();
            if(val == '')
                return;
            let form =  $('form#return-form');
            let apps = $('div#return-application');

            $.ajax({
                url: '<?php echo base_url($auth_role.'/customers/index/customerAppsSelectOptions/');?>' + val,
                type: 'get',
                beforeSend: function(){
                    KTApp.block(form,{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"success",
                        message:"Loading ..."
                    });
                },
                success: function (result){
                    apps.html(result);
                    KTApp.unblock(form);
                },
                error: function (xhr){
                    KTApp.unblock(form);
                    Swal.fire('',xhr.statusText,'warning');
                }
            })
        })

        $('select#loan-return-number').change( function(){
            let val = $( this ).val();
            if(val == '')
                return;
            let form =  $('form#return-form');
            let amount = $('input#return-amount');
            let formData = form.serialize();
            $.ajax({
                url: '<?php echo base_url($this->auth_role.'/loans/applications/applicationGetInstallmentsAmount');?>',
                type: 'get',
                data: formData,
                beforeSend: function(){
                    KTApp.block(form,{
                        overlayColor:"#000000",
                        type:"loader",
                        state:"success",
                        message:"Loading ..."
                    });
                },
                success: function (result){
                    notifyWarning(result);
                    amount.val(result);
                    KTApp.unblock(form);
                },
                error: function (xhr){
                    KTApp.unblock(form);
                    Swal.fire('',xhr.statusText,'warning');
                }
            })
        })

        $('select').select2({placeholder: "select option"});
    })

    function getInstallment(val){
        if(val == '')
            return;
        let form =  $('form#return-form');
        let apps = $('div#return-installment');

        $.ajax({
            url: '<?php echo base_url($auth_role.'/loans/applications/applicationReturnSelectOptions/');?>' + val ,
            type: 'get',
            beforeSend: function(){
                KTApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Loading ..."
                });
            },
            success: function (result){
                apps.html(result);
                KTApp.unblock(form);
            },
            error: function (xhr){
                KTApp.unblock(form);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }

    function journalreturnform(){
        let form = $('form#return-form');
        let formData = form.serialize();
        $.ajax({
            url: '<?php echo base_url($auth_role.'/accounting/journals/getactions/updatereturn/'.$activity->gl_activity);?>',
            type: 'get',
            data: formData,
            beforeSend: function(){
                KTApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Sending data ..."
                });
            },
            success: function (result){
                KTApp.unblock(form);
                if(result.status == true){
                    form[0].reset();
                    let table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                    $("div#loans-details").modal("hide");
                    Swal.fire('',result.message,'success');
                }else{
                    Swal.fire('',result.message,'warning');
                }
            },
            error: function (xhr){
                KTApp.unblock(form);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }

</script>