<h3 class="kt-font-brand">Journal Entry | Loan Return</h3><hr/>
<?php echo form_open('#',['id'=>'return-form','onsubmit'=>'newreturn(); return false;']);

if(requireAuth()){?>
    <div class="row">
        <div class="col-12 alert alert-danger alert-dismissible fade show   m-alert m-alert--air m-alert--outline m-alert--outline-2x">
            <input required type="password" class="form-control" placeholder="Enter administrator password" name="passwd">
        </div>
    </div>
<?php } ?>
<div class="row form-group">
    <div class="col-12">
        <label>Journal Title</label>
        <input class="form-control " name="return_journal_title" placeholder="Journal Title" required />
    </div>
</div>
<div class="row form-group">
    <div class="col-4">
        <label>Customer</label>
        <select onchange="getApplications(this.value)" name="return_customer"  class="form-control" required style="width: 100%;" >
            <option value="">Select Customer</option>
            <?php if(!empty($customers = customers())){
                foreach ($customers as $customer){?>
                    <option value="<?php echo $customer['user_id'];?>"><?php echo $customer['firstname'].' '.$customer['lastname'].' - '.$customer['group_name'];?></option>
                <?php }
            } ?>
        </select>
    </div>
    <div class="col-4" >
        <label>Loan / Application</label>
        <div id="return-applications" class="input-group">
            <select name="return_application"  class="form-control" required >
                <option value="">Select Loan/Application</option>
            </select>
        </div>
    </div>
    <div class="col-4" >
        <label>Installment Number</label>
        <div id="return-installment">
            <select  name="return_type" class=" form-control" required style="width: 100%;">
                <option value="">Select Installment #</option>
            </select>
        </div>
    </div>
</div>
<div class="row form-group">
    <div class="col-4">
        <label>Return Status</label>
        <select required name="return_status" class="form-control">
            <option value="">Select Status</option>
            <option  value="Approved">Approved</option>
            <option  value="Pending">Pending</option>
            <option  value="Rejected">Rejected</option>
        </select>
    </div>
    <div class="col-md-4 col-sm-12">
        <label>Posting Date</label>
        <input type="date" required  name="return_date" placeholder="Date posted" class="form-control" />
    </div>
    <div class="col-md-4 col-sm-12">
        <label>Return Amount</label>
        <input type="text" readonly required id="return-amount" name="return_amount" placeholder="Return Amount" class="form-control" />
    </div>
</div>
<div class="row form-group">
    <div class="col-4"></div>
    <div class="col-4">
        <button type="button" data-dismiss="modal" class="btn btn-dark btn-block text-uppercase">Cancel</button>
    </div>
    <div class="col-4">
        <button type="submit" class="btn btn-brand btn-block text-uppercase">Collect Return</button>
    </div>
</div>
<?php form_close();?>
<script type="text/javascript">

    $("select").select2();

   function getApplications(val){
       if(val == '')
           return;

       let form =  $('form#return-form');
       let apps = $('div#return-applications');

       $.ajax({
           url: '<?php echo base_url($auth_role.'/customers/index/customerAppsSelectOptions/');?>' + val ,
           type: 'get',
           beforeSend: function(){
               KTApp.block(form,{
                   overlayColor:"#000000",
                   type:"loader",
                   state:"success",
                   message:"Loading ..."
               });
           },
           success: function (result){
               apps.html(result);
               KTApp.unblock(form);
           },
           error: function (xhr){
               KTApp.unblock(form);
               Swal.fire('',xhr.statusText,'warning');
           }
       })
   }


    function getInstallment(val){
        if(val == '')
            return;
        let form =  $('form#return-form');
        let apps = $('div#return-installment');

        $.ajax({
            url: '<?php echo base_url($auth_role.'/loans/applications/applicationReturnSelectOptions/');?>' + val ,
            type: 'get',
            beforeSend: function(){
                KTApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Loading ..."
                });
            },
            success: function (result){
                apps.html(result);
                KTApp.unblock(form);
            },
            error: function (xhr){
                KTApp.unblock(form);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }

    function newreturn(){
        let form = $('form#return-form');
        let formData = form.serialize();
        $.ajax({
            url: '<?php echo base_url($auth_role.'/accounting/journals/getactions/registerreturn/');?>',
            type: 'get',
            data: formData,
            beforeSend: function(){
                KTApp.block(form,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Sending data ..."
                });
            },
            success: function (result){
                KTApp.unblock(form);
                if(result.status == true){
                    $('.modal').modal('hide') // closes all active pop ups.
                    $('.modal-backdrop').remove() // removes the grey overlay.
                    let table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                    Swal.fire('',result.message,'success');
                }else{
                    Swal.fire('',result.message,'warning');
                }
            },
            error: function (xhr){
                KTApp.unblock(form);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }


</script>
