<?php
if(!empty($_GET['when'])) {
    $when = htmlspecialchars(strtolower(urldecode(trim($_GET['when']))));
}else{
    $when ='';
}
?>
<script type="text/javascript">

  //== Class definition
  $.fn.dataTable.Api.register('column().title()', function() {
      return $(this.header()).text().trim();
  });

var Datatable = function() {

	var initTable = function() {
		var table = $('#lm_table');

		// begin first table
		table.DataTable({
            "ordering": false,
			responsive: true,
            buttons: [
                {
                    className: "new-return",
                    text: '<b>New Expense</b>',
                    action: function ( e, dt, node, config ) {
                        newExpenseModal();
                    }
                },
                'print',
                'copyHtml5',
                'excelHtml5',
                'csvHtml5',
                'pdfHtml5',
            ],
            dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
			<'row'<'col-sm-12'tr>>
			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
			searchDelay: 500,
			processing: true,
			serverSide: true,
			ajax: '<?php echo base_url($auth_role.'/accounting/journals/overview/datasourceexpenses/'.$when);?>',
			columns: [
                {data: 'gl_date'},
                {data: 'j_title'},
                {data: 'expense_payee'},
				{data: 'account_name'},
                {data: 'account_code'},
                {data: 'gl_debit'},
                {data: 'gl_credit'},
                {data: 'gl_status'},
			],
            drawCallback: function(settings) {
                var api = this.api();
                var rows = api.rows({page: 'current'}).nodes();
                var last = null;

                api.column(1, {page: 'current'}).data().each(function(group, i) {
                    if (last !== group) {
                        $(rows).eq(i).before(
                            '<tr class="group"><td colspan="10">' + group + '</td></tr>',
                        );
                        last = group;
                    }
                });
            },
            columnDefs: [
                // {
                //     targets: 0,
                //     render: function(data, type, full, meta) {
                //         return '<a href="#' + full.gl_category + '-details" data-toggle="modal" data-backdrop="static" data-key="'+ full.gl_activity +'">' + data + '</a>';
                //     },
                // },

                {
                    targets: 3,
                    render: function(data, type, full, meta) {
                        return  '<a  href="<?php echo base_url($auth_role.'/accounting/details/');?>' + full.account_id + '">' + full.account_name + '</a>';
                    },
                },
                {
                    targets: 4,
                    render: function(data, type, full, meta) {
                        return  '<a  href="<?php echo base_url($auth_role.'/accounting/details/');?>' + full.account_id + '">' + full.account_code + '</a>';
                    },
                },
                {
                    targets: 5,
                    render: function(data, type, full, meta) {
                        return  numeral(to_money(full.gl_debit)).format('0,0') ;
                    },
                },
                {
                    targets: 6,
                    render: function(data, type, full, meta) {
                        return  numeral(to_money(full.gl_credit)).format('0,0') ;
                    },
                },
                {
                    targets: 7,
                    "width": "15%",
                    render: function(data, type, full, meta) {
                        var status = {
                            "Approved": {'gl_status': 'Approved', 'class': 'kt-badge--success'},
                            "Pending": {'gl_status': 'Pending', 'class': ' kt-badge--warning'},
                            "Rejected": {'gl_status': 'Rejected', 'class': ' kt-badge--danger'},
                            "Pending Reject": {'gl_status': 'Pending Rejected', 'class': ' kt-badge--dark'},
                        };
                        if (typeof status[data] === 'undefined') {
                            return data;
                        }
                        return '<a href="#' + full.gl_category + '-details" data-toggle="modal" data-backdrop="static" data-key="'+ full.gl_activity +'"><span class="kt-badge ' + status[data].class + ' kt-badge--wide kt-badge--inline kt-font-bolder">' + status[data].gl_status + '</span></a> ' +
                            '<div class="dropdown dropdown-inline">\n' +
                            '                            <span  class="kt-badge--wide kt-badge--inline kt-badge kt-badge--brand" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">\n' +
                            '                                <i class="flaticon-more"></i>\n' +
                            '                            </span>\n' +
                            '                            <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(30px, 30px, 0px);">\n' +
                            '                                <a class="dropdown-item"  href="javascript:set'+ full.gl_category + 'StatusApproved('+ full.gl_activity + ');"><i class="la la-toggle-off kt-font-success"></i> Set Approved</a>\n' +
                            '                                <a class="dropdown-item"  href="javascript:set'+ full.gl_category + 'StatusPending('+ full.gl_activity +');"><i class="la la-toggle-off kt-font-warning"></i> Set Pending</a>\n' +
                            '                                <a class="dropdown-item" href="javascript:set'+ full.gl_category + 'StatusRejected('+ full.gl_activity +');"><i class="la la-toggle-off kt-font-danger"></i> Set Rejected</a>\n' +
                            '                                <a class="dropdown-item" href="javascript:set'+ full.gl_category + 'StatusPendingReject('+ full.gl_activity +');"><i class="la la-toggle-off kt-font-dark"></i> Set Pending Rejected</a>\n' +
                            '                                <div class="dropdown-divider"></div>' +
                            '                                <a class="dropdown-item" data-backdrop="static" data-toggle="modal" data-key="'+ full.gl_activity +'" href="#' + full.gl_category + '-details"><i class="la la-cog"></i> Details</a>\n' +
                            '                            </div>\n' +
                            '                        </div>';
                    },
                },
            ],
		});

        var filter = function() {
            var val = $.fn.dataTable.util.escapeRegex($(this).val());
            let table = $.fn.dataTable.tables( { api: true } );
            table.column($(this).data('col-index')).search(val ? val : '', false, false).draw();
        };

        var asdasd = function(value, index) {
            let table = $.fn.dataTable.tables( { api: true } );
            var val = $.fn.dataTable.util.escapeRegex(value);
            table.column(index).search(val ? val : '', false, true);
        };

        $('#m_search').on('click', function(e) {
            e.preventDefault();
            let table = $.fn.dataTable.tables( { api: true } );
            var params = {};
            $('.kt-input').each(function() {
                var i = $(this).data('col-index');
                if (params[i]) {
                    params[i] += '|' + $(this).val();
                }
                else {
                    params[i] = $(this).val();
                }
            });
            $.each(params, function(i, val) {
                // apply search params to datatable
                table.column(i).search(val ? val : '', false, false);
            });
            table.table().draw();
        });

        $('#m_reset').on('click', function(e) {
            e.preventDefault();
            let table = $.fn.dataTable.tables( { api: true } );
            $('.kt-input').each(function() {
                $(this).val('');
                table.column($(this).data('col-index')).search('', false, false);
            });
            table.table().draw();
        });

        $('#kts_datepicker').datepicker({
            todayHighlight: true,
            templates: {
                leftArrow: '<i class="la la-angle-left"></i>',
                rightArrow: '<i class="la la-angle-right"></i>',
            },
        });
	};

	return {

		//main function to initiate the module
		init: function() {
			initTable();
		},

	};

}();

    jQuery(document).ready(function() {
        Datatable.init();
    });
</script>
