<script>

    function setINVOICESStatusApproved(ledger){
        $.fn.modal.Constructor.prototype._enforceFocus = function() {};
        $(document).off('focusin.modal');
        Swal.fire({
            title: 'Submit access password',
            input: 'password',
            inputPlaceholder: "Enter password",
            inputAttributes: {
                autocapitalize: 'off'
            },
            showCancelButton: true,
            confirmButtonText: 'Approve',
            showLoaderOnConfirm: true,
            preConfirm: (login) => {
                return fetch(`<?php echo base_url('accounting/gl/index/setinvoicestatus')?>/${login}/${ledger}/Approved`)
                    .then(response => {
                        if (!response.ok) {
                            throw new Error(response.statusText)
                        }
                        return response.json()
                    })
                    .catch(error => {
                        Swal.showValidationMessage(
                            `Request failed: ${error}`
                        )
                    })
            },
            allowOutsideClick: () => !Swal.isLoading()
        }).then((responses) => {
            if (responses.value) {
                if(responses.value.status == true){
                    notifySuccess(responses.value.message);
                    let table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                }else{
                    Swal.fire("Server response",responses.value.message,"warning");
                }
            }
        })
    }

    function setINVOICESStatusPending(ledger){
        $.fn.modal.Constructor.prototype._enforceFocus = function() {};
        $(document).off('focusin.modal');
        Swal.fire({
            title: 'Submit access password',
            input: 'password',
            inputPlaceholder: "Enter password",
            inputAttributes: {
                autocapitalize: 'off'
            },
            showCancelButton: true,
            confirmButtonText: 'Pending',
            showLoaderOnConfirm: true,
            preConfirm: (login) => {
                return fetch(`<?php echo base_url('accounting/gl/index/setinvoicestatus')?>/${login}/${ledger}/Pending`)
                    .then(response => {
                        if (!response.ok) {
                            throw new Error(response.statusText)
                        }
                        return response.json()
                    })
                    .catch(error => {
                        Swal.showValidationMessage(
                            `Request failed: ${error}`
                        )
                    })
            },
            allowOutsideClick: () => !Swal.isLoading()
        }).then((responses) => {
            if (responses.value) {
                if(responses.value.status == true){
                    notifySuccess(responses.value.message);
                    let table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                }else{
                    Swal.fire("Server response",responses.value.message,"warning");
                }
            }
        })
    }

    function setINVOICESStatusRejected(ledger){
        $.fn.modal.Constructor.prototype._enforceFocus = function() {};
        $(document).off('focusin.modal');
        Swal.fire({
            title: 'Submit access password',
            input: 'password',
            inputPlaceholder: "Enter password",
            inputAttributes: {
                autocapitalize: 'off'
            },
            showCancelButton: true,
            confirmButtonText: 'Reject',
            showLoaderOnConfirm: true,
            preConfirm: (login) => {
                return fetch(`<?php echo base_url('accounting/gl/index/setinvoicestatus')?>/${login}/${ledger}/Rejected`)
                    .then(response => {
                        if (!response.ok) {
                            throw new Error(response.statusText)
                        }
                        return response.json()
                    })
                    .catch(error => {
                        Swal.showValidationMessage(
                            `Request failed: ${error}`
                        )
                    })
            },
            allowOutsideClick: () => !Swal.isLoading()
        }).then((responses) => {
            if (responses.value) {
                if(responses.value.status == true){
                    notifySuccess(responses.value.message);
                    let table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                }else{
                    Swal.fire("Server response",responses.value.message,"warning");
                }
            }
        })
    }

    function setINVOICESStatusDraft(ledger){
        let status = encodeURI("Draft");
        $.fn.modal.Constructor.prototype._enforceFocus = function() {};
        $(document).off('focusin.modal');
        Swal.fire({
            title: 'Submit access password',
            input: 'password',
            inputPlaceholder: "Enter password",
            inputAttributes: {
                autocapitalize: 'off'
            },
            showCancelButton: true,
            confirmButtonText: 'Set Draft',
            showLoaderOnConfirm: true,
            preConfirm: (login) => {
                return fetch(`<?php echo base_url('accounting/gl/index/setinvoicestatus')?>/${login}/${ledger}/${status}`)
                    .then(response => {
                        if (!response.ok) {
                            throw new Error(response.statusText)
                        }
                        return response.json()
                    })
                    .catch(error => {
                        Swal.showValidationMessage(
                            `Request failed: ${error}`
                        )
                    })
            },
            allowOutsideClick: () => !Swal.isLoading()
        }).then((responses) => {
            if (responses.value) {
                if(responses.value.status == true){
                    notifySuccess(responses.value.message);
                    let table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                }else{
                    Swal.fire("Server response",responses.value.message,"warning");
                }
            }
        })
    }

    function setJOURNALSStatusApproved(ledger){
        $.fn.modal.Constructor.prototype._enforceFocus = function() {};
        $(document).off('focusin.modal');
        Swal.fire({
            title: 'Submit access password',
            input: 'password',
            inputPlaceholder: "Enter password",
            inputAttributes: {
                autocapitalize: 'off'
            },
            showCancelButton: true,
            confirmButtonText: 'Approve',
            showLoaderOnConfirm: true,
            preConfirm: (login) => {
                return fetch(`<?php echo base_url('accounting/gl/index/setjournalstatus')?>/${login}/${ledger}/Approved`)
                    .then(response => {
                        if (!response.ok) {
                            throw new Error(response.statusText)
                        }
                        return response.json()
                    })
                    .catch(error => {
                        Swal.showValidationMessage(
                            `Request failed: ${error}`
                        )
                    })
            },
            allowOutsideClick: () => !Swal.isLoading()
        }).then((responses) => {
            if (responses.value) {
                if(responses.value.status == true){
                    notifySuccess(responses.value.message);
                    let table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                }else{
                    Swal.fire("Server response",responses.value.message,"warning");
                }
            }
        })
    }

    function setJOURNALSStatusPending(ledger){
        $.fn.modal.Constructor.prototype._enforceFocus = function() {};
        $(document).off('focusin.modal');
        Swal.fire({
            title: 'Submit access password',
            input: 'password',
            inputPlaceholder: "Enter password",
            inputAttributes: {
                autocapitalize: 'off'
            },
            showCancelButton: true,
            confirmButtonText: 'Pending',
            showLoaderOnConfirm: true,
            preConfirm: (login) => {
                return fetch(`<?php echo base_url('accounting/gl/index/setjournalstatus')?>/${login}/${ledger}/Pending`)
                    .then(response => {
                        if (!response.ok) {
                            throw new Error(response.statusText)
                        }
                        return response.json()
                    })
                    .catch(error => {
                        Swal.showValidationMessage(
                            `Request failed: ${error}`
                        )
                    })
            },
            allowOutsideClick: () => !Swal.isLoading()
        }).then((responses) => {
            if (responses.value) {
                if(responses.value.status == true){
                    notifySuccess(responses.value.message);
                    let table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                }else{
                    Swal.fire("Server response",responses.value.message,"warning");
                }
            }
        })
    }

    function setJOURNALSStatusRejected(ledger){
        $.fn.modal.Constructor.prototype._enforceFocus = function() {};
        $(document).off('focusin.modal');
        Swal.fire({
            title: 'Submit access password',
            input: 'password',
            inputPlaceholder: "Enter password",
            inputAttributes: {
                autocapitalize: 'off'
            },
            showCancelButton: true,
            confirmButtonText: 'Reject',
            showLoaderOnConfirm: true,
            preConfirm: (login) => {
                return fetch(`<?php echo base_url('accounting/gl/index/setjournalstatus')?>/${login}/${ledger}/Rejected`)
                    .then(response => {
                        if (!response.ok) {
                            throw new Error(response.statusText)
                        }
                        return response.json()
                    })
                    .catch(error => {
                        Swal.showValidationMessage(
                            `Request failed: ${error}`
                        )
                    })
            },
            allowOutsideClick: () => !Swal.isLoading()
        }).then((responses) => {
            if (responses.value) {
                if(responses.value.status == true){
                    notifySuccess(responses.value.message);
                    let table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                }else{
                    Swal.fire("Server response",responses.value.message,"warning");
                }
            }
        })
    }

    function setJOURNALSStatusDraft(ledger){
        let status = encodeURI("Draft");
        $.fn.modal.Constructor.prototype._enforceFocus = function() {};
        $(document).off('focusin.modal');
        Swal.fire({
            title: 'Submit access password',
            input: 'password',
            inputPlaceholder: "Enter password",
            inputAttributes: {
                autocapitalize: 'off'
            },
            showCancelButton: true,
            confirmButtonText: 'Pending Reject',
            showLoaderOnConfirm: true,
            preConfirm: (login) => {
                return fetch(`<?php echo base_url('accounting/gl/index/setjournalstatus')?>/${login}/${ledger}/${status}`)
                    .then(response => {
                        if (!response.ok) {
                            throw new Error(response.statusText)
                        }
                        return response.json()
                    })
                    .catch(error => {
                        Swal.showValidationMessage(
                            `Request failed: ${error}`
                        )
                    })
            },
            allowOutsideClick: () => !Swal.isLoading()
        }).then((responses) => {
            if (responses.value) {
                if(responses.value.status == true){
                    notifySuccess(responses.value.message);
                    let table = $.fn.dataTable.tables( { api: true } );
                    table.clear().draw();
                }else{
                    Swal.fire("Server response",responses.value.message,"warning");
                }
            }
        })
    }


    function deleteLedger(ledger){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#dc100b',
            cancelButtonColor: '#09ab04',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('accounting/gl/deleteledger')?>/' + ledger,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Deleting Record ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    function restoreLedger(ledger){
        Swal.fire({
            title: 'Are you sure?',
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Restore it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('accounting/gl/restoreledger')?>/' + ledger,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Restoring Record..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

    function deleteLedgerForever(ledger){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#dc100b',
            cancelButtonColor: '#09ab04',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('accounting/gl/deleteledgerforever')?>/' + ledger,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"warning",
                            message:"Deleting Record Permanently ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblockPage();
                        if( result.status == true){
                            notifySuccess(result.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        <?php if(ENVIRONMENT !== 'production'){?>
                        Swal.fire('Server Error!', xhr.statusText,'error');
                        <?php }?>
                    }
                });
            }
        })
    }

</script>
