

<div class="modal" id="edit-account" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-body" style="min-height: 100px;"> </div>
        </div>
    </div>
</div>
</div>

<script type="text/javascript">

    let LMDatatableAccounts = function() {
        var initTable = function() {
            // begin first table
            var table = $('#lm_table_accounts').DataTable({
                responsive: true,
                // Pagination settings
                dom: `<'row'<'col-sm-12'tr>>
    			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
                pageLength: 10,
                language: {
                    'lengthMenu': 'Display _MENU_',
                    buttons: {
                        selectAll: "Select all",
                        selectNone: "Select none"
                    },
                    "emptyTable": "No record found",
                },
                searchDelay: 500,
                serverSide: true,
                ajax: '<?php echo base_url( 'accounting/chatofaccounts/datasource');?>',
                columns: [
                    {data: 'account_number'},
                    {data: 'account_name'},
                    {data: 'type_name'},
                    {data: 'subtype_name'},
                    {data: 'account_details'},
                ],
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
    			<'row'<'col-sm-12'tr>>
    			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                buttons: [
                    {
                        text: 'Delete Seleted',
                        action: function ( e, dt, node, config ) {
                            deleteSelected( table);
                        }
                    },
                    'selectAll',
                    'selectNone',
                    'excelHtml5',
                    'pdfHtml5',
                ],
            });
        };

        return {
            //main function to initiate the module
            init: function() {
                initTable();
            },

        };

    }();

    jQuery(document).ready(function() {

        LMDatatableAccounts.init();

        $('#edit-account').on('show.bs.modal', function (event) {
            let modal = $(this);
            const body = modal.find('.modal-body');
            var button = $(event.relatedTarget)
            var account = button.data('key')
            addSpinner(body);
            body.load('<?php echo base_url('accounting/registers/editaccount/');?>' + account, function( response, status, xhr ) {
                if ( status == "error" ) {
                    <?php if(ENVIRONMENT !== 'production'){?>
                    swal.fire("","An error occurred "+response,"warning");
                    <?php }else{?>
                    swal.fire("","An error occurred","warning");
                    <?php }?>
                    modal.modal('toggle');
                    modal.hide();
                }
            });
        })

    });

    function deleteAccount(account){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url($auth_role.'/accounting/chatofaccounts/deleteaccount')?>/'+account,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.block("#lm_table_accounts",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Deleting account ..."
                        });
                    },
                    success: function(result){
                        KTApp.unblock('#lm_table_accounts');
                        if( result.status == true){
                            notifySuccess(obj.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            Swal.fire('',result.message,'warning');
                        }
                        reloadAccounts();
                    },
                    error: function(xhr){
                        KTApp.unblock('#lm_table_accounts');
                        Swal.fire('',xhr.statusText,'warning');
                    }
                });
            }
        })
    }


    function modify(account){
        let $modal =  $('div#accountDetails');
        let $div = $modal.find('.modal-body');
        $div.html('');
        $modal.modal('show');
        $.ajax({
            url: '<?php echo base_url($auth_role.'/accounting/index/modify/');?>' + account,
            type: 'get',
            beforeSend: function(){
                KTApp.block($div,{
                    overlayColor:"#000000",
                    type:"loader",
                    state:"success",
                    message:"Loading account details ...."
                });
            },
            success: function (result){
                $div.html(result);
                KTApp.unblock($div);
            },
            error: function (xhr){
                $modal.modal('hide');
                KTApp.unblock($div);
                Swal.fire('',xhr.statusText,'warning');
            }
        })
    }

    function deleteSelected(table){
        if(table.rows('.selected').data().length<1)
            return;
        var data= [];
        $.each(table.rows('.selected').data(), function() {
            data.push(this["account_id"]);
        });
        Swal.fire({
            title: 'Are you sure?',
            text: "You are going to DELETE " + table.rows('.selected').data().length + " accounts",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Delete them!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url($auth_role.'/accounting/index/deleteselected/');?>',
                    type: 'get',
                    data: {'data':data},
                    beforeSend: function(){
                        KTApp.blockPage({
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Please wait ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            notifySuccess(obj.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.clear().draw();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                        KTApp.unblockPage();
                    },
                    error: function(xhr){
                        KTApp.unblockPage();
                        Swal.fire('',xhr.statusText,'warning');
                    }
                });
            }
        })
    }

</script>
