<h5>Asset details</h5>
<div>
    <?php
    if (!empty($status['flag']) && $status == TRUE):?>
        <div style="width:100%;"
             class="m-alert m-alert--outline m-alert--square alert <?php echo $status['class']; ?> alert-dismissible fade show">
            <?php echo $status['message']; ?>
        </div>
    <?php endif;
    echo form_open('#', ['method' => 'post', 'id' => 'formUpdate']); ?>
    <input type="hidden" name="asset_key" value="<?php echo $asset->asset_key; ?>">
    <div class="row">
        <div class="col-md-4">
            <div class="form-group ">
                <label class="pull-right col-form-label">
                    Asset Serial
                </label>
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group ">
                <input type="text" required value="<?php echo $asset->asset_serial; ?>"
                       class="form-control m-input m-input--square" name="asset_serial">
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-4">
            <div class="form-group ">
                <label class="pull-right col-form-label"> Asset Type </label>
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group">
                <select name="asset_type" class="form-control" id="assetTypes" required>
                    <option value="" disabled selected>Select Type</option>
                    <?php if (!empty($types)) {
                        foreach ($types as $i => $typ) { ?>
                            <option <?php if ($asset->asset_type == $typ['asset_type_key']) echo 'selected'; ?>
                                    value="<?php echo $typ['asset_type_key']; ?>">
                                <?php echo $typ['asset_type_name']; ?>
                            </option>;
                        <?php }
                    } ?>
                </select>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-4">
            <div class="form-group ">
                <label class="pull-right col-form-label">Evaluation Date: </label>
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group ">
                <input type="date" required value="<?php echo $asset->asset_evaluation_date; ?>"
                       class="form-control m-input m-input--square" name="asset_evaluation_date">
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-4">
            <div class="form-group ">
                <label class="pull-right col-form-label">Depreciation rate% (/year)</label>
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group ">
                <input type="text" id="asset_valuation_value"
                       value="<?php echo $asset->asset_evaluation_value; ?>"
                       class="form-control m-input m-input--square number" name="asset_evaluation_value" readonly>
                <span><i class="flaticon-warning"></i> To edit this, go to asset types or <a href="<?= base_url('assets/assettypes')?>" style="text-decoration: underline;">Click here</a></span>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-4">
            <div class="form-group ">
                <label class="pull-right col-form-label">Life-time (years)</label>
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group ">
                <input type="text" class="form-control m-input m-input--square number" value="<?php echo $asset->asset_lifetime; ?>"
                       name="asset_lifetime" id="asset_lifetime">
            </div>
        </div>
    </div>
    <!--<div class="alert alert-outline-danger fade show" role="alert">
        <div class="alert-text">
            Do not change unless you know what you are doing
            <hr/>
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label class="pull-right col-form-label">Withdraw form Account </label>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <select name="asset_withdraw_account" class="form-control" id="accounts" required>
                            <//?php if (!empty($accounts)) {
                                foreach ($accounts as $y => $account) { ?>
                                    <option <//?php if ($account['account_id'] == $asset->asset_withdraw_account) echo 'selected'; ?>
                                            value="<//?php echo $account['account_id']; ?>"><//?php echo $account['account_name']; ?></option>';
                                <//?php }
                            } ?>
                        </select>
                    </div>
                </div>
            </div>
        </div>
    </div>-->
    <div class="alert alert-light alert-elevate fade show" role="alert">
        <div class="alert-icon"><i class="flaticon-warning"></i></div>
        <div class="alert-text">The below is only valid for tangible (physical) assets like equipment, furniture,
            computers, and vehicles
        </div>
    </div>
    <div class="row">
        <div class="col-md-4">
            <div class="form-group ">
                <label class="pull-right col-form-label">Asset Cost </label>
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group ">
                <input type="text" required value="<?php echo number_format(to_money($asset->asset_cost)); ?>"
                       class="number form-control m-input m-input--square" name="asset_cost">
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-4">
            <div class="form-group">
                <label class="pull-right col-form-label"> Depreciation Value/Month
                </label>
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group ">
                <input type="text" required value="<?php echo number_format(to_money($asset->asset_monthly_dep)); ?>"
                       class="number form-control m-input m-input--square" name="asset_monthly_dep">
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-4">
            <div class="form-group">
                <label class="pull-right col-form-label">Bought from </label>
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group">
                <input type="text" required value="<?php echo $asset->asset_bougth_from; ?>"
                       class="form-control m-input m-input--square" name="asset_bougth_from">
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-4">
            <div class="form-group">
                <label class="pull-right col-form-label">Asset Description <b>optional</b></label>
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group">
                <textarea class="form-control" name="asset_description" id="asset_description"
                          style="width:100%;"><?php echo $asset->asset_description; ?></textarea>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
        </div>
        <div class="col-md-4">
            <button type="submit" class="btn btn-brand btn-block text-uppercase">Save Change</button>
        </div>
    </div>
    <?php echo form_close(); ?>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        $('#assetTypes').change(function() {
            var asset_key = $(this).val();
            //alert(asset_key);
            $.ajax({
                url: '<?php echo base_url()."/accounting/assets/fetch_asset_type/"; ?>'+ asset_key,
                type: 'POST',
                data: {asset_key : asset_key},
                dataType: 'json',
                success: function(result) {
                    //alert('done');
                    $('#asset_valuation_value').val(result.asset_type_value);
                    $('#asset_description').val(result.asset_type_description);
                    //$('#asset_account').val(result.asset_type_account);
                },
                error: function(){
                    alert('Failed to populate data')
                }
            });
        });
    });
</script>
<script type="text/javascript">
    $(function () {
        $('form#formUpdate').submit(function (event) {
            let form = $(this);
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url($auth_role . '/assets/updateassetdetails')?>',
                type: 'post',
                data: formdata,
                beforeSend: function () {
                    KTApp.block(form, {
                        overlayColor: "#000000",
                        type: "loader",
                        state: "success",
                        message: "Updating asset ...."
                    });
                },
                success: function (r) {
                    var obj = JSON.parse(r);
                    if (obj.status == 'ok') {
                        notifySuccess(obj.message);
                    } else {
                        Swal.fire('', obj.message, 'warning');
                    }
                    KTApp.unblock(form);
                },
                error: function () {
                    KTApp.unblock(form);
                }
            });
        })

        $('select').select2({placeholder: 'Select Option'});

    })

</script>
