<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<div class="kt-todo__bottom" id="kt_page_portlet">
    <form id="docsForm" onsubmit="return false;" class="kt-form kt-form--label-right">
        <div class="kt-portlet__body">
            <div class="form-group row">
                <div class="col-lg-12">
                    <label class="">Upload File:</label>
                    <div class="m-dropzone dropzone m-dropzone--primary dz-clickable"  id="crop-image">
                        <div class="m-dropzone__msg dz-message needsclick">
                            <h3 class="m-dropzone__msg-title">Drop files here or click to upload.</h3>
                            <span class="m-dropzone__msg-desc">Upload 1 files</span>
                        </div>
                    </div>
                </div>
                <input type="hidden" class="form-control" id="uploadedfiles" name="uploadedfiles" />
            </div>
            <div class="form-group row">
                <input type="text" hidden class="form-control" name="asset_doc_asset_key" value="<?php echo $asset->asset_key; ?>" placeholder="Enter description">
                <div class="col-lg-6">
                    <label>Document Title:</label>
                    <input type="text" class="form-control" name="asset_doc_title" placeholder="Enter title">
                </div>
                <div class="col-lg-6">
                    <label>Description:</label>
                    <input type="text" class="form-control" name="asset_doc_desc" placeholder="Enter description">
                </div>

            </div>
            <div class="row">
                <div class="col-lg-6">
                </div>
                <div class="col-lg-6 kt-align-right">
                    <button type="submit" name="submit" class="btn btn-success">Save</button>
                </div>
            </div>
        </div>

    </form>
    <!--Begin::Section-->
    <div class="row" hidden>
        <?php if(!empty($document)):
            foreach($document as $hero):?>
                <div class="col-xl-3 col-lg-6 col-md-6" id='<?php echo $hero['asset_doc_key'];?>'>

                    <!--Begin::Portlet-->
                    <div class="kt-portlet">
                        <div class="kt-portlet__head kt-portlet__head--noborder">
                            <div class="kt-portlet__head-label">
                                <h3 class="kt-portlet__head-title">
                                </h3>
                            </div>
                            <div class="kt-portlet__head-toolbar">
                                <a href="#" class="btn btn-clean btn-sm btn-icon btn-icon-md" data-toggle="dropdown">
                                    <i class="flaticon-more-1"></i>
                                </a>
                                <div class="dropdown-menu dropdown-menu-right">
                                    <ul class="kt-nav">
                                        <li class="kt-nav__item">
                                            <a href="javascript:(0);" onclick="deleteDocument('<?php echo $hero['asset_doc_key'];?>')" class="kt-nav__link">
                                                <i class="kt-nav__link-icon flaticon2-trash"></i>
                                                <span class="kt-nav__link-text">Delete</span>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="kt-portlet__body">
                            <!--begin::Widget -->
                            <div class="kt-widget__files">
                                <div class="kt-widget__media">
                                    <img class="kt-widget__img kt-hidden-" src="<?php echo base_url('resources/');?>assets/media/files/<?php echo getFileExt($hero['asset_doc_image']);?>.svg" alt="">
                                </div>

                                <a target="_blank" href="<?php echo uploadFilePath('asset_doc_image/').$hero['asset_doc_image'];?>"  data-url="<?php echo uploadFilePath('asset_doc_image/').$hero['asset_doc_image'];?>" class="kt-widget__desc">
                                    <?php echo $hero['asset_doc_title'];?>
                                </a>
                            </div>

                            <!--end::Widget -->
                        </div>
                    </div>

                    <!--End::Portlet-->
                </div>
            <?php endforeach; endif;?>

    </div>

    <table class="table table-bordered table-hover table-checkable" id="lm_table_document">
        <thead>
        <tr>
            <th>Document Title</th>
            <th>Document Type</th>
            <th>Date Uploaded</th>
            <th>Action</th>
        </tr>
        </thead>
    </table>
    <!--End::Section-->
</div>

<div class="modal fade" id="previewPdf" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content bg-dark">
            <div class="modal-body" id="modalview" style="height:100%; min-height">
            </div>
            <div class="modal-footer">
                <button type="button" data-dismiss="modal" class="btn btn-danger" name="button"><i class="flaticon-cancel"></i></button>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    $('form#docsForm').submit(function (event) {
        let form = $(this);
        let $div = $('div#kt_page_portlet');
        event.preventDefault();
        let formdata = form.serialize();
        $.ajax({
            url: '<?php echo base_url('accounting/assets/newDocument/')?>',
            type: 'get',
            data: formdata,
            beforeSend: function () {
                KTApp.block($div, {
                    overlayColor: "#000000",
                    type: "loader",
                    state: "success",
                    message: "Uploading Asset document ...."
                });
            },
            success: function (r) {
                var obj = JSON.parse(r);
                if (obj.status == 'ok') {
                    $div.load("<?php echo base_url('accounting/assets/loadassetdocuments/' . $asset->asset_key);?>");
                    Swal.fire('', obj.message, 'success');
                } else {
                    Swal.fire('', obj.message, 'warning');
                }
                KTApp.unblock($div);
            },
            error: function () {
                Swal.fire('', obj.message, 'success');
                KTApp.unblock($div);
            }
        });
    })

    Dropzone.autoDiscover = false;
    var options = {
        url: "<?php echo base_url('accounting/assets/uploadempdocs');?>",
        paramName: "file", // The name that will be used to transfer the file
        maxFiles: 10,
        maxFilesize: 3, // MB
        success: function(file, response){
            let oldValue = $('input#uploadedfiles').val();
            if(oldValue.length > 0){
                oldValue = oldValue + 'LM-55';
            }
            let newValue =  oldValue + response.files;
            $('input#uploadedfiles').val(newValue);
        },
    };
    var expsenseDocs = new Dropzone("div#crop-image",options);

    //== Class definition
    $.fn.dataTable.Api.register('column().title()', function() {
        return $(this.header()).text().trim();
    });

    var Datatable = function() {
        var initTable = function() {
            var events = $('#lm_table_document');
            // begin first table
            events.DataTable({
                responsive: true,
                buttons: [
                    'print',
                    'copyHtml5',
                    'excelHtml5',
                    'csvHtml5',
                    'pdfHtml5',
                ],
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
			<'row'<'col-sm-12'tr>>
			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                searchDelay: 500,
                processing: true,
                serverSide: false,
                ajax: '<?php echo base_url('accounting/assets/datasourceDocuments/'.$asset->asset_key);?>',
                columns: [
                    {data: 'asset_doc_title'},
                    {data: 'asset_doc_type'},
                    {data: 'asset_doc_date_created'},
                    {data: 'action'},
                ],
                initComplete: function() {
                    this.api().columns().every(function() {
                        var column = this;

                        switch (column.title()) {
                            case 'Status':
                                column.data().unique().sort().each(function(d, j) {
                                    $('.kt-input[data-col-index="6"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'Region':
                                column.data().unique().sort().each(function(d, j) {
                                    $('.kt-input[data-col-index="4"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                            case 'District':
                                column.data().unique().sort().each(function(d, j) {
                                    $('.kt-input[data-col-index="5"]').append('<option value="' + d + '">' + d + '</option>');
                                });
                                break;
                        }
                    });
                },
                columnDefs: [
                    {
                        targets: 0,
                        render: function(data, type, full, meta) {
                            return (data);
                        }
                    },
                    {
                        targets: 1,
                        render: function(data, type, full, meta) {
                            return '<a href="<?php echo uploadFilePath('asset_doc_image/');?>' + full.asset_doc_image + '" ><img style="width: 100px; height: 50px;" src="<?php echo base_url('resources/assets/media/files/');?>' + full.asset_doc_type + '.svg" alt=""></a>';
                        }
                    },
                    {
                        targets: 3,
                        render: function(data, type, full, meta){
                            return ' <a href="javascript:deleteDocument(' + full.asset_doc_key + ');"><i class="flaticon-delete text-danger"></i></a> | <a href="<?php echo uploadFilePath('asset_doc_image/');?>' + full.asset_doc_image + '" ><i class="fa fa-download"></i>Download</a>';
                        }
                    }

                ],
            });

            var filter = function() {
                var val = $.fn.dataTable.util.escapeRegex($(this).val());
                let table = $.fn.dataTable.tables( { api: true } );
                table.column($(this).data('col-index')).search(val ? val : '', false, false).draw();
            };

            var asdasd = function(value, index) {
                let table = $.fn.dataTable.tables( { api: true } );
                var val = $.fn.dataTable.util.escapeRegex(value);
                table.column(index).search(val ? val : '', false, true);
            };

            $('#m_search').on('click', function(e) {
                e.preventDefault();
                let table = $.fn.dataTable.tables( { api: true } );
                var params = {};
                $('.kt-input').each(function() {
                    var i = $(this).data('col-index');
                    if (params[i]) {
                        params[i] += '|' + $(this).val();
                    }
                    else {
                        params[i] = $(this).val();
                    }
                });
                $.each(params, function(i, val) {
                    // apply search params to datatable
                    table.column(i).search(val ? val : '', false, false);
                });
                table.table().draw();
            });

            $('#m_reset').on('click', function(e) {
                e.preventDefault();
                let table = $.fn.dataTable.tables( { api: true } );
                $('.kt-input').each(function() {
                    $(this).val('');
                    table.column($(this).data('col-index')).search('', false, false);
                });
                table.ajax.reload();
            });

        };

        return {
            //main function to initiate the module
            init: function() {
                initTable();
            },

        };

    }();

    jQuery(document).ready(function() {
        Datatable.init();
    });

    function deleteDocument(docKey){
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('accounting/assets/deleteDocument/document')?>/'+docKey,
                    type: 'get',
                    beforeSend: function(){
                        KTApp.block("div#details",{
                            overlayColor:"#000000",
                            type:"loader",
                            state:"danger",
                            message:"Deleting document ..."
                        });
                    },
                    success: function(result){
                        let obj = JSON.parse(result);
                        if( obj.status == 'ok'){
                            notifySuccess(obj.message);
                            var table = $.fn.dataTable.tables( { api: true } );
                            if(table != undefined){
                                table.ajax.reload();
                            }
                            $('div#' + docKey).hide();
                        }else{
                            Swal.fire('',obj.message,'warning');
                        }
                    },
                    error: function(xhr){
                        KTApp.unblock('div#details');
                        Swal.fire('',xhr.statusText,'warning');
                    }
                });
            }
        })
    }
</script>
