<?php
defined('BASEPATH') OR exit('No direct script access allowed'); ?>
    <div class="kt-todo__bottom" id="kt_page_portlet">
        <h5>Asset Appreciation</h5>

        <table class="table table-bordered table-hover table-checkable" id="lm_table_appreciation">
            <thead>
            <tr>
                <th>Month</th>
                <th>Asset serial No</th>
                <th>Origin Value</th>
                <th>Current Value</th>
                <th>Action</th>
            </tr>
            </thead>
        </table>
        <!--End::Section-->
    </div>

    <div class="modal fade" id="previewPdf" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content bg-dark">
                <div class="modal-body" id="modalview" style="height:100%; min-height">
                </div>
                <div class="modal-footer">
                    <button type="button" data-dismiss="modal" class="btn btn-danger" name="button"><i class="flaticon-cancel"></i></button>
                </div>
            </div>
        </div>
    </div>

    <script type="text/javascript">

        //== Class definition
        $.fn.dataTable.Api.register('column().title()', function() {
            return $(this.header()).text().trim();
        });

        var Datatable = function() {
            var initTable = function() {
                var events = $('#lm_table_appreciation1');
                // begin first table
                events.DataTable({
                    responsive: true,
                    buttons: [
                        'print',
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        'pdfHtml5',
                    ],
                    dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
			<'row'<'col-sm-12'tr>>
			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                    searchDelay: 500,
                    processing: true,
                    serverSide: false,
                    ajax: '<?php echo base_url('accounting/assets/datasourceDocuments/'.$asset->asset_key);?>',
                    columns: [
                        {data: 'asset_doc_title'},
                        {data: 'asset_doc_type'},
                        {data: 'asset_doc_date_created'},
                        {data: 'action'},
                    ],
                    initComplete: function() {
                        this.api().columns().every(function() {
                            var column = this;

                            switch (column.title()) {
                                case 'Status':
                                    column.data().unique().sort().each(function(d, j) {
                                        $('.kt-input[data-col-index="6"]').append('<option value="' + d + '">' + d + '</option>');
                                    });
                                    break;
                                case 'Region':
                                    column.data().unique().sort().each(function(d, j) {
                                        $('.kt-input[data-col-index="4"]').append('<option value="' + d + '">' + d + '</option>');
                                    });
                                    break;
                                case 'District':
                                    column.data().unique().sort().each(function(d, j) {
                                        $('.kt-input[data-col-index="5"]').append('<option value="' + d + '">' + d + '</option>');
                                    });
                                    break;
                            }
                        });
                    },
                    columnDefs: [
                        {
                            targets: 0,
                            render: function(data, type, full, meta) {
                                return (data);
                            }
                        },
                        {
                            targets: 1,
                            render: function(data, type, full, meta) {
                                return '<a href="<?php echo uploadFilePath('asset_doc_image/');?>' + full.asset_doc_image + '" ><img style="width: 100px; height: 50px;" src="<?php echo base_url('resources/assets/media/files/');?>' + full.asset_doc_type + '.svg" alt=""></a>';
                            }
                        },
                        {
                            targets: 3,
                            render: function(data, type, full, meta){
                                return ' <a href="javascript:deleteDocument(' + full.asset_doc_key + ');"><i class="flaticon-delete text-danger"></i></a> | <a href="<?php echo uploadFilePath('asset_doc_image/');?>' + full.asset_doc_image + '" ><i class="fa fa-download"></i>Download</a>';
                            }
                        }

                    ],
                });

                var filter = function() {
                    var val = $.fn.dataTable.util.escapeRegex($(this).val());
                    let table = $.fn.dataTable.tables( { api: true } );
                    table.column($(this).data('col-index')).search(val ? val : '', false, false).draw();
                };

                var asdasd = function(value, index) {
                    let table = $.fn.dataTable.tables( { api: true } );
                    var val = $.fn.dataTable.util.escapeRegex(value);
                    table.column(index).search(val ? val : '', false, true);
                };

                $('#m_search').on('click', function(e) {
                    e.preventDefault();
                    let table = $.fn.dataTable.tables( { api: true } );
                    var params = {};
                    $('.kt-input').each(function() {
                        var i = $(this).data('col-index');
                        if (params[i]) {
                            params[i] += '|' + $(this).val();
                        }
                        else {
                            params[i] = $(this).val();
                        }
                    });
                    $.each(params, function(i, val) {
                        // apply search params to datatable
                        table.column(i).search(val ? val : '', false, false);
                    });
                    table.table().draw();
                });

                $('#m_reset').on('click', function(e) {
                    e.preventDefault();
                    let table = $.fn.dataTable.tables( { api: true } );
                    $('.kt-input').each(function() {
                        $(this).val('');
                        table.column($(this).data('col-index')).search('', false, false);
                    });
                    table.ajax.reload();
                });

            };

            return {
                //main function to initiate the module
                init: function() {
                    initTable();
                },

            };

        }();

        jQuery(document).ready(function() {
            Datatable.init();
        });

        function deleteDocument(docKey){
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.value) {
                    $.ajax({
                        url: '<?php echo base_url('accounting/assets/deleteDocument/document')?>/'+docKey,
                        type: 'get',
                        beforeSend: function(){
                            KTApp.block("div#details",{
                                overlayColor:"#000000",
                                type:"loader",
                                state:"danger",
                                message:"Deleting document ..."
                            });
                        },
                        success: function(result){
                            let obj = JSON.parse(result);
                            if( obj.status == 'ok'){
                                notifySuccess(obj.message);
                                var table = $.fn.dataTable.tables( { api: true } );
                                if(table != undefined){
                                    table.ajax.reload();
                                }
                                $('div#' + docKey).hide();
                            }else{
                                Swal.fire('',obj.message,'warning');
                            }
                        },
                        error: function(xhr){
                            KTApp.unblock('div#details');
                            Swal.fire('',xhr.statusText,'warning');
                        }
                    });
                }
            })
        }
    </script>
<?php
