<script type="text/javascript">
    var LMDatatableAssets = function () {
        var initTable = function () {
            // begin first table
            var table = $('#depreciating-assets-table').DataTable({
                responsive: true,
                // Pagination settings
                dom: `<'row'<'col-sm-12'tr>>
    			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
                pageLength: 10,
                language: {
                    'lengthMenu': 'Display _MENU_',
                    buttons: {
                        selectAll: "Select all",
                        selectNone: "Select none"
                    },
                    "emptyTable": "No record found",
                },
                searchDelay: 500,
                processing: true,
                serverSide: true,
                select: false,
                "ajax": "<?php echo base_url('accounting/assets/datasource');?>",
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
    			<'row'<'col-sm-12'tr>>
    			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                buttons: [
                    {
                        text: 'Delete Seleted',
                        action: function (e, dt, node, config) {
                            deleteSelected(table);
                        }
                    },
                    {
                        text: 'Depreciate Seleted',
                        action: function (e, dt, node, config) {
                            depreciateSelected(table);
                        }
                    },
                    'selectAll',
                    'selectNone',
                    //'excelHtml5',
                    //'pdfHtml5',
                ],
                columns: [
                    {data: 'asset_serial'},
                    {data: 'asset_type_name'},
                    {data: 'asset_total_cost'},
                    {data: 'asset_date'},
                    {data: 'fp_prefix'},
                    {data: 'asset_annual_dep'},
                    {data: 'asset_dep_price_difference'},
                    {data: 'asset_dep_status'},
                ],
                columnDefs: [
                    {
                        targets: 0,
                        render: function (data, type, full, meta) {
                            return '<a href="<?php echo base_url('accounting/assets/details/');?>' + full.asset_key + '">' + ucfirst(data) + '</a>';
                        }
                    },
                    {
                        targets: 1,
                        render: function (data, type, full, meta) {
                            return ucfirst(data);
                        }
                    },
                    {
                        targets: 2,
                        render: function (data, type, full, meta) {
                            return KTUtil.numberString(to_money(data));
                        }
                    },
                    {
                        targets: 4,
                        render: function (data, type, full, meta) {
                            if(full.fp_prefix === null){
                                return 'NOT YET';
                            }else{
                                return full.fp_prefix;
                            }
                        }
                    },
                    {
                        targets: 5,
                        render: function (data, type, full, meta) {
                            return KTUtil.numberString(to_money(full.asset_annual_dep));
                        }
                    },
                    {
                        targets: 6,
                        render: function (data, type, full, meta) {
                            return KTUtil.numberString(to_money(data));
                        }
                    },
                    {
                        targets: 7,
                        "width":"15%",
                        render: function (data, type, full, meta) {
                            var status = {
                                "Approved": {'asset_dep_status': 'Approved', 'class': 'kt-badge--success'},
                                "Depreciated": {'asset_dep_status': 'Depreciated', 'class': 'kt-badge--success'},
                                "Pending": {'asset_dep_status': 'Pending', 'class': ' kt-badge--warning'},
                            };
                            if (typeof status[data] === 'undefined') {
                                return data;
                            }
                            if(full.asset_dep_status === "Pending"){
                                return '<a href="javascript:deleteItem(' + full.asset_key + ');"><i class="flaticon-delete text-danger"></i></a>' +
                                    '<a href="<?php echo base_url('assets/modify/');?>' + full.asset_key + '"><i class="flaticon-edit text-success"></i></a>' +
                                    '<a href="javascript:runDep('+ full.asset_dep_key + ');"><span class="kt-badge ' + status[data].class + ' kt-badge--inline">Run Depreciation</span></a>';
                            }
                            else{
                                if(full.asset_dep_status === "Depreciated"){
                                    return '<a href="javascript:deleteItem(' + full.asset_key + ');"><i class="flaticon-delete text-danger"></i></a> <a href="javascript:(0);"><span class="kt-badge ' + status[data].class + ' kt-badge--inline">Depreciated</span></a>';
                                }
                            }
                        }
                    },
                ],
            });
            var tableApp = $('#appreciating-assets-table').DataTable({
                responsive: true,
                // Pagination settings
                dom: `<'row'<'col-sm-12'tr>>
    			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
                pageLength: 10,
                language: {
                    'lengthMenu': 'Display _MENU_',
                    buttons: {
                        selectAll: "Select all",
                        selectNone: "Select none"
                    },
                    "emptyTable": "No record found",
                },
                searchDelay: 500,
                processing: true,
                serverSide: true,
                select: false,
                "ajax": "<?php echo base_url('accounting/assets/datasource_appreciating');?>",
                dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
    			<'row'<'col-sm-12'tr>>
    			<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                buttons: [
                    {
                        text: 'Delete Seleted',
                        action: function (e, dt, node, config) {
                            deleteSelectedApp(tableApp);
                        }
                    },
                    // {
                    //     text: 'Appreciate Seleted',
                    //     action: function (e, dt, node, config) {
                    //         appreciateSelected(tableApp);
                    //     }
                    // },
                    'selectAll',
                    'selectNone',
                    //'excelHtml5',
                    //'pdfHtml5',
                ],
                columns: [
                    {data: 'asset_serial'},
                    {data: 'asset_type_name'},
                    {data: 'asset_total_cost'},
                    {data: 'asset_date'},
                    //{data: 'fp_prefix'},
                    //{data: 'asset_annual_app'},
                    //{data: 'asset_app_price_difference'},
                    {data: 'asset_app_status'},
                ],
                columnDefs: [
                    {
                        targets: 0,
                        render: function (data, type, full, meta) {
                            return '<a href="<?php echo base_url('accounting/assets/details/');?>' + full.asset_key + '">' + ucfirst(data) + '</a>';
                        }
                    },
                    {
                        targets: 1,
                        render: function (data, type, full, meta) {
                            return ucfirst(data);
                        }
                    },
                    {
                        targets: 2,
                        render: function (data, type, full, meta) {
                            return KTUtil.numberString(to_money(data));
                        }
                    },
                    // {
                    //     targets: 4,
                    //     render: function (data, type, full, meta) {
                    //         if(full.fp_prefix === null){
                    //             return 'NOT YET';
                    //         }else{
                    //             return full.fp_prefix;
                    //         }
                    //     }
                    // },
                    // {
                    //     targets: 5,
                    //     render: function (data, type, full, meta) {
                    //         return KTUtil.numberString(to_money(full.asset_annual_app));
                    //     }
                    // },
                    // {
                    //     targets: 6,
                    //     render: function (data, type, full, meta) {
                    //         return KTUtil.numberString(to_money(data));
                    //     }
                    // },
                    {
                        targets: 4,
                        "width":"15%",
                        render: function (data, type, full, meta) {
                            return '<a href="#appreciation" data-key="' + full.asset_key + '" data-toggle="modal" data-backdrop="false"><span class="kt-badge kt-badge--success kt-badge--inline">Appreciate</span></a>';
                        }
                    },
                ],
            });
        };

        return {
            //main function to initiate the module
            init: function () {
                initTable();
            },

        };

    }();

    jQuery(document).ready(function () {
        //$('select').css('width', '100%');
        $('select').select2({placeholder: 'select option'});
        let height = $(window).innerHeight() - 250;
        $('.lm_max_height').css({height: height});
        $(window).resize(function () {
            $('.lm_max_height').css({height: height});
        });
        LMDatatableAssets.init();

        $('form#formUpdate').submit(function (event) {
            let form = $(this);
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url('accounting/assets/updateassetdetails')?>',
                type: 'post',
                data: formdata,
                beforeSend: function () {
                    KTApp.block(form, {
                        overlayColor: "#000000",
                        type: "loader",
                        state: "success",
                        message: "Updating asset ...."
                    });
                },
                success: function (r) {
                    var obj = JSON.parse(r);
                    if (obj.status == 'ok') {
                        notifySuccess(obj.message);
                    } else {
                        Swal.fire('', obj.message, 'warning');
                    }
                    KTApp.unblock(form);
                },
                error: function () {
                    KTApp.unblock(form);
                }
            });
        })

        $('form#newAccountForm').submit(function (event) {
            let form = $(this);
            event.preventDefault();
            let formdata = form.serialize();
            $.ajax({
                url: '<?php echo base_url('accounting/assets/newaccount/')?>',
                type: 'get',
                data: formdata,
                beforeSend: function () {
                    KTApp.block("form#newAccountForm", {
                        overlayColor: "#000000",
                        type: "loader",
                        state: "success",
                        message: "creating new Account ...."
                    });
                },
                success: function (r) {
                    var obj = JSON.parse(r);
                    if (obj.status == 'ok') {
                        notifySuccess(obj.message);
                        var table = $.fn.dataTable.tables({api: true});
                        table.clear().draw();
                    } else {
                        Swal.fire('', obj.message, 'warning');
                    }
                    $('div#newAccount').modal('hide');
                    KTApp.unblock('form#newAccountForm');
                },
                error: function () {
                    KTApp.unblock('form#newAccountForm');
                    $('div#newAccount').modal('hide');
                }
            });
        })

        $('#appreciation').on('show.bs.modal', function (event) {
            var modal = $(this)
            modal.find('.modal-body').html('Loading data, please wait ...');
            var button = $(event.relatedTarget)
            var key = button.data('key')
            //alert(key);
            modal.find('.modal-body').load('<?php echo base_url('accounting/assets/load_appreciation_calculator/');?>' + key );
        })

    });

    function deleteItem(asset) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'question',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('accounting/assets/deleteAsset')?>/' + asset,
                    type: 'get',
                    beforeSend: function () {
                        KTApp.blockPage({
                            overlayColor: "#000000",
                            type: "loader",
                            state: "danger",
                            message: "Deleting Asset ..."
                        });
                    },
                    success: function (result) {
                        KTApp.unblockPage();
                        let obj = JSON.parse(result);
                        if (obj.status == 'ok') {
                            notifySuccess(obj.message);
                            var table = $.fn.dataTable.tables({api: true});
                            table.ajax.reload();
                        } else {
                            KTApp.unblockPage();
                            Swal.fire('', obj.message, 'warning');
                        }
                    },
                    error: function (xhr) {
                        KTApp.unblockPage();
                        Swal.fire('', xhr.statusText, 'warning');
                    }
                });
            }
        })
    }
    function deleteItemApp(asset) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            type: 'question',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('accounting/assets/deleteAssetApp')?>/' + asset,
                    type: 'get',
                    beforeSend: function () {
                        KTApp.blockPage({
                            overlayColor: "#000000",
                            type: "loader",
                            state: "danger",
                            message: "Deleting Asset ..."
                        });
                    },
                    success: function (result) {
                        KTApp.unblockPage();
                        let obj = JSON.parse(result);
                        if (obj.status == 'ok') {
                            notifySuccess(obj.message);
                            var table = $.fn.dataTable.tables({api: true});
                            table.ajax.reload();
                        } else {
                            KTApp.unblockPage();
                            Swal.fire('', obj.message, 'warning');
                        }
                    },
                    error: function (xhr) {
                        KTApp.unblockPage();
                        Swal.fire('', xhr.statusText, 'warning');
                    }
                });
            }
        })
    }
    function deleteSelected(table) {
        if (table.rows('.selected').data().length < 1)
            return;
        var data = [];
        $.each(table.rows('.selected').data(), function () {
            data.push(this["asset_key"]);
        });
        Swal.fire({
            title: 'Are you sure?',
            text: "You are going to DELETE " + table.rows('.selected').data().length + " assets",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Delete them!'
        }).then((result) => {
            //alert(data);
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('accounting/assets/deleteSelected/');?>',
                    type: 'get',
                    data: {'data': data},
                    beforeSend: function () {
                        KTApp.blockPage({
                            overlayColor: "#000000",
                            type: "loader",
                            state: "danger",
                            message: "Please wait ..."
                        });
                    },
                    success: function (result) {
                        let obj = JSON.parse(result);
                        if (obj.status == 'ok') {
                            notifySuccess(obj.message);
                            var table = $.fn.dataTable.tables({api: true});
                            table.ajax.reload();
                        } else {
                            Swal.fire('', obj.message, 'warning');
                        }
                        KTApp.unblockPage();
                    },
                    error: function (xhr) {
                        KTApp.unblockPage();
                        Swal.fire('', xhr.statusText, 'warning');
                    }
                });
            }
        })
    }
    function deleteSelectedApp(table) {
        if (table.rows('.selected').data().length < 1)
            return;
        var data = [];
        $.each(table.rows('.selected').data(), function () {
            data.push(this["asset_key"]);
        });
        Swal.fire({
            title: 'Are you sure?',
            text: "You are going to DELETE " + table.rows('.selected').data().length + " assets",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Delete them!'
        }).then((result) => {
            //alert(data);
            if (result.value) {
                $.ajax({
                    url: '<?php echo base_url('accounting/assets/deleteSelectedApp/');?>',
                    type: 'get',
                    data: {'data': data},
                    beforeSend: function () {
                        KTApp.blockPage({
                            overlayColor: "#000000",
                            type: "loader",
                            state: "danger",
                            message: "Please wait ..."
                        });
                    },
                    success: function (result) {
                        let obj = JSON.parse(result);
                        if (obj.status == 'ok') {
                            notifySuccess(obj.message);
                            var table = $.fn.dataTable.tables({api: true});
                            table.ajax.reload();
                        } else {
                            Swal.fire('', obj.message, 'warning');
                        }
                        KTApp.unblockPage();
                    },
                    error: function (xhr) {
                        KTApp.unblockPage();
                        Swal.fire('', xhr.statusText, 'warning');
                    }
                });
            }
        })
    }
    function depreciateSelected(table) {
        if (table.rows('.selected').data().length < 1)
            return;
        var data = [];
        $.each(table.rows('.selected').data(), function () {
            data.push(this["asset_dep_key"]);
        });

        //alert(data);
        Swal.fire({
            title: "You are about depreciating (" + table.rows('.selected').data().length + ") assets",
            //text: "You are about depreciating (" + table.rows('.selected').data().length + ") assets",
            //type: 'question',
            html:
                '<hr>Select Depreciation Date <input required name="asset_depreciation_date" type="date" id="swal-input1" class="swal2-input">' +
                'Accumulated Depreciation Account <select required id="swal-input3" class="swal2-input" style="width:100%;"><?php
                    $accounts = $this->accountingModel->accounts(); foreach ($accounts as $account){echo '<option value="'.$account['account_key'].'">'.$account['account_name'].'</option>'; }?></select>' +
                'Depreciation Expense Account <select required id="swal-input4" class="swal2-input" style="width:100%;"><?php
                    $accounts = $this->accountingModel->accounts(); foreach ($accounts as $account){echo '<option value="'.$account['account_key'].'">'.$account['account_name'].'</option>'; }?></select>' +
                'Select Financial Period <select required type="date" id="swal-input2" class="swal2-input"><?php
                    $periods = $this->periodModel->find_all(); foreach ($periods as $period){echo '<option value="'.$period['fp_key'].'">'.$period['fp_prefix'].'</option>'; }?></select>' +
                '<code>To add new financial period, Go to Accounting >> Settings >> Financial Periods >> Add New </code>' +
                '<label id="err_message" style="color:red" hidden>All fields are required!</lable>',
            preConfirm: function () {
                return new Promise(function (resolve) {
                    resolve([
                        $('#swal-input1').val(),
                        $('#swal-input2').val(),
                        $('#swal-input3').val(),
                        $('#swal-input4').val()
                    ])
                })
            },
            onOpen: function () {
                $('#swal-input1').focus()
            },
            showCancelButton: true,
            animation: "slide-from-top",
            closeOnConfirm: false,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Depreciate!'
        }).then((result) => {
            if (result.value) {
                let depDate = $('#swal-input1').val();
                let depPeriod = $('#swal-input2').val();
                let depAccount = $('#swal-input3').val();
                let depCreditAccount = $('#swal-input4').val();
                //alert(depDate +' '+ depPeriod);
                if (depDate === "" || depPeriod === "" || depAccount === "" || depCreditAccount === ""){
                    Swal.fire("Warning", "All fields are required!", "warning");
                }
                else {
                    $.ajax({
                        url: "<?php echo base_url('accounting/assets/runDepSelected');?>",
                        type: "post",
                        data: {
                            "data": data,
                            "asset_depreciation_date": depDate,
                            "financial_period": depPeriod,
                            "dep_accumulated_account": depAccount,
                            "dep_expense_account": depCreditAccount
                        },
                        beforeSend: function () {
                            KTApp.blockPage({
                                overlayColor: "#000000",
                                type: "loader",
                                state: "danger",
                                message: "Depreciating assets, Please wait ..."
                            });
                        },
                        success: function(result){
                            KTApp.unblockPage();
                            let obj = JSON.parse(result);
                            if( obj.status === 'ok'){
                                notifySuccess(obj.message);
                                var table = $.fn.dataTable.tables( { api: true } );
                                table.ajax.reload();
                            }else{
                                Swal.fire('',obj.message,'warning');
                                var table = $.fn.dataTable.tables( { api: true } );
                                table.ajax.reload();
                            }
                        },
                        error: function(xhr){
                            KTApp.unblockPage();
                            Swal.fire('',xhr.statusText,'warning');
                            var table = $.fn.dataTable.tables( { api: true } );
                            table.ajax.reload();
                        }

                    });
                }
            }
        })
    }
    function runDep(depr){
        Swal.fire({
            title: 'You are about to run asset Depreciation!',
            //text: 'You are about to run asset Depreciation!',
            //type: 'question',
            html:
                '<hr>Select Depreciation Date <input required name="asset_depreciation_date" type="date" id="swal-input1" class="swal2-input">' +
                'Accumulated Depreciation Account <select required id="swal-input3" class="swal2-input" style="width:100%;"><?php
                    $accounts = $this->accountingModel->accounts(); foreach ($accounts as $account){echo '<option value="'.$account['account_key'].'">'.$account['account_name'].'</option>'; }?></select>' +
                'Depreciation Expense Account <select required id="swal-input4" class="swal2-input" style="width:100%;"><?php
                    $accounts = $this->accountingModel->accounts(); foreach ($accounts as $account){echo '<option value="'.$account['account_key'].'">'.$account['account_name'].'</option>'; }?></select>' +
                'Select Financial Period <select required type="date" id="swal-input2" class="swal2-input"><?php
                    $periods = $this->periodModel->find_all(); foreach ($periods as $period){echo '<option value="'.$period['fp_key'].'">'.$period['fp_prefix'].'</option>'; }?></select>' +
                '<code>To add new financial period, Go to Accounting >> Settings >> Financial Periods >> Add New </code>' +
                '<label id="err_message" style="color:red" hidden>All fields are required!</lable>',
            preConfirm: function () {
                return new Promise(function (resolve) {
                    resolve([
                        $('#swal-input1').val(),
                        $('#swal-input2').val(),
                        $('#swal-input3').val(),
                        $('#swal-input4').val()
                    ])
                })
            },
            onOpen: function () {
                $('#swal-input1').focus()
            },
            showCancelButton: true,
            animation: "slide-from-top",
            closeOnConfirm: false,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Run it!'
        }).then((result) => {
            if (result.value) {
                let depDate = $('#swal-input1').val();
                let depPeriod = $('#swal-input2').val();
                let depAccount = $('#swal-input3').val();
                let depCreditAccount = $('#swal-input4').val();
                //alert(depDate +' '+ depPeriod);
                if (depDate === "" || depPeriod === "" || depAccount === "" || depCreditAccount === ""){
                    Swal.fire("Warning", "All fields are required!", "warning");
                }
                else {
                    $.ajax({
                        url: "<?php echo base_url('accounting/assets/runDepreciation/');?>" + depr,
                        type: "post",
                        data: {
                            "asset_depreciation_date": depDate,
                            "financial_period": depPeriod,
                            "dep_accumulated_account": depAccount,
                            "dep_expense_account": depCreditAccount
                        },
                        beforeSend: function () {
                            KTApp.blockPage({
                                overlayColor: "#000000",
                                type: "loader",
                                state: "danger",
                                message: "Depreciating assets, Please wait ..."
                            });
                        },
                        success: function(result){
                            let obj = JSON.parse(result);
                            if( obj.status == 'ok'){
                                $('div#id-' + depr).hide();
                                notifySuccess(obj.message);
                                KTApp.unblockPage();
                                var table = $.fn.dataTable.tables( { api: true } );
                                table.ajax.reload();
                            }else{
                                KTApp.unblockPage();
                                Swal.fire('',obj.message,'warning');
                            }
                        },
                        error: function(xhr){
                            KTApp.unblockPage();
                            Swal.fire('',xhr.statusText,'warning');
                        }

                    })
                }

            }
        })
    }

</script>