<?php
 $start_year = $asset->asset_evaluation_date;
?>
<div class="kt-portlet__body">
    <input name="asset_cost" id="asset_cost" type="hidden" value="<?= to_money($asset->asset_cost); ?>" readonly>
    <div class="form-group">
        <label>Starting Date</label>
        <input type="date" name="app_start" value="<?= date('Y-m-d', strtotime($start_year));?>" class="form-control" id="app_start" readonly>
        <p style="color: dodgerblue">The date where this asset was bought</p>
    </div>
    <div class="form-group">
        <label>Target Date</label>
        <input type="date" name="app_end" class="form-control" id="app_end" required>
        <p style="color: red;display: none" id="targetError">Target year must be greater than starting year</p>
        <p style="color: red;display: none" id="targetRequired">Please select date</p>
    </div>
    <div class="form-group">
        <label>Appreciation Rate % (/year)</label>
        <input type="number" name="app_rate" min="0" max="100" step=".01" class="form-control" id="app_rate" required>
        <p style="color: red;display: none" id="rateRequired">Please enter appreciation rate</p>
        <p style="color: red;display: none" id="rateError">Rate value should range between 1 - 100</p>
    </div>
    <div class="form-group">
        <table class="table table-bordered" style="background: lightgray">
            <tr>
                <td class="overview">Starting Value (TZS)</td>
                <td style="color: brown;font-weight: bold">
                    <?= number_format(to_money($asset->asset_cost),2,'.',','); ?>
                </td>
            </tr>
            <tr>
                <td class="overview">Future Value (TZS)</td>
                <td style="color: brown;font-weight: bold" id="finVal">
                    0000.00
                </td>
            </tr>
            <tr>
                <td class="overview">Rate (/year)</td>
                <td style="color: brown;font-weight: bold" id="finValRate">
                    0.00%
                </td>
            </tr>
        </table>
    </div>

</div>
<script>
    $(function (){
        var yStart = $('input#app_start').val();
        var getEnd = new Date(yStart);
        var yMin = getEnd.getFullYear()+1;
        var mMin = getEnd.getMonth();
        var dMin = getEnd.getDate();

        var nextDate = new Date(yMin +'-'+ mMin +'-'+ dMin);
        app_end.min = new Date(nextDate).toISOString().split("T")[0];
        //alert(yStart +'  '+ nextDate);

        $('input#app_rate').keyup(function (){
            //alert('yes');
            let newRate = $(this).val();
            let yearStart = $('input#app_start').val();
            let yearEnd = $('input#app_end').val();
            let assetCost = $('input#asset_cost').val();
            if(newRate === ''){
                $('#rateRequired').css('display','block');
                $('#rateError').css('display','none');
                $('#finVal').html('0000.00');
                $('#finValRate').html('0.00%');
            }
            else if(yearEnd === ''){
                $('#targetRequired').css('display','block');
                $('#finVal').html('0000.00');
                $('#finValRate').html('0.00%');
            }
            else if(newRate < 1 || newRate > 100){
                $('#rateError').css('display','block');
                $('#rateRequired').css('display','none');
                $('#finVal').html('0000.00');
                $('#finValRate').html('0.00%');
            }
            else {
                $('#targetRequired').css('display','none');
                $('#rateRequired').css('display','none');
                $('#rateError').css('display','none');
                $.ajax({
                    url: "<?php echo base_url('accounting/assets/calculateAppreciation');?>",
                    data: {
                        "app_start" : yearStart,
                        "app_end" : yearEnd,
                        "asset_cost" : assetCost,
                        "app_rate" : newRate,
                    },
                    type: "post",
                    success: function(result){
                        if( result.status === true){
                            $("td#finVal").html(result.finVal);
                            $("td#finValRate").html(result.appRate + '%');
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    }
                })
            }

        });

        $('input#app_end').change(function (){
            $('#targetRequired').css('display','none');
            //alert('changed');
            let yearEnd = $(this).val();
            let yearStart = $('input#app_start').val();
            let assetCost = $('input#asset_cost').val();
            let appRate = $('input#app_rate').val();

            let dateStartDisplay = new Date(yearStart);
            let dateEndDisplay = new Date(yearEnd);
            let getStartYear = dateStartDisplay.getFullYear();
            let getEndYear = dateEndDisplay.getFullYear();

            if(getEndYear <= getStartYear){
                $('#targetError').css('display','block');
                $('#targetRequired').css('display','none');
            }
            else if(appRate ===''){
                $('p#rateRequired').css('display','block');
            }
            else {
                $('#targetRequired').css('display','none');
                $('p#rateRequired').css('display','none');
                $('#targetError').css('display','none');
                $.ajax({
                    url: "<?php echo base_url('accounting/assets/calculateAppreciation');?>",
                    data: {
                        "app_start" : yearStart,
                        "app_end" : yearEnd,
                        "asset_cost" : assetCost,
                        "app_rate" : appRate,
                    },
                    type: "post",
                    success: function(result){
                        if( result.status === true){
                            $("td#finVal").html(result.finVal);
                            $("td#finValRate").html(result.appRate + '%');
                        }else{
                            swal.fire("","An error occurred! "+ result.message,"warning");
                        }
                    }
                })
            }

        });
    })
</script>