<div  class="modal  fade" id="account-increase-decrease" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div  class="modal-dialog modal-md" role="document">
        <div style="" class="modal-content lm-modal">
            <div class="modal-body">
                <div class="modal-header">
                    <h3 class="kt-align-center" id="action-type"></h3>
                </div>
                <form class="kt-form row" id="account-increase-decrease" action="#">
                    <div class="form-group col-12">
                        <label>Amount (<?php echo runnCurrency()->bs_symbol;?>)</label>
                        <input required class="form-control number" name="amount" placeholder="Amount" />
                    </div>
                    <div class="form-group col-12">
                        <label>Date</label>
                        <input required type="date" class="form-control number" name="date"  value="<?php echo date("Y-m-d")?>"/>
                    </div>
                    <div class="form-group col-12">
                        <label>Description</label>
                        <textarea required class="form-control" name="desc"  placeholder="Description"></textarea>
                    </div>
                    <div class="form-group col-6">
                        <button type="button" class="btn btn-sm btn-dark pull-left" data-dismiss="modal">Cancel</button>
                    </div>
                    <input name="action" type="hidden" id="type-action" />
                    <div class="form-group col-6">
                        <button type="submit" class="btn btn-sm btn-success pull-right">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    "use strict";

    var KTPortletTools = function () {

        // chat of accounts
        var accounts = function() {

            let accounts = new KTPortlet('kt_portlet_account_history');

            // Toggle event handlers
            accounts.on('beforeCollapse', function(portlet) {

            });

            accounts.on('afterCollapse', function(portlet) {

            });

            accounts.on('beforeExpand', function(portlet) {

            });

            accounts.on('afterExpand', function(portlet) {

            });

            // Remove event handlers
            accounts.on('beforeRemove', function(portlet) {
                return confirm('Are you sure to remove this block ?');
            });

            accounts.on('afterRemove', function(portlet) {

            });

            // Reload event handlers
            accounts.on('reload', function(portlet) {

                KTApp.block(portlet.getSelf(), {
                    overlayColor: '#ffffff',
                    type: 'loader',
                    state: 'success',
                    opacity: 0.3,
                    size: 'lg'
                });

                var table = $.fn.dataTable.tables( { api: true } );
                table.ajax.reload();

                notifySuccess("updated");
                KTApp.unblock(portlet.getSelf());

            });

            // Reload event handlers
            accounts.on('afterFullscreenOn', function(portlet) {
                var scrollable = $(portlet.getBody()).find('> .kt-scroll');

                if (scrollable) {
                    scrollable.data('original-height', scrollable.css('height'));
                    scrollable.css('height', '100%');

                    KTUtil.scrollUpdate(scrollable[0]);
                }
            });

            accounts.on('afterFullscreenOff', function(portlet) {
                var scrollable = $(portlet.getBody()).find('> .kt-scroll');

                if (scrollable) {
                    var scrollable = $(portlet.getBody()).find('> .kt-scroll');
                    scrollable.css('height', scrollable.data('original-height'));

                    KTUtil.scrollUpdate(scrollable[0]);
                }
            });
        }

        return {
            //main function to initiate the module
            init: function () {
                // init portlets
                accounts();
            }
        };
    }();

    let LMDatatableAccounts = function() {
        var initTable = function() {
            //begin first table
            let table = $('#lm_table_account_history');
                       if(table != undefined) {
                           table.DataTable({
                               responsive: true,
                               serverSide: false,
                               processing: true,
                               ajax: '<?php echo base_url('accounting/account/index/source_account_history/'. $account->account_key);?>',
                               columns: [
                                   {data: 'gl_date'},
                                   {data: 'gl_type'},
                                   {data: 'gl_reference'},
                                   {data: 'gl_debit'},
                                   {data: 'gl_credit'},
                                   {data: 'gl_details'},
                               ],
                               // Pagination settings
                               dom: `<'row'<'col-sm-6 text-left'f><'col-sm-6 text-right'B>>
                                    <'row'<'col-sm-12'tr>>
                                    <'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>`,
                               lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
                               pageLength: 10,
                               language: {
                                   'lengthMenu': 'Display _MENU_',
                                   "emptyTable": "No record found",
                               },
                               searchDelay: 500,
                               buttons: [
                                   'print',
                                   'copyHtml5',
                                   'excelHtml5',
                                   'csvHtml5',
                                   'pdfHtml5',
                               ],
                               columnDefs: [
                                   {
                                       targets: 3,
                                       "width": "15%",
                                       render: function (data, type, full, meta) {
                                           if(full.gl_debit > 0){
                                               return "Debit";
                                           }else{
                                               return "Credit"
                                           }

                                       },
                                   },
                                   {
                                       targets: 4,
                                       "width": "15%",
                                       render: function (data, type, full, meta) {
                                           if(full.gl_debit > 0){
                                               var number = numeral(to_money(full.gl_debit));
                                           }else{
                                               var number = numeral(to_money(full.gl_credit));
                                           }

                                           return number.format(0,0) ;
                                       },
                                   },
                                   {
                                       targets: 5,
                                       "width": "15%",
                                       render: function (data, type, full, meta) {
                                           var number = numeral(to_money(full.gl_balance));
                                           return number.format(0,0) ;
                                       },
                                   },
                                   // {
                                   //     targets: 6,
                                   //     "width": "5%",
                                   //     render: function (data, type, full, meta) {
                                   //       return '<a class="" data-backdrop="false" data-toggle="modal" data-key="'+ full.gl_key +'" href="#edit-gl-record"><i class="la la-edit"></i></a>\n' +
                                   //         ' <a class=""  href="javascript:deleteGlRecord('+ full.gl_key +');"><i class="la la-trash kt-font-danger"></i></a>\n' ;
                                   //     },
                                   // },
                               ]
                           });
                       }
        };

        return {
            //main function to initiate the module
            init: function() {
                initTable();
            },

        };

    }();

  jQuery(document).ready(function() {

      LMDatatableAccounts.init();
      KTPortletTools.init();

      $("select").select2({placeholder:"Select Account Type"});

      $('div#account-increase-decrease').on('show.bs.modal', function (event) {
          let modal = $(this);
          const body = modal.find('.modal-body');
          let button = $(event.relatedTarget)
          body.find('form').resetForm();
          body.find("input#type-action").val(button.data("action"));
          body.find("h3#action-type").html(button.data("action") + " Account");
      })

      $('form#account-increase-decrease').submit( function(e){
          e.preventDefault();
          let form = $('form#account-increase-decrease');
          let modal = $('div#account-increase-decrease');
          const formData = form.serialize();
          $.ajax({
              url: '<?php echo base_url('accounting/account/index/increasedecrease')?>/<?php echo $account->account_key;?>',
              type: 'get',
              data: formData,
              beforeSend: function(){
                  KTApp.block(modal,{
                      overlayColor:"#000000",
                      type:"loader",
                      state:"danger",
                      message:"Please wait ..."
                  });
              },
              success: function(result){
                  KTApp.unblock(modal);
                  modal.modal("hide");
                  if( result.status == true){
                      notifySuccess(result.message);
                      var table = $.fn.dataTable.tables( { api: true } );
                      table.ajax.reload();
                  }else{
                      swal.fire("Response",result.message,"warning");
                  }
              },
              error: function(xhr){
                  modal.modal("hide");
                  KTApp.unblock(modal);
                  <?php if(ENVIRONMENT !== 'production'){?>
                  Swal.fire('Response', xhr.statusText,'error');
                  <?php }?>
              }
          });
      })

  });

</script>