<?php

class TaskModel extends MY_Model {
    public $branch;
    public $business;

    public function __construct() {
        parent::__construct();
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    public function tasks() {
        $this->db->order_by('task_id','DESC');
        $this->db->where('task_business_key',$this->business)
            ->where('task_status','Pending')
            ->or_where('task_status','Paused')
            ->or_where('task_status','OnProgress')
            ->join('business','business.business_key=tasks.task_business_key','left');
        $query = $this->db->get('tasks','10');
        return $query->result_array();
    }

    public function tasksUser() {
        $this->db->order_by('task_det_id','DESC');
        $this->db->where('task_det_business_key',$this->business)
            ->where('task_det_task_status','Pending')
            ->join('business','business.business_key=task_details.task_det_business_key','left')
            ->join('users_details','users_details.user_key=task_details.task_det_task_emp','left');
        $query = $this->db->group_by('task_det_task_emp')->get('task_details','10');
        return ($query->num_rows()>0) ? $query->result_array() : false;
    }

    public function tasksbyme($auth_user_id) {
        $this->db->join('tasks','tasks.task_key=task_details.task_det_task_emp', 'left')
            ->join('users_details','users_details.user_key=task_details.task_det_task_created_by','left')
            ->join('projects','projects.project_key=task_details.task_det_project_key','left')
            ->order_by('task_det_id','DESC')
            ->where('task_det_task_emp', $auth_user_id);
        $query = $this->db->where('task_det_task_status','Pending')->get('task_details');
        return ($query->num_rows()>0) ? $query->result_array() : false;
    }

    public function ongoingbyme($auth_user_id) {
        $this->db->join('tasks','tasks.task_key=task_details.task_det_task_emp', 'left')
            ->join('users_details','users_details.user_key=task_details.task_det_task_created_by','left')
            ->join('projects','projects.project_key=task_details.task_det_project_key','left')
            ->order_by('task_det_id','DESC')
            ->where('task_det_task_emp', $auth_user_id);
        $query = $this->db->where('task_det_task_status','OnProgress')->get('task_details');
        return ($query->num_rows()>0) ? $query->result_array() : false;
    }

    public function completebyme($auth_user_id) {
        $this->db->join('tasks','tasks.task_key=task_details.task_det_task_emp', 'left')
            ->join('users_details','users_details.user_key=task_details.task_det_task_created_by','left')
            ->join('projects','projects.project_key=task_details.task_det_project_key','left')
            ->order_by('task_det_id','DESC')
            ->where('task_det_task_emp', $auth_user_id);
        $query = $this->db->where('task_det_task_status','Completed')->get('task_details');
        return ($query->num_rows()>0) ? $query->result_array() : false;
    }

    public function freight_tasksbyme($auth_user_id) {
        $this->db->join('users_details','users_details.user_key=freight_task.freight_task_created_by','left')
            ->order_by('freight_task_id','DESC')
            ->where('freight_task_employee_key', $auth_user_id);
        $query = $this->db->where('freight_task_status','Pending')->get('freight_task');
        return ($query->num_rows()>0) ? $query->result_array() : false;
    }


    public function freight_ongoingbyme($auth_user_id) {
        $this->db->join('users_details','users_details.user_key=freight_task.freight_task_created_by','left')
            ->order_by('freight_task_id','DESC')
            ->where('freight_task_employee_key', $auth_user_id);
        $query = $this->db->where('freight_task_status','OnProgress')->get('freight_task');
        return ($query->num_rows()>0) ? $query->result_array() : false;
    }

    public function freight_completebyme($auth_user_id) {
        $this->db->join('users_details','users_details.user_key=freight_task.freight_task_created_by','left')
            ->order_by('freight_task_id','DESC')
            ->where('freight_task_employee_key', $auth_user_id);
        $query = $this->db->where('freight_task_status','Completed')->get('freight_task');
        return ($query->num_rows()>0) ? $query->result_array() : false;
    }

    public function tasksbyme1($auth_user_id) {
        $this->db->join('tasks','tasks.task_key=task_employee.task_employee_task_key', 'left')
            ->order_by('task_employee_id','DESC')
            ->where('task_employee_user_id', $auth_user_id);
        $query = $this->db->get('task_employee');
        return ($query->num_rows()>0) ? $query->result_array() : false;
    }

    public function tasksbymec($auth_user_id) {
        $this->db->join('tasks','tasks.task_key=task_employee.task_employee_task_key', 'left')
            ->where('task_employee_user_id', $auth_user_id);
        $query = $this->db->get('task_employee','3');
        return ($query->num_rows()>0) ? $query->result_array() : false;
    }

    public function createTask($task,$employee){
        $this->db->trans_start();
        $this->db->insert('tasks',$task);
        foreach ($employee as $key => $val) {
            $dt['task_employee_user_id'] = $val;
            $dt['task_employee_task_key'] = $task['task_key'];
            $dt['task_employee_date_created'] = date('Y-m-d');
            $this->db->insert('task_employee',$dt);
        }
        $this->db->trans_complete();
        return $this->db->trans_status();
    }

    public function createTasks($mainTask){
        $this->db->trans_start();
        $this->db->insert('tasks',$mainTask);

        if(!empty($items = $this->input->post('group_task'))){
            foreach ($items as $item){
                $itemTask['task_det_key'] = $this->taskdetailsKey();
                $itemTask['task_det_task_key'] = $mainTask['task_key'];
                $itemTask['task_det_project_key'] = $mainTask['task_project_key'];
                $itemTask['task_det_task_emp'] = $item['task_det_task_emp'];
                $itemTask['task_det_task_desc'] = $item['task_det_task_desc'];
                $itemTask['task_det_task_mode'] = $item['task_det_task_mode'];
                $itemTask['task_det_task_created_by'] = $this->auth_user_id;
                $itemTask['task_det_task_date_created'] = date('Y-m-d H:i:s');
                $itemTask['task_det_task_start'] = $mainTask['task_start'];
                $itemTask['task_det_task_deadline'] =$mainTask['task_deadline'];
                $this->db->insert('task_details',$itemTask);
            }
        }

        $this->db->trans_complete();
        return $this->db->trans_status();
    }

    public function select_one_task($key){
        $this->db->join('projects','projects.project_key=tasks.task_project_key','left')
            ->join('users_details','users_details.user_key=tasks.task_created_by','left');
        $query = $this->db->where('task_key', $key)->from('tasks')->get();
        return $query->row();
    }

    function select_item($key){
        $this->db->where('task_det_task_key', $key);
        $query = $this->db->get("task_details");
        return  $query->num_rows() > 0 ? $query->result_array() : false;
        //return $query->row();
    }

    public function select_one_task_employee($key){
        $this->db->join('projects','projects.project_key=task_details.task_det_project_key','left')
            ->join('users_details','users_details.user_key=task_details.task_det_task_emp','left');
        $query = $this->db->where('task_det_key', $key)->from('task_details')->get();
        return $query->row();
    }

    public function select_one_task_freight($key){
        $this->db->join('users_details','users_details.user_key=freight_task.freight_task_employee_key','left');
        $query = $this->db->where('freight_task_key', $key)->from('freight_task')->get();
        return $query->row();
    }

    public function taskUpdate($key,$data,$employee){
        $this->db->trans_start();
        $this->db->where('task_business_key',$this->business);
        $this->db->limit(1)
            ->where('task_key=',$key)
            ->update('tasks',$data );
        foreach ($employee as $key => $val) {
            $dt['task_employee_user_id'] = $val;
            $dt['task_employee_task_key'] = $key;
            $dt['task_employee_date_created'] = date('Y-m-d');
            $this->db->update('task_employee',$dt);
        }
        $this->db->trans_complete();
        return $this->db->trans_status();
    }

    function taskEmployeeUpdate($taskKey,$data){
        $this->db->where('task_det_key',$taskKey);
        $this->db->update('task_details',$data);
        if($this->db->affected_rows()>0){
            return true;
        }
        return false;
    }

    function taskFreightEmployeeUpdate($taskKey,$data){
        $this->db->where('freight_task_key',$taskKey);
        $this->db->update('freight_task',$data);
        if($this->db->affected_rows()>0){
            return true;
        }
        return false;
    }

    function taskEmployeeFreightUpdate($taskKey,$data){
        $this->db->where('freight_task_key',$taskKey);
        $this->db->update('freight_task',$data);
        if($this->db->affected_rows()>0){
            return true;
        }
        return false;
    }

    function startTask($task,$data){
        $this->db->where('task_key',$task);
        $this->db->update('tasks',$data);
        if($this->db->affected_rows()>0){
            return true;
        }
        return false;
    }

    function startTaskEmployee($task,$data){
        $this->db->where('task_det_key',$task);
        $this->db->update('task_details',$data);
        if($this->db->affected_rows()>0){
            return true;
        }
        return false;
    }

    function startFreightTaskEmployee($task,$data){
        $this->db->where('freight_task_key',$task);
        $this->db->update('freight_task',$data);
        if($this->db->affected_rows()>0){
            return true;
        }
        return false;
    }

    function finishFreightTaskEmployee($task,$data){
        $this->db->where('freight_task_key',$task);
        $this->db->update('freight_task',$data);
        if($this->db->affected_rows()>0){
            return true;
        }
        return false;
    }

    public function deleteTask($key) {
        $this->db->where('task_business_key',$this->business);
        $this->db->limit(1)
            ->where('task_key=',$key)
            ->delete('tasks');
        return ($this->db->affected_rows()==1)? TRUE :FALSE;
    }

    public function commentTask($data) {
        $this->db->limit(1)
            ->insert('comment_task',$data);
        return ($this->db->affected_rows()==1)? TRUE : FALSE;
    }

    public function commentFreightTask($data) {
        $this->db->limit(1)
            ->insert('comment_task',$data);
        return ($this->db->affected_rows()==1)? TRUE : FALSE;
    }

    public function comment_task($key){
        $this->db->join('users_details','users_details.user_key=comment_task.comment_user_id','left');
        $query = $this->db->where('comment_task_key', $key)->order_by('comment_task_id','DESC')->from('comment_task')->get();
        return ($query->num_rows()>0) ? $query->result_array() : false;
    }

    public function comment_freight_task($key){
        $this->db->join('users_details','users_details.user_key=comment_task.comment_user_id','left');
        $query = $this->db->where('comment_task_key', $key)->order_by('comment_task_id','DESC')->from('comment_task')->get();
        return ($query->num_rows()>0) ? $query->result_array() : false;
    }

    public function subTask($key){
        $this->db->join('users_details','users_details.user_key=task_details.task_det_task_emp','left')
                 ->join('projects','projects.project_key=task_details.task_det_project_key','left');
        $query = $this->db->where('task_det_task_key', $key)->from('task_details')->get();
        return ($query->num_rows()>0) ? $query->result_array() : false;
    }

    public function createSubTask($subtask) {
        $subtask['task_det_key'] = $this->taskdetailsKey();
        $subtask['task_det_business_key'] = $this->business;
        $subtask['task_det_branch_key'] = $this->branch;
        $this->db->limit(1)
            ->insert('task_details',$subtask);
        return ($this->db->affected_rows()==1)? TRUE : FALSE;
    }

    //----------------MODIFY TASK HERE--------------//

    public function update($key,$tasks){
        $this->db->trans_start();
        $this->db->limit(1)
            ->where('task_key=',$key)
            ->update('tasks',$tasks );

        if(!empty($items = $this->input->post('group_task'))){
            foreach ($items as $item){
                $itemTask['task_det_key'] = $this->taskdetailsKey();
                $itemTask['task_det_task_key'] = $key;
                //$itemTask['task_det_task_key'] = $item['task_det_task_key'];
                //$itemTask['task_det_task_key'] = $tasks['task_key'];
                $itemTask['task_det_project_key'] = $tasks['task_project_key'];
                $itemTask['task_det_task_emp'] = $item['task_det_task_emp'];
                $itemTask['task_det_task_desc'] = $item['task_det_task_desc'];
                $itemTask['task_det_task_mode'] = $item['task_det_task_mode'];
                $itemTask['task_det_task_created_by'] = $this->auth_user_id;
                $itemTask['task_det_task_date_created'] = date('Y-m-d H:i:s');
                $itemTask['task_det_task_start'] = $tasks['task_start'];
                $itemTask['task_det_task_deadline'] =$tasks['task_deadline'];
                $this->db->insert('task_details',$itemTask);
            }
        }

        $this->db->trans_complete();
        return $this->db->trans_status();
    }

    public function adminFinishTask($taskKey,$data,$subtask){
        $this->db->trans_start();
        $this->db->limit(1)
            ->where('task_key=',$taskKey)
            ->update('tasks',$data );
        foreach ($subtask as $key => $item){
            $itemTask['task_det_task_status'] = 'Completed';
            $itemTask['task_det_task_percent'] = '100';
            $this->db->where('task_det_task_key=',$taskKey)->update('task_details',$itemTask);
        }

        $this->db->trans_complete();
        return $this->db->trans_status();
    }

    //----------------END MODIFY TASK HERE--------------//

    public function projects() {
        $this->db->order_by('project_id','DESC');
        $this->db->where('project_business_key',$this->business)
            ->where('project_status','Pending')
            ->join('business','business.business_key=projects.project_business_key','left');
        $query = $this->db->get('projects');
        return $query->result_array();
    }

    public function ongoing_projects() {
        $this->db->order_by('project_id','DESC');
        $this->db->where('project_business_key',$this->business)
            ->join('business','business.business_key=projects.project_business_key','left');
        $query = $this->db->where('project_status','OnProgress')->get('projects');
        return $query->result_array();
    }

    public function finished_projects() {
        $this->db->order_by('project_id');
        $this->db->where('project_business_key',$this->business)
            ->where('project_status','Completed')
            ->join('business','business.business_key=projects.project_business_key','left');
        $query = $this->db->get('projects','5');
        return $query->result_array();
    }

    function projectsTask() {
        $this->db->order_by('project_id','DESC');
        $this->db->where('project_business_key',$this->business)
            ->where('project_status','Pending')
            ->or_where('project_status','OnProgress')
            ->join('business','business.business_key=projects.project_business_key','left');
        $query = $this->db->get('projects');
        return $query->result_array();
    }

    public function subTaskStatus($key){
        $query = $this->db->where('task_det_task_key', $key)->from('task_details')->get();
        return ($query->num_rows()>0) ? $query->result_array() : false;

        $flag = 0;
        foreach ($item as $query){
            if ($item = 'Pending' || $item = 'OnProgress'){
                $flag=1;
            }

        }

    }

    //-----------------COUNT TASK--------------------//

    function tasksbymenumber($auth_user_id){
        $query = $this->db->where('task_det_task_status','Pending')->where('task_det_task_emp',$auth_user_id)->get('task_details');
        return $query->num_rows();
    }

    function ongoingbymenumber($auth_user_id){
        $query = $this->db->where('task_det_task_status','OnProgress')->where('task_det_task_emp',$auth_user_id)->get('task_details');
        return $query->num_rows();
    }

    function completebymenumber($auth_user_id){
        $query = $this->db->where('task_det_task_status','Completed')->where('task_det_task_emp',$auth_user_id)->get('task_details');
        return $query->num_rows();
    }

    function privatemenumber($auth_user_id){
        $query = $this->db->where('pri_note_status','Pending')->where('pri_note_created_by',$auth_user_id)->get('private_note');
        return $query->num_rows();
    }

    //--------------END COUNT----------------//


    //--------------PRIVATE TASK FUNCTION------------//
    public function createNote($note) {
        $note['pri_note_key'] = $this->noteKey();
        $note['pri_note_business_key'] = $this->business;
        $note['pri_note_branch_key'] = $this->branch;
        $this->db->limit(1)
            ->insert('private_note',$note);
        return ($this->db->affected_rows()==1)? TRUE : FALSE;
    }

    public function privateTask($auth_user_id) {
        $this->db->join('users_details','users_details.user_key=private_note.pri_note_created_by','left')
            ->join('projects','projects.project_key=private_note.pri_note_project_key','left')
            ->order_by('pri_note_id','DESC')
            ->where('pri_note_created_by', $auth_user_id);
        $query = $this->db->get('private_note');
        return ($query->num_rows()>0) ? $query->result_array() : false;
    }

    public function deleteNote($key) {
        $this->db->where('pri_note_business_key',$this->business);
        $this->db->limit(1)
            ->where('pri_note_key=',$key)
            ->delete('private_note');
        return ($this->db->affected_rows()==1)? TRUE :FALSE;
    }


    //--------------KEYS---------------------//

    public function taskKey(){
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );
        $query = $this->db->where( 'task_key', $random_unique_int )->get_where( 'tasks');
        if( $query->num_rows() > 0 ) {
            $query->free_result();
            return $this->taskKey();
        }
        return $random_unique_int;
    }

    public function taskdetailsKey(){
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );
        $query = $this->db->where( 'task_det_key', $random_unique_int )->get_where( 'task_details');
        if( $query->num_rows() > 0 ) {
            $query->free_result();
            return $this->taskdetailsKey();
        }
        return $random_unique_int;
    }

    public function noteKey(){
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );
        $query = $this->db->where( 'pri_note_key', $random_unique_int )->get_where( 'private_note');
        if( $query->num_rows() > 0 ) {
            $query->free_result();
            return $this->noteKey();
        }
        return $random_unique_int;
    }

}