<?php

class ProjectModel extends MY_Model {
    public $branch;
    public $business;

    public function __construct() {
        parent::__construct();
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    public function projects() {
        $this->db->order_by('project_id','DESC');
        $this->db->where('project_business_key',$this->business)
            ->join('business','business.business_key=projects.project_business_key','left');
        $query = $this->db->get('projects');
        return $query->result_array();
    }

    public function ongoing_projects() {
        $this->db->order_by('project_id','DESC');
        $this->db->where('project_business_key',$this->business)
            ->join('business','business.business_key=projects.project_business_key','left');
        $query = $this->db->where('project_status','OnProgress')->get('projects');
        return $query->result_array();
    }

    public function finished_projects() {
        $this->db->order_by('project_id','DESC');
        $this->db->where('project_business_key',$this->business)
            ->join('business','business.business_key=projects.project_business_key','left');
        $query = $this->db->where('project_status','Completed')->get('projects');
        return $query->result_array();
    }

    public function createProject($project) {
        $project['project_key'] = $this->projectKey();
        $project['project_business_key'] = $this->business;
        $this->db->limit(1)
            ->insert('projects',$project);
        return ($this->db->affected_rows()==1)? TRUE : FALSE;
    }

    public function projectUpdate($key,$data){
        $this->db->where('project_business_key',$this->business);
        $this->db->limit(1)
            ->where('project_key=',$key)
            ->update('projects',$data );
        return ($this->db->affected_rows()== 1)? TRUE :FALSE;
    }

    public function select_one_project($key){
        $query = $this->db->where('project_key', $key)->from('projects')->get();
        return $query->row();
    }

    public function deleteProject($key) {
        $this->db->where('project_business_key',$this->business);
        $this->db->limit(1)
            ->where('project_key=',$key)
            ->delete('projects');
        return ($this->db->affected_rows()==1)? TRUE :FALSE;
    }

    public function projectKey(){
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );
        $query = $this->db->where( 'project_key', $random_unique_int )->get_where( 'projects');
        if( $query->num_rows() > 0 ) {
            $query->free_result();
            return $this->projectKey();
        }
        return $random_unique_int;
    }

}