<?php

require_once APPPATH.'models/BMS_Model.php';

class QuotationsModel extends BMS_Model
{
    protected $branch_field = "quot_branch";
    protected $branch;
    protected $business_field = 'quot_business';
    protected $business;

    protected $filterable_date_field = 'quot_issued_date';

    protected $table_name   = 'quotations';
    protected $key          = 'quot_key';
    protected $primary_key  = 'quot_key';
    protected $soft_deletes = TRUE;
    protected $date_format  = 'datetime';
    protected $log_user     = FALSE;

    public    $selectable_fields = array('quot_total_before_tax','quot_total_after_tax','quot_total_paid','quot_total_balance',
                                        'quot_accounting_posted','quot_address','quot_details','quot_branch','quot_business',
                                        'quot_key','quot_issued_date','quot_payer','firstname','lastname','middlename','mobilephone',
                                        'company_name','user_key','quot_total_tax','quot_total_after_tax','quot_total_after_tax',
                                        'quot_status','quot_id','quot_created_by','quot_modified_by','quot_created_on','quot_modified_on',
                                        'quot_deleted','quot_deleted_by','freight_ref','phonenumber','email','user_id');

    protected $set_created  = TRUE;
    protected $created_field    = 'quot_created_on';
    protected $created_by_field = 'quot_created_by';

    protected $set_modified     = FALSE;
    protected $modified_field   = 'quot_modified_on';
    protected $modified_by_field = 'quot_modified_by';

    protected $soft_delete_key    = 'quot_deleted';
    protected $deleted_by_field = 'quot_deleted_by';

    // Observers
    protected $before_insert    = array('set_key','set_created_by','set_ownership');
    protected $after_insert     = array('publish_events');
    protected $before_update    = array('set_modified_by','set_modified_on');
    protected $after_update     = array('publish_events');
    protected $before_find      = array('set_selectable_fields','set_join','set_select_dates','set_ownership_select');
    protected $after_find       = array();
    protected $before_delete    = array('set_deleted_by');
    protected $after_delete     = array('publish_events');

    protected $return_type      = 'array';
    protected $protected_attributes   = array();

    protected $validation_rules         = array();
    protected $insert_validation_rules  = array();
    protected $skip_validation          = true;

    public function __construct(&$write_db = null, &$read_db = null)
    {
        parent::__construct($write_db, $read_db);
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    function quotationItems($key){
        $this->db->where("quot_data_item_quotation",$key);
        $query = $this->db->get("quotation_data_items");
        return  $query->num_rows() > 0 ? $query->result_array() : false;
    }

    function quotationPayments($key){
        $this->db->where("quot_pay_quotation",$key);
        $this->db->join("payment_methods",'method_key = quot_pay_method','left');
        $this->db->join("users_details",'user_key = quot_pay_receiver','left');
        $query = $this->db->get("quotation_payments");
        return  $query->num_rows() > 0 ? $query->result_array() : false;
    }

    function quotationTaxes($key){
        $this->db->where("quot_data_tax_quotation",$key);
        $query = $this->db->get("quotation_data_taxes");
        return  $query->num_rows() > 0 ? $query->result_array() : false;
    }

    protected function set_key($row){

        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( $this->key, $random_unique_int )
            ->get_where( $this->table_name );

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->taxClassKey();
        }

        if (!array_key_exists($this->key, $row))
        {
            $row[$this->key] = $random_unique_int;
        }

        return $row;
    }

    protected function set_ownership($row){

        if(!empty($this->business)){
            $row[$this->business_field] = $this->business;
        }

        if(!empty($this->branch)){
            $row[$this->branch_field] = $this->branch;
        }

        return $row;
    }

    protected function set_created_by($row)
    {
        if (!array_key_exists($this->created_by_field, $row))
        {
            $row[$this->created_by_field] = config_item("auth_user_id");
        }

        return $row;
    }

    protected function set_deleted_by($id)
    {
        $this->dbw->where($this->primary_key, $id);
        $this->db->update($this->table_name, [$this->deleted_by_field => config_item("auth_user_id")]);
    }

    protected function set_modified_by($row)
    {
        if (!array_key_exists($this->modified_by_field, $row))
        {
            $row[$this->modified_by_field] = config_item("auth_user_id");
        }

        return $row;
    }

    protected function set_modified_on($row)
    {
        if (!array_key_exists($this->modified_field, $row))
        {
            $row[$this->modified_field] = date('Y-m-d H:m:i');
        }

        return $row;
    }

    protected function set_selectable_fields()
    {
        if(!empty($this->selectable_fields)){
            $this->db->select($this->selectable_fields);
        }

    }

    protected function set_select_dates(){
        if(!empty($when = $this->input->get("when"))){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where($this->filterable_date_field.'>=',$dates['start']);
            $this->db->where($this->filterable_date_field.'<=',$dates['end']);
        }
    }

    protected function set_join(){
        $this->db->join("users_details ud","ud.user_key=quot_payer","left");
        $this->db->join("users us","us.user_id=quot_payer","left");
    }

    protected function set_ownership_select(){
        $this->db->where($this->business_field,$this->business);
        $this->db->where($this->branch_field,$this->branch);
    }

    protected function publish_events(){
        $data['title'] = "";
        publishEventFlash('data-table-refresh',$data);
    }

}