<?php

class PayrollsModel extends My_model {

    public function __construct() {
        parent::__construct();
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    public function employeeTaxes($employee){
      $this->db->where('et_employee_key',$employee);
      $this->db->join('payroll_taxes pt','pt.payroll_tax_key=et_tax_key','left');
      $query = $this->db->get('employee_taxes');
      return $query->num_rows()>0 ? $query->result_array() : false;
    }

    public function variables() {
        $this->db->order_by('variable_id','DESC');
        $this->db->where('variable_business',$this->business);
        $query = $this->db->get('payroll_variables');
        return ($query->num_rows()>0)? $query->result_array(): FALSE;
      }

  public function employeeVariables($employee) {
      $this->db->order_by('variable_id','DESC');
      $this->db->where('ev_employee_key',$employee);
      $this->db->join('payroll_variables pv','pv.variable_key=ev_variable_key','left');
      $query = $this->db->get('employee_variables');
      return ($query->num_rows()>0)? $query->result_array(): FALSE;
    }

    public function addCompanyLiability($data){
      $data['ctc_key'] = $this->companyLiabilityKey();
//      $data['ctc_business'] = $this->business;
//      $data['ctc_branch'] = $this->branch;
      $this->db->insert('payrolls_company_liabilities',$data);
      return $this->db->affected_rows();
    }

    public function updateCompanyLiability($liability,$data){
      $this->db->where('ctc_key',$liability);
//      //$this->db->where('ctc_business',$this->business);
//      //$this->db->where('ctc_branch',$this->branch);
      $this->db->update('payrolls_company_liabilities',$data);
      return $this->db->affected_rows();
    }

    public function deleteCompanyLiability($liability){
      $this->db->where('ctc_key',$liability);
      //$this->db->where('ctc_business',$this->business);
      //$this->db->where('ctc_branch',$this->branch);
      $this->db->delete('payrolls_company_liabilities');
      return $this->db->affected_rows();
    }

    public function companyLiabilityDetails($liability){
      $this->db->where('ctc_key',$liability);
      //$this->db->where('ctc_business',$this->business);
      //$this->db->where('ctc_branch',$this->branch);
      $query = $this->db->get('payrolls_company_liabilities');
      return $query->num_rows()>0 ? $query->row() : false;
    }

    public function companyLiabilities(){
        $this->db->order_by('ctc_id','DESC');
        //$this->db->where('ctc_branch',$this->branch);
        //$this->db->where('ctc_business',$this->business);
        $query = $this->db->get('payrolls_company_liabilities');
        return ($query->num_rows()>0)? $query->result_array(): FALSE;
      }

      // -------
      public function addEmployeeLiability($data){
        $data['empl_key'] = $this->employeeLiabilityKey();
        $data['empl_business'] = $this->business;
        $data['empl_branch'] = $this->branch;
        $this->db->insert('payrolls_employee_liabilities',$data);
        return $this->db->affected_rows();
      }

      public function updateEmployeeLiability($liability,$data){
        $this->db->where('empl_key',$liability);
        //$this->db->where('empl_business',$this->business);
        //$this->db->where('empl_branch',$this->branch);
        $this->db->update('payrolls_employee_liabilities',$data);
        return $this->db->affected_rows();
      }

      public function deleteEmployeeLiability($liability){
        $this->db->where('empl_key',$liability);
        //$this->db->where('empl_business',$this->business);
        //$this->db->where('empl_branch',$this->branch);
        $this->db->delete('payrolls_employee_liabilities');
        return $this->db->affected_rows();
      }

      public function employeeLiabilityDetails($liability){
        $this->db->where('empl_key',$liability);
        //$this->db->where('empl_business',$this->business);
        //$this->db->where('empl_branch',$this->branch);
        $query = $this->db->get('payrolls_employee_liabilities');
        return $query->num_rows()>0 ? $query->row() : false;
      }

      public function employeeLiabilities(){
          $this->db->order_by('empl_id','DESC');
          //$this->db->where('empl_branch',$this->branch);
          //$this->db->where('empl_business',$this->business);
          $query = $this->db->get('payrolls_employee_liabilities');
          return ($query->num_rows()>0)? $query->result_array(): FALSE;
        }

    public function processPayroll($employee, $data){
        /** This is the core function for processing payroll data **/

        /** Start Transaction **/
       $this->db->trans_start();

        if(!empty($data)){
            $data['payroll_branch'] = $this->branch;
            $data['payroll_business'] = $this->business;
            $this->db->insert('employees_payroll', $data);
            $id = $this->db->insert_id();

            $sessions = !empty($_SESSION['allowances']) ? $_SESSION['allowances']: false;
            if(!empty($sessions)){
                $dedus = array();
                foreach ($sessions as $key => $session){
                    $dedus['allowance_value'] = $session['allowance_value'];
                    $dedus['allowance_value_amount'] = $session['allowance_value'];
                    $dedus['allowance_key'] = $session['allowance_key'];
                    $dedus['allowance_employee'] = $employee;
                    $dedus['allowance_branch'] = $this->branch;
                    $dedus['allowance_business'] = $this->business;
                    $dedus['allowance_payroll'] = $id;
                    $this->db->insert('employees_allowances', $dedus);
                }
            }

            /**
            $sessions = !empty($_SESSION['benefits']) ? $_SESSION['benefits']: false;
            if(!empty($sessions)){
                $dedus = array();
                foreach ($sessions as $key => $session){
                    $dedus['benefit_value'] = $session['benefit_value'];
                    $dedus['benefit_key'] = $session['benefit_key'];
                    $dedus['benefit_employee'] = $employee;
                    $dedus['benefit_branch'] = $this->branch;
                    $dedus['benefit_business'] = $this->business;
                    $this->db->insert('employees_benefits',$dedus);
                }
            }
            **/

            $sessions = !empty($_SESSION['insurance']) ? $_SESSION['insurance']: false;
            if(!empty($sessions)){
                $flag = $data['payroll_basic_salary'];
                $dedus = array();
                foreach ($sessions as $key => $session){
                    $percent = $session['pr_employee_cost']/100;
                    $value = $data['payroll_gross_salary'] * $percent;
                    $percentC = $session['pr_company_cost']/100;
                    $valueC = $data['payroll_gross_salary'] * $percentC;
                    $flag = $flag - $value;
                    $dedus['insurance_key'] = $session['pr_insurer'];
                    $dedus['insurance_employee'] = $employee;
                    $dedus['employee_cost'] = $session['pr_employee_cost'];
                    $dedus['employee_cost_amount'] = $value;
                    $dedus['company_cost'] = $session['pr_company_cost'];
                    $dedus['company_cost_amount'] = $valueC;
                    $dedus['insurance_branch'] = $this->branch;
                    $dedus['insurance_business'] = $this->business;
                    $dedus['insurance_payroll'] = $id;
                    $this->db->insert('employees_insurance',$dedus);
                }
            }

            $sessions = !empty($_SESSION['deductions']) ? $_SESSION['deductions']: false;
            if(!empty($sessions)){
                $deductions = 0;
                $dedus = array();
                foreach ($sessions as $key => $session){

                    if($session['deduction_type'] == 'percent'){
                        $percent = $session['deduction_value']/100;
                        $dedus['emp_deduction_employee'] = $employee;
                        $dedus['emp_deduction_key'] = $session['deduction_key'];
                        $dedus['emp_deduction_value'] = $session['deduction_value'];
                        $dedus['emp_deduction_value_amount'] = $data['payroll_gross_salary'] * $percent;
                    }else{
                        $dedus['emp_deduction_employee'] = $employee;
                        $dedus['emp_deduction_key'] = $session['deduction_key'];
                        $dedus['emp_deduction_value'] = $session['deduction_value'];
                        $dedus['emp_deduction_value_amount'] = $session['deduction_value'];
                    }
                    $dedus['emp_deduction_branch'] = $this->branch;
                    $dedus['emp_deduction_business'] = $this->business;
                    $dedus['emp_deduction_payroll'] = $id;
                    $this->db->insert('employees_deductions',$dedus);

                }
            }
        }
       $this->db->trans_complete();
       return $this->db->trans_status();
     }

    public function processPayroll1($employee,$salary,$netTax,$taxes,$netVariables,$netVariable){
       $this->db->trans_start();

       $payable = $salary + $netVariables - $netTax;
       $pye = payePercent($payable);
       $py = $payable * ($pye->paye_percent/100);
       $th = $payable - $py;

       $paydata['payroll_net_salary'] = $salary;
       $paydata['payroll_employee'] = $employee;
       $paydata['payroll_date'] = date('Y-m-d');
       $this->db->insert('employees_payroll',$paydata);
       $payrollId = $this->db->insert_id();

       if($pye){
         $paye['pd_y_paye'] = $pye->paye_key;
         $paye['pd_y_amount'] = $py;
         $paye['pd_y_payroll'] = $payrollId;
         $this->db->insert('payroll_data_paye',$paye);
       }

       if(!empty($netVariable)){
         foreach ($netVariable as $v => $variable) {
           $dataVariable['pd_v_amount'] = $variable['pd_v_amount'];
           $dataVariable['pd_v_variable'] = $variable['pd_v_variable'];
           $dataVariable['pd_v_payroll'] = $payrollId;;
           $this->db->insert('payroll_data_variables',$dataVariable);
         }
      }


      if(!empty($taxes)){
         foreach ($taxes as $t => $tax) {
           $dataTax['pd_t_tax'] = $tax['pd_t_tax'];
           $dataTax['pd_t_amount'] = $tax['pd_t_amount'];
           $dataTax['pd_t_payroll'] = $payrollId;
           $this->db->insert('payroll_data_taxes',$dataTax);
         }
       }

       $this->db->trans_complete();
       return $this->db->trans_status();
     }

    public function employeesPayrolls($employee){
        $this->db->select('*');
        $this->db->select_sum('pd_t_amount','total_tax');
        $this->db->select_sum('pd_v_amount','total_variable');
        $this->db->order_by('payroll_id','DESC');
        $this->db->group_by('payroll_id');
        $this->db->join('users_details ud','ud.user_key=payroll_employee','left');
        $this->db->join('payroll_data_taxes','payroll_data_taxes.pd_t_payroll=payroll_id','left');
        $this->db->join('payroll_data_variables','payroll_data_variables.pd_v_payroll=payroll_id','left');
        $this->db->where('payroll_employee',$employee);
        $query = $this->db->get('employees_payroll');
        return ($query->num_rows()>0)? $query->result_array(): FALSE;
      }

    public function payroll($payrollId){
      $this->db->select('*');
      $this->db->select_sum('pd_t_amount','total_tax');
      $this->db->select_sum('pd_v_amount','total_variable');
      $this->db->order_by('payroll_id','DESC');
      $this->db->group_by('payroll_id');
      $this->db->join('users_details','users_details.user_key=payroll_employee','left');
      $this->db->join('payroll_data_taxes','payroll_data_taxes.pd_t_payroll=payroll_id','left');
      $this->db->join('payroll_data_variables','payroll_data_variables.pd_v_payroll=payroll_id','left');
      //$this->db->where('payroll_id',$payrollId);
      $this->db->where('payroll_employee',$payrollId);
      $query = $this->db->get('employees_payroll');
      return ($query->num_rows()>0)? $query->row(): FALSE;
    }

    public function get_payrolls($employee){
        $this->db->select('*');
        $this->db->order_by('payroll_id','DESC');
        $this->db->where('payroll_employee', $employee);
        $query = $this->db->get('employees_payroll');
        return ($query->num_rows()>0)? $query->row(): FALSE;
    }

    public function payrolls(){
      $this->db->select('*');
      $this->db->select_sum('pd_t_amount','total_tax');
      $this->db->select_sum('pd_v_amount','total_variable');
      $this->db->order_by('payroll_id','DESC');
      $this->db->group_by('payroll_id');
      $this->db->join('users_details','users_details.user_key=payroll_employee','left');
      $this->db->join('payroll_data_taxes','payroll_data_taxes.pd_t_payroll=payroll_id','left');
      $this->db->join('payroll_data_variables','payroll_data_variables.pd_v_payroll=payroll_id','left');
      $query = $this->db->get('employees_payroll');
      return ($query->num_rows()>0)? $query->result_array(): FALSE;
    }


    public function payes() {
      $this->db->order_by('paye_id','DESC');
      $this->db->where('paye_branch',$this->branch);
      $this->db->where('paye_business',$this->business);
      $query = $this->db->get('payroll_paye');
      return ($query->num_rows()>0)? $query->result_array(): FALSE;
    }

    public function newPAYE($paye) {
      $paye['paye_key'] = $this->payeKey();
      $paye['paye_branch'] = $this->branch;
      $paye['paye_business'] = $this->business;
        $this->db->limit(1)
          ->insert('payroll_paye',$paye);
        return ($this->db->affected_rows()==1)? TRUE : FALSE;
    }

    public function updatePAYE($payeKey,$paye) {
      $this->db->where('paye_key',$payeKey);
      $this->db->where('paye_business',$this->business);
        $this->db->limit(1)
          ->update('payroll_paye',$paye);
        return ($this->db->affected_rows()==1)? TRUE : FALSE;
    }

    public function payeDetails($payeKey) {
      $this->db->where('paye_key',$payeKey);
      $this->db->where('paye_business',$this->business);
      $query = $this->db->get('payroll_paye');
      return ($query->num_rows()>0)? $query->row(): FALSE;
    }

    public function taxDetails($taxKey) {
      $this->db->where('payroll_tax_key',$taxKey);
      $this->db->where('payroll_tax_business',$this->business);
      $this->db->join('payroll_tax_group','payroll_tax_group.tax_group_key='.'payroll_taxes.payroll_tax_group','left');
      $query = $this->db->get('payroll_taxes');
      return ($query->num_rows()>0)? $query->row(): FALSE;
    }

    public function taxClasses() {
      $this->db->order_by('tax_group_id','DESC');
      $this->db->where('tax_group_business',$this->business);
      $query = $this->db->get('payroll_tax_group');
      return ($query->num_rows()>0)? $query->result_array(): FALSE;
    }

    public function newTax($tax) {
      $tax['payroll_tax_key'] = $this->taxKey();
      $tax['payroll_tax_branch'] = $this->branch;
      $tax['payroll_tax_business'] = $this->business;
        $this->db->limit(1)
          ->insert('payroll_taxes',$tax);
        return ($this->db->affected_rows()==1)? TRUE : FALSE;
    }

    public function updateTax($taxKey,$tax) {
      $this->db->where('payroll_tax_key',$taxKey);
      $this->db->where('payroll_tax_business',$this->business);
        $this->db->update('payroll_taxes',$tax);
        if($this->db->affected_rows()> 0){
          $log = array(
            'log_message' => 'Delete Tax',
            'log_details' => 'Tax updated successfully',
            'log_activity' => $taxKey
          );
          $this->logActivity($log);
            return TRUE;
          }else{
            $log = array(
              'log_message' => 'Update Tax',
              'log_details' => 'Failed to update Tax',
              'log_activity' => ''
            );
            $this->logActivity($log);
            return FALSE;
        }
    }

    public function deleteTax($tax) {
      $this->db->where('payroll_tax_key',$tax);
      $this->db->where('payroll_tax_business',$this->business);
        $this->db->delete('payroll_taxes');
        if($this->db->affected_rows()> 0){
          $log = array(
            'log_message' => 'Delete Tax',
            'log_details' => 'Tax deleted successifully',
            'log_activity' => $tax
          );
          $this->logActivity($log);
            return TRUE;
          }else{
            $log = array(
              'log_message' => 'Create Tax',
              'log_details' => 'Failed to delete Tax',
              'log_activity' => ''
            );
            $this->logActivity($log);
            return FALSE;
        }
    }

    public function deletePayroll($payrollId) {
      $this->db->where('payroll_id',$payrollId);
        $this->db->delete('employees_payroll');
        if($this->db->affected_rows()> 0){
            return TRUE;
          }else{
            return FALSE;
        }
    }

    public function deletePaye($tax) {
      $this->db->where('paye_key',$tax);
      $this->db->where('paye_business',$this->business);
        $this->db->delete('payroll_paye');
        if($this->db->affected_rows()> 0){
          $log = array(
            'log_message' => 'Delete PAYE',
            'log_details' => 'PAYE deleted successifully',
            'log_activity' => $tax
          );
          $this->logActivity($log);
            return TRUE;
          }else{
            $log = array(
              'log_message' => 'Delete PAYE',
              'log_details' => 'Failed to delete PAYE',
              'log_activity' => ''
            );
            $this->logActivity($log);
            return FALSE;
        }
    }

    public function taxes() {
        $this->db->order_by('payroll_tax_id','DESC');
        $this->db->where('payroll_tax_business',$this->business);
        $this->db->join('payroll_tax_group','payroll_tax_group.tax_group_key='.'payroll_taxes.payroll_tax_group','left');
        $query = $this->db->get('payroll_taxes');
        return ($query->num_rows()>0)? $query->result_array(): FALSE;
    }

    public function paye() {
        $this->db->order_by('paye_id','DESC');
        $this->db->where('paye_business',$this->business);
        $query = $this->db->get('paye');
        return ($query->num_rows()>0)? $query->result_array(): FALSE;
    }

    public function taxKey(){
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'payroll_tax_key', $random_unique_int )
            ->get_where( 'payroll_taxes' );

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->taxKey();
        }

        return $random_unique_int;
    }

    public function payeKey(){
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'paye_key', $random_unique_int )
            ->get_where( 'payroll_paye' );

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->payeKey();
        }

        return $random_unique_int;
    }

    public function companyLiabilityKey(){
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'ctc_key', $random_unique_int )
            ->get_where( 'payrolls_company_liabilities' );

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->companyLiabilityKey();
        }

        return $random_unique_int;
    }

    public function employeeLiabilityKey(){
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'empl_key', $random_unique_int )
            ->get_where( 'payrolls_employee_liabilities' );

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->employeeLiabilityKey();
        }

        return $random_unique_int;
    }

    public function getPayroll($key, $when='') {
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenFr($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where($this->filterable_date_field.'>=',$dates['start']);
            $this->db->where($this->filterable_date_field.'<=',$dates['end']);
        }

        $this->db->select('*');
        $this->db->select_sum('allowance_value');
        $this->db->select_sum('emp_deduction_value');
        $this->db->order_by('payroll_id','DESC');
        $this->db->group_by('payroll_id');
        $this->db->where('payroll_employee', $key);
        $this->db->where('payroll_deleted', 0);
        $this->db->join('employees_allowances','allowance_payroll=payroll_id','left');
        $this->db->join('employees_deductions','emp_deduction_payroll=payroll_id','left');
        $this->db->join('employees_insurance','insurance_payroll=payroll_id','left');
        $this->db->join('users_details','user_key=payroll_employee','left');
        $query = $this->db->get( 'employees_payroll' );
        return $query->result_array();
    }

    public function get_payslip($key){
        $this->db->select('*');
        $this->db->where('payroll_id', $key);
        $this->db->where('payroll_deleted', 0);
        $this->db->join('employees_allowances','allowance_payroll=payroll_id','left');
        $this->db->join('employees_deductions','emp_deduction_payroll=payroll_id','left');
        $this->db->join('employees_insurance','insurance_payroll=payroll_id','left');
        $this->db->join('users_details','user_key=payroll_employee','left');
        $query = $this->db->get('employees_payroll');
        return ($query->num_rows()>0)? $query->row(): FALSE;
    }

    public function get_allowance($key){
        $this->db->select('*');
        $this->db->where('allowance_payroll', $key);
        $this->db->join('payroll_allowances','pr_allowance_key=allowance_key','left');
        $query = $this->db->get('employees_allowances');
        return ($query->num_rows()>0)? $query->result_array(): FALSE;
    }

    public function get_deduction($key){
        $this->db->select('*');
        $this->db->where('emp_deduction_payroll', $key);
        $this->db->join('payroll_deductions','deduction_key=emp_deduction_key','left');
        $query = $this->db->get('employees_deductions');
        return ($query->num_rows()>0)? $query->result_array(): FALSE;
    }

    public function get_insurance($key){
        $this->db->select('*');
        $this->db->where('insurance_payroll', $key);
        $this->db->join('payroll_insurance','pr_insurance_key=insurance_key','left');
        $query = $this->db->get('employees_insurance');
        return ($query->num_rows()>0)? $query->result_array(): FALSE;
    }

}
