<?php

class DeductionsModel extends My_model {

    public function __construct() {
        parent::__construct();
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    public function deductions() {
      $this->db->order_by('deduction_id','DESC');
      $this->db->where('deduction_business',$this->business);
      $this->db->where('deduction_branch',$this->branch);
      $query = $this->db->get('payroll_deductions');
      return ($query->num_rows()>0)? $query->result_array(): FALSE;
    }

    public function newDeduction($deduction) {
      $deduction['deduction_key'] = $this->deductionKey();
      $deduction['deduction_branch'] = $this->branch;
      $deduction['deduction_business'] = $this->business;
        $this->db->limit(1)
          ->insert('payroll_deductions',$deduction);
        return ($this->db->affected_rows()>0)? TRUE : FALSE;
    }

    public function updateDeduction($deductionKey,$deduction) {
      $this->db->where('deduction_key',$deductionKey);
      $this->db->where('deduction_key',$deductionKey);
      $this->db->where('deduction_branch',$this->branch);
        $this->db->limit(1)
          ->update('payroll_deductions',$deduction);
        return ($this->db->affected_rows()>0)? TRUE : FALSE;
    }

    public function deductionDetails($deductionKey) {
      $this->db->where('deduction_key',$deductionKey);
      $this->db->where('deduction_key',$deductionKey);
      $this->db->where('deduction_branch',$this->branch);
      $query = $this->db->get('payroll_deductions');
      return ($query->num_rows()>0)? $query->row(): FALSE;
    }

    public function deleteDeduction($deductionKey) {
      $this->db->where('deduction_key',$deductionKey);
      $this->db->where('deduction_business',$this->business);
      $this->db->where('deduction_branch',$this->branch);
      $this->db->delete('payroll_deductions');
      return ($this->db->affected_rows()>0)? TRUE : FALSE;
    }


    public function deductionKey(){
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'deduction_key', $random_unique_int )
            ->get_where( 'payroll_deductions' );

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->deductionKey();
        }

        return $random_unique_int;
    }


}
