<?php

class BenefitsModel extends My_model {

    public function __construct() {
        parent::__construct();
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    public function benefits() {
      $this->db->order_by('benefit_id','DESC');
      $this->db->where('benefit_business',$this->business);
      $this->db->where('benefit_branch',$this->branch);
      $query = $this->db->get('payroll_benefits');
      return ($query->num_rows()>0)? $query->result_array(): FALSE;
    }

    public function newBenefit($benefit) {
      $benefit['benefit_key'] = $this->benefitKey();
      $benefit['benefit_branch'] = $this->branch;
      $benefit['benefit_business'] = $this->business;
        $this->db->limit(1)
          ->insert('payroll_benefits',$benefit);
        return ($this->db->affected_rows()>0)? TRUE : FALSE;
    }

    public function updateBenefit($benefitKey,$benefit) {
      $this->db->where('benefit_key',$benefitKey);
      $this->db->where('benefit_key',$benefitKey);
      $this->db->where('benefit_branch',$this->branch);
        $this->db->limit(1)
          ->update('payroll_benefits',$benefit);
        return ($this->db->affected_rows()>0)? TRUE : FALSE;
    }

    public function benefitDetails($benefitKey) {
      $this->db->where('benefit_key',$benefitKey);
      $this->db->where('benefit_key',$benefitKey);
      $this->db->where('benefit_branch',$this->branch);
      $query = $this->db->get('payroll_benefits');
      return ($query->num_rows()>0)? $query->row(): FALSE;
    }

    public function deleteBenefit($benefitKey) {
      $this->db->where('benefit_key',$benefitKey);
      $this->db->where('benefit_business',$this->business);
      $this->db->where('benefit_branch',$this->branch);
      $this->db->delete('payroll_benefits');
      return ($this->db->affected_rows()>0)? TRUE : FALSE;
    }

    public function benefitKey(){
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'benefit_key', $random_unique_int )
            ->get_where( 'payroll_benefits' );

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->benefitKey();
        }

        return $random_unique_int;
    }


}
