<?php

class AllowancesModel extends My_model {

    public function __construct() {
        parent::__construct();
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    public function allowances() {
      $this->db->order_by('pr_allowance_id','DESC');
      $this->db->where('pr_allowance_business',$this->business);
      $this->db->where('pr_allowance_branch',$this->branch);
      $query = $this->db->get('payroll_allowances');
      return ($query->num_rows()>0)? $query->result_array(): FALSE;
    }

    public function newAllowance($allowance) {
      $allowance['pr_allowance_key'] = $this->allowanceKey();
      $allowance['pr_allowance_branch'] = $this->branch;
      $allowance['pr_allowance_business'] = $this->business;
        $this->db->limit(1)
          ->insert('payroll_allowances',$allowance);
        return ($this->db->affected_rows()>0)? TRUE : FALSE;
    }

    public function updateAllowance($allowanceKey,$allowance) {
      $this->db->where('pr_allowance_key',$allowanceKey);
      $this->db->where('pr_allowance_key',$allowanceKey);
      $this->db->where('pr_allowance_branch',$this->branch);
        $this->db->limit(1)
          ->update('payroll_allowances',$allowance);
        return ($this->db->affected_rows()>0)? TRUE : FALSE;
    }

    public function allowanceDetails($allowanceKey) {
      $this->db->where('pr_allowance_key',$allowanceKey);
      $this->db->where('pr_allowance_key',$allowanceKey);
      $this->db->where('pr_allowance_branch',$this->branch);
      $query = $this->db->get('payroll_allowances');
      return ($query->num_rows()>0)? $query->row(): FALSE;
    }

    public function deleteAllowance($allowanceKey) {
      $this->db->where('pr_allowance_key',$allowanceKey);
      $this->db->where('pr_allowance_business',$this->business);
      $this->db->where('pr_allowance_branch',$this->branch);
      $this->db->delete('payroll_allowances');
      return ($this->db->affected_rows()>0)? TRUE : FALSE;
    }


    public function allowanceKey(){
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'pr_allowance_key', $random_unique_int )
            ->get_where( 'payroll_allowances' );

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->allowanceKey();
        }

        return $random_unique_int;
    }

}
