<?php

class TitlesModel extends MY_Model {
    public $branch;
    public $business;

 public function __construct() {
        parent::__construct();
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

public function categoryActions($category) {
      $this->db->order_by('category_id');
    //  $this->db->where('category_branch',$this->branch);
      $this->db->where('category_business',$this->business);
      $this->db->where('category_key',$this->business);
      $query = $this->db->get( 'acl_categories' );
      return $query->num_rows()>0 ? $query->result_array() : FALSE;
     }

  public function categories() {
    $this->db->order_by('category_id');
    //$this->db->where('category_branch',$this->branch);
    $this->db->where('category_business',$this->business);
    $query = $this->db->get( 'acl_categories' );
    return $query->num_rows()>0 ? $query->result_array() : FALSE;
   }

 public function category($key) {
   //$this->db->where('category_branch',$this->branch);
   $this->db->where('category_business',$this->business);
      $query = $this->db->select( '*' )
        ->where('category_key',$key)->get('acl_categories');
    return ($query->num_rows()>0)? $query->row() : FALSE;
  }

  public function categoryUpdate($key,$data){
  //  $this->db->where('category_branch',$this->branch);
    $this->db->where('category_business',$this->business);
    $this->db->limit(1)
      ->where('category_key=',$key)
      ->update('acl_categories',$data );
      return ($this->db->affected_rows()== 1)? TRUE :FALSE;
  }

  public function categoryRegister($category) {
    $category['category_key'] = $this->category_key();
    $category['category_branch'] = $this->branch;
    $category['category_business'] = $this->business;
   // $category['category_actions'] = optionActions('Title',$category['category_key']);
      $this->db->limit(1)
        ->insert('acl_categories',$category);
      return ($this->db->affected_rows()==1)? TRUE : FALSE;
  }

  public function deleteTitle($key) {
    $this->db->where('category_branch',$this->branch);
    $this->db->where('category_business',$this->business);
      $this->db->limit(1)
        ->where('category_key=',$key)
        ->delete('acl_categories');
      return ($this->db->affected_rows()==1)? TRUE :FALSE;
  }

 public function category_key()
    {
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'category_key', $random_unique_int )
            ->get_where( 'acl_categories');

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->category_key();
        }

        return $random_unique_int;
    }

}
