<?php
require_once APPPATH.'models/BMS_Model.php';

class FreightsModel extends BMS_Model
{
    protected $branch_field = "fr_branch";
    protected $branch;
    protected $business_field = 'fr_business';
    protected $business;

    protected $filterable_date_field = 'fr_created_on';

    protected $table_name   = 'freights';
    protected $key          = 'fr_key';
    protected $primary_key  = 'fr_key';
    protected $soft_deletes = TRUE;
    protected $date_format  = 'datetime';
    protected $log_user     = TRUE;

    public    $selectable_fields = array('user_key','country_key','fr_category_key','fr_cl_plan','fr_plan_name',
        'fr_category_name','firstname','lastname','country_name','fr_status','fr_id','fr_key','fr_declaration_type','fr_branch','fr_business','fr_created_by',
        'fr_modified_by','fr_created_on','fr_modified_on','fr_deleted','fr_deleted_by','fr_processing_office','fr_transad_number','fr_transad_date',
        'fr_number_of_items','fr_receipt_number','fr_receipt_date','fr_country_last_consignment',
        'fr_trading_country','fr_country_of_export','fr_importer','fr_exporter','fr_country_of_destination','fr_delivery_term_code','fr_delivery_place',
        'fr_nature_of_transport','fr_exchange_rate','fr_exchange_currency','fr_total_invoice_value','fr_invoice_number','fr_invoice_date','fr_valuation_note',
        'fr_freight_charges','fr_freight_currency','fr_insurance','fr_insurance_currency','fr_other_charges','fr_other_currency','fr_deductions',
        'fr_deductions_currency','fr_number_of_packages','fr_gross_weight','fr_net_weight','fr_entry_office','fr_exit_office',
        'fr_location_goods','fr_category_of_goods','fr_shipping_order','fr_agent_reference_number','fr_security_account_number',

        'fr_de_freight_key','fr_de_currency', 'fr_de_total_fob','fr_de_freight','fr_de_insurance','fr_de_other_charges','fr_de_deductions',
        'fr_de_customs_value','fr_de_item_no', 'fr_de_description','fr_de_hs_code','fr_de_value_for_customs','fr_de_fob_value','fr_de_model',
        'fr_de_specification','fr_de_component', 'fr_de_quantity','fr_de_unit_price','fr_de_item_invoice_price',

        'fr_av_freight_key','fr_av_currency', 'fr_av_total_fob','fr_av_freight','fr_av_insurance','fr_av_other_charges','fr_av_deductions',
        'fr_av_customs_value', 'fr_av_item_no', 'fr_av_description','fr_av_hs_code','fr_av_value_for_customs','fr_av_fob_value','fr_av_model',
        'fr_av_specification', 'fr_av_component', 'fr_av_quantity','fr_av_unit_price','fr_av_item_invoice_price',

        'doc_fr_key','doc_key','doc_name','doc_description','doc_file','doc_type');

    protected $set_created  = TRUE;
    protected $created_field    = 'fr_created_on';
    protected $created_by_field = 'fr_created_by';

    protected $set_modified     = TRUE;
    protected $modified_field   = 'fr_modified_on';
    protected $modified_by_field = 'fr_modified_by';

    protected $soft_delete_key    = 'fr_deleted';
    protected $deleted_by_field = 'fr_deleted_by';

    // Observers
    protected $before_insert    = array('set_key','set_ownership');
    protected $after_insert     = array();
    protected $before_update    = array();
    protected $after_update     = array();
    protected $before_find      = array('set_join','set_selectable_fields','set_select_dates','set_ownership_select');
    protected $after_find       = array();
    protected $before_delete    = array();
    protected $after_delete     = array();

    protected $return_type      = 'array';
    protected $protected_attributes   = array();

    protected $validation_rules         = array();
    protected $insert_validation_rules  = array();
    protected $skip_validation          = true;

    public function __construct(&$write_db = null, &$read_db = null)
    {
        parent::__construct($write_db, $read_db);
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    protected function set_key($row){

        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( $this->key, $random_unique_int )
            ->get_where( $this->table_name );

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->taxClassKey();
        }

        if (!array_key_exists($this->key, $row))
        {
            $row[$this->key] = $random_unique_int;
        }

        return $row;
    }

    protected function set_ownership($row){

        if(!empty($this->business)){
            $row[$this->business_field] = $this->business;
        }

        if(!empty($this->branch)){
            $row[$this->branch_field] = $this->branch;
        }

        return $row;
    }

    protected function set_created_by($row)
    {
        if (!array_key_exists($this->created_by_field, $row))
        {
            $row[$this->created_by_field] = config_item("auth_user_id");
        }

        return $row;
    }

    protected function set_deleted_by($id)
    {
        $this->dbw->where($this->primary_key, $id);
        $this->db->update($this->table_name, [$this->deleted_by_field => config_item("auth_user_id")]);
    }

    protected function set_modified_by($row)
    {
        if (!array_key_exists($this->modified_by_field, $row))
        {
            $row[$this->modified_by_field] = config_item("auth_user_id");
        }

        return $row;
    }

    protected function set_modified_on($row)
    {
        if (!array_key_exists($this->modified_field, $row))
        {
            $row[$this->modified_field] = date('Y-m-d H:m:i');
        }

        return $row;
    }

    protected function set_selectable_fields()
    {
        if(!empty($this->selectable_fields)){
            $this->db->select($this->selectable_fields);
        }

    }

    protected function set_select_dates(){
        if(!empty($when = $this->input->get("when"))){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where($this->filterable_date_field.'>=',$dates['start']);
            $this->db->where($this->filterable_date_field.'<=',$dates['end']);
        }
    }

    protected function set_join(){
        $this->db->join('countries','country_key=fr_country_of_destination','left');
        $this->db->join('users_details','user_key=fr_importer','left');
        $this->db->join('freight_categories','fr_category_key=fr_category_of_goods','left');
        $this->db->join('freight_plans','fr_plan_key=fr_cl_plan','left');
        $this->db->join('freight_declared_valuation','fr_de_freight_key=fr_key','left');
        $this->db->join('freight_accessed_valuation','fr_av_freight_key=fr_key','left');
        $this->db->join('freight_document','doc_fr_key=fr_key','left');
    }

    protected function set_ownership_select(){
        $this->db->where($this->business_field,$this->business);
        $this->db->where($this->branch_field,$this->branch);
    }

    protected function publish_event(){
        publishEventFlash('data-table-refresh');
    }

    protected function set_limit_offset(){
        if(!empty($when = $this->input->get("when"))){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where($this->filterable_date_field.'>=',$dates['start']);
            $this->db->where($this->filterable_date_field.'<=',$dates['end']);
        }
    }
}