<?php

class RequestModel extends MY_Model {

    public $branch;
    public $business;

    public function __construct() {
        parent::__construct();
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    public function createRequest1($request) {
        $request['petty_request_key'] = $this->pettyRequestkey();
        $request['petty_request_business_key'] = $this->business;
        $request['petty_request_branch_key'] = $this->branch;
        $this->db->limit(1)
            ->insert('petty_request',$request);
        return ($this->db->affected_rows()==1)? TRUE : FALSE;
    }

    public function createRequest($request,$freightKey) {
        $this->db->trans_start();

        $payStatus['freight_task_payment'] = 'REQUESTED';
        $this->db->limit(1)
            ->where('freight_task_key=',$freightKey)
            ->update('freight_task',$payStatus);
        $request['petty_request_key'] = $this->pettyRequestkey();
        $request['petty_request_business_key'] = $this->business;
        $request['petty_request_branch_key'] = $this->branch;
        $this->db->limit(1)
            ->insert('petty_request',$request);
        $this->db->trans_complete();
        return $this->db->trans_status();
    }

    public function unapproved_request($when='') {
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('petty_request_date_created >=',$dates['start']);
            $this->db->where('petty_request_date_created <=',$dates['end']);
        }

        $this->db->select('*');
        $this->db->order_by('petty_request_id','DESC');
        $this->db->where('petty_request_branch_key',$this->branch);
        $this->db->where('petty_request_business_key',$this->business);
        $this->db->where('petty_request_status','UnApproved')
                 ->or_where('petty_request_status','Rejected');
        $this->db->select('DATE_FORMAT(petty_request_date_created, "%m/%d/%Y") as joined', FALSE);
        $query = $this->db
            ->join('users_details','users_details.user_key=petty_request.petty_request_payee','left')
            ->get( 'petty_request' );
        return $query->result_array();
    }

    public function approved_request($when='') {
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('petty_request_date_created >=',$dates['start']);
            $this->db->where('petty_request_date_created <=',$dates['end']);
        }

        $this->db->select('*');
        $this->db->order_by('petty_request_id','DESC');
        $this->db->where('petty_request_branch_key',$this->branch);
        $this->db->where('petty_request_business_key',$this->business);
        $this->db->where('petty_request_status','Approved');
        $this->db->select('DATE_FORMAT(petty_request_date_created, "%m/%d/%Y") as joined', FALSE);
        $query = $this->db
            ->join('users_details','users_details.user_key=petty_request.petty_request_payee','left')
            ->get( 'petty_request' );
        return $query->result_array();
    }

    public function my_request($when,$auth_user_id) {
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('petty_request_date_created >=',$dates['start']);
            $this->db->where('petty_request_date_created <=',$dates['end']);
        }

        $this->db->select('*');
        $this->db->order_by('petty_request_id','DESC');
        $this->db->where('petty_request_branch_key',$this->branch);
        $this->db->where('petty_request_business_key',$this->business);
        $this->db->where('petty_request_by',$auth_user_id);
        $this->db->select('DATE_FORMAT(petty_request_date_created, "%m/%d/%Y") as joined', FALSE);
        $query = $this->db
            ->join('users_details','users_details.user_key=petty_request.petty_request_payee','left')
            ->get( 'petty_request' );
        return $query->result_array();
    }

    public function select_one_request($key){
        $this->db->join('users_details','users_details.user_key=petty_request.petty_request_payee','left');
        $query = $this->db->where('petty_request_key', $key)->from('petty_request')->get();
        return $query->row();
    }

    public function allRequestFile($key){
        $this->db->join('users_details','users_details.user_key=petty_request.petty_request_payee','left');
        $this->db->order_by('petty_request_date_created','DESC');
        $query = $this->db->where('petty_request_file_number', $key)->from('petty_request')->get();
        return ($query->num_rows()>=0) ? $query->result_array() : false;
    }

    public function requestApproveUpdate($requestKey,$data){
        $this->db->where('petty_request_business_key',$this->business);
        $this->db->limit(1)
            ->where('petty_request_key=',$requestKey)
            ->update('petty_request',$data );
        return ($this->db->affected_rows()== 1)? TRUE :FALSE;
    }

    public function all_freight_task() {
        $this->db->order_by('freight_task_id','DESC');
        $this->db->where('freight_task_business',$this->business)
            ->where('freight_task_status','Completed')
            ->where('freight_task_payment','UNPAID');
        $query = $this->db->get('freight_task','10');
        return $query->result_array();
    }

    public function all_freight_taskme($auth_user_id) {
        $this->db->order_by('freight_task_id','DESC');
        $this->db->where('freight_task_business',$this->business)
            ->where('freight_task_status','Completed')
            ->where('freight_task_payment','UNPAID')
            ->where('freight_task_employee_key', $auth_user_id);
        $query = $this->db->get('freight_task','10');
        return $query->result_array();
    }

    function rejectRequest($request,$data){
        $this->db->where('petty_request_key',$request);
        $this->db->update('petty_request',$data);
        if($this->db->affected_rows()>0){
            return true;
        }
        return false;
    }

    public function request_delete($key) {
        $this->db->where('petty_request_key',$key)
            ->delete( 'petty_request' );
        return $this->db->affected_rows();
    }

    public function pettyRequestkey(){
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );
        $query = $this->db->where( 'petty_request_key', $random_unique_int )->get_where( 'petty_request');
        if( $query->num_rows() > 0 ) {
            $query->free_result();
            return $this->pettyRequestkey();
        }
        return $random_unique_int;
    }

}