<?php
/**
 * Description of StocksModel
 *
 * @author Kelvin Benard
 * @email kelvin@lockminds.com
 */

class ExpensesTypesModelOld extends MY_Model{

    public function __construct() {
        parent::__construct();
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    function details($type){
        $this->db->select('*');
        $this->db->where('type_key',$type);
        $this->db->join('expenses exp','exp.expense_type=type_key','left');
        $this->db->select_sum('exp.expense_paid','type_spent');
        $this->db->select('DATE_FORMAT(type_created_at, "%m/%d/%Y") as type_date', FALSE);
        $query = $this->db->get("expense_types");
        return $query->num_rows()>0 ? $query->row() : false;
    }

    function types($when = ''){

        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('type_created_at >=',$dates['start']);
            $this->db->where('type_created_at <=',$dates['end']);
        }

        $this->db->select('*');
        $this->db->group_by('type_id');
        $this->db->select('DATE_FORMAT(type_created_at, "%m/%d/%Y") as type_date', FALSE);
        $this->db->join('expenses','expense_type=type_key','left');
        $this->db->join('expense_categories cat','cat.category_key=type_category','left');
        $this->db->select('SUM(DISTINCT expense_amount) as type_spent');
        $this->db->where('type_branch',$this->branch);
        $query = $this->db->get('expense_types');
        return $query->num_rows()>0 ? $query->result_array() : false;
    }


    function expendicture($type,$when = ''){
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_created_at >=',$dates['start']);
            $this->db->where('expense_created_at <=',$dates['end']);
        }

        $this->db->join('users_details ud','ud.user_key=expense_creator','left');
        $this->db->join('accounting_accounts ac','ac.account_id=expense_account','left');
        $this->db->join('expense_types et','et.type_key=expense_type','left');
        $this->db->select('*');
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS user');
        $this->db->select('DATE_FORMAT(expense_created_at, "%m/%d/%Y") as expense_date', FALSE);
        $this->db->where('expense_type',$type);
        $query = $this->db->get('expenses');
        return $query->num_rows()>0 ? $query->result_array() : false;
    }

    function totalExpenditure($type){
        $this->db->select('SUM(DISTINCT expense_paid) as total');
        $this->db->where('expense_type',$type);
        $query = $this->db->get('expenses');
        return $query->num_rows()>0 ? $query->row()->total : 0;
    }

    public function typeKey(){
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'type_key', $random_unique_int )
            ->get_where( 'expense_types' );

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->typeKey();
        }

        return $random_unique_int;
    }
}
