<?php
/**
 * Description of StocksModel
 *
 * @author Kelvin Benard
 * @email kelvin@lockminds.com
 */

class ExpensesCategoriesModelOld extends MY_Model{

    public function __construct() {
        parent::__construct();
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    function details($category){;
        $this->db->select('*');
        $this->db->where('category_key',$category);
        $this->db->join('expenses exp','exp.expense_category=category_key','left');
        $this->db->select('DATE_FORMAT(category_created_at, "%m/%d/%Y") as category_date', FALSE);
        $query = $this->db->get("expense_categories");
        return $query->num_rows()>0 ? $query->row() : false;
    }

    function categories($when = ''){

        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('category_created_at >=',$dates['start']);
            $this->db->where('category_created_at <=',$dates['end']);
        }

        $this->db->select('*');
        $this->db->select('dr.account_name');
        $this->db->group_by('category_id');
        $this->db->select('DATE_FORMAT(category_created_at, "%m/%d/%Y") as category_date', FALSE);
        $this->db->join('expenses','expense_category=category_key','left');
        $this->db->join('accounting_accounts cr','cr.account_key=expense_categories.category_credit_account','left');
        $this->db->join('accounting_accounts dr','dr.account_key=expense_categories.category_debit_account','left');
        $this->db->where('category_branch',$this->branch);
        $query = $this->db->get('expense_categories');
        return $query->num_rows()>0 ? $query->result_array() : false;
    }


    function expendicture($category,$when = ''){
        if(!empty($when)){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where('expense_created_at >=',$dates['start']);
            $this->db->where('expense_created_at <=',$dates['end']);
        }

        $this->db->join('users_details ud','ud.user_key=expenses.expense_creator','left');
        $this->db->join('accounting_accounts ac','ac.account_id=expenses.expense_account','left');
        $this->db->join('expense_types et','et.type_key=expense_type','left');
        $this->db->select('*');
        $this->db->select('CONCAT_WS(" ", firstname, lastname) AS user');
        $this->db->select('DATE_FORMAT(expense_created_at, "%m/%d/%Y") as expense_date', FALSE);
        $this->db->where('expense_category',$category);
        $query = $this->db->get('expenses');
        return $query->num_rows()>0 ? $query->result_array() : false;
    }

    function totalExpenditure($category){
        $this->db->select('SUM(DISTINCT expense_paid) as total');
        $this->db->where('expense_category',$category);
        $query = $this->db->get('expenses');
        return $query->num_rows()>0 ? $query->row()->total : 0;
    }

      function types($category){
        $this->db->where('type_category',$category);
        $query = $this->db->get('expense_types');
        return $query->num_rows()>0 ? $query->result_array() : false;
    }
    
    public function categoryKey(){
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'category_key', $random_unique_int )
            ->get_where( 'expense_categories' );

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->categoryKey();
        }

        return $random_unique_int;
    }
}
