<?php

class DocumentsModel extends MY_Model {

 public function __construct() {
        parent::__construct();
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    public function employeeDocuments($employee) {
      $this->db->order_by('document_id');
      $this->db->where('document_employee',$employee);
      $this->db->where('document_business',$this->business);
      $query = $this->db->get( 'employees_documents' );
      return $query->num_rows()>0 ? $query->result_array() : FALSE;
     }

  public function documents() {
    $this->db->order_by('document_id');
    $this->db->where('document_branch',$this->branch);
    $this->db->where('document_business',$this->business);
    $query = $this->db->get( 'customer_documents' );
    return $query->num_rows()>=0 ? $query->result_array() : FALSE;
   }

  public function documentEmployee($key) {
     $this->db->where('document_business',$this->business);
        $query = $this->db->select( '*' )
          ->where('document_key',$key)->get('employees_documents');
      return ($query->num_rows()>0)? $query->row() : FALSE;
    }

 public function document($key) {
   $this->db->where('document_branch',$this->branch);
   $this->db->where('document_business',$this->business);
      $query = $this->db->select( '*' )
        ->where('document_key',$key)->get('customer_documents');
    return ($query->num_rows()>0)? $query->row() : FALSE;
  }

  public function documentUpdate($key,$data){
    $this->db->where('document_branch',$this->branch);
    $this->db->where('document_business',$this->business);
    $this->db->limit(1)
      ->where('document_key=',$key)
      ->update('customer_documents',$data );
      return ($this->db->affected_rows()== 1)? TRUE :FALSE;
  }

  public function documentRegistereEmployee($document) {
    $document['document_key'] = $this->document_key();
      $this->db->limit(1)
        ->insert('employees_documents',$document);
      return ($this->db->affected_rows()==1)? TRUE : FALSE;
  }

  public function documentRegister($document) {
    $document['document_key'] = $this->document_key();
      $this->db->limit(1)
        ->insert('customer_documents',$document);
      return ($this->db->affected_rows()==1)? TRUE : FALSE;
  }
  public function documentDeleteEmployee($employee,$key) {
    $this->db->where('document_business',$this->business);
      $this->db->limit(1)
        ->where('document_key=',$key)
        ->where('document_employee=',$employee)
        ->delete('employees_documents');
      return ($this->db->affected_rows()==1)? TRUE :FALSE;
  }

    public function documentCustomer($key) {
        $query = $this->db->select( '*' )
            ->where('document_customer',$key)->get('customer_documents');
        return ($query->num_rows()>=0)? $query->result_array() : FALSE;
    }

  public function documentDelete($key) {
      $this->db->limit(1)
        ->where('document_key=',$key)
        ->delete('customer_documents');
      return ($this->db->affected_rows()==1)? TRUE :FALSE;
  }

 public function document_key()
    {
        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( 'document_key', $random_unique_int )
            ->get_where( 'customer_documents');

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->document_key();
        }

        return $random_unique_int;
    }

}
