<?php
require_once APPPATH.'models/BMS_Model.php';

class InboxModel extends BMS_Model
{
    protected $branch_field = "msg_branch";
    protected $branch;
    protected $business_field = 'msg_business';
    protected $business;

    protected $filterable_date_field = 'msg_created';

    protected $table_name   = 'comm_inbox';
    protected $key          = '';
    protected $primary_key  = 'msg_key';
    protected $soft_deletes = TRUE;
    protected $date_format  = 'datetime';
    protected $log_user     = TRUE;

    public    $selectable_fields = array('user_key','firstname','lastname','msg_id','msg_key','sender_id',
        'receiver_id','msg_subject','msg_body', 'msg_status','msg_created','is_receiver_marked','is_receiver_deleted','is_receiver_recycle',
        'is_sender_marked','is_sender_deleted','is_sender_recycle','msg_created_by','msg_modified_on','msg_modified_by', 'msg_deleted','msg_deleted_by',
        'msg_replied', 'msg_branch','msg_business',
        'rep_id','rep_msg_key','rep_created','rep_body','rep_created_by','rep_status','rep_modified_on','rep_modified_by','rep_deleted',
        'rep_deleted_by','rep_branch','rep_business');

    protected $set_created  = TRUE;
    protected $created_field    = 'msg_created';
    protected $created_by_field = 'msg_created_by';

    protected $set_modified     = TRUE;
    protected $modified_field   = 'msg_modified_on';
    protected $modified_by_field = 'msg_modified_by';

    protected $soft_delete_key    = 'msg_deleted';
    protected $deleted_by_field = 'msg_deleted_by';

    // Observers
    protected $before_insert    = array('set_ownership');
    protected $after_insert     = array();
    protected $before_update    = array();
    protected $after_update     = array();
    protected $before_find      = array('set_join','set_selectable_fields','set_select_dates','set_ownership_select');
    protected $after_find       = array();
    protected $before_delete    = array();
    protected $after_delete     = array();

    protected $return_type      = 'array';
    protected $protected_attributes   = array();

    protected $validation_rules         = array();
    protected $insert_validation_rules  = array();
    protected $skip_validation          = true;

    public function __construct(&$write_db = null, &$read_db = null)
    {
        parent::__construct($write_db, $read_db);
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    protected function set_key($row){

        // Create a random user id between 1200 and 4294967295
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );

        // Make sure the random user_id isn't already in use
        $query = $this->db->where( $this->key, $random_unique_int )
            ->get_where( $this->table_name );

        if( $query->num_rows() > 0 )
        {
            $query->free_result();

            // If the random user_id is already in use, try again
            return $this->taxClassKey();
        }

        if (!array_key_exists($this->key, $row))
        {
            $row[$this->key] = $random_unique_int;
        }

        return $row;
    }

    protected function set_ownership($row){

        if(!empty($this->business)){
            $row[$this->business_field] = $this->business;
        }

        if(!empty($this->branch)){
            $row[$this->branch_field] = $this->branch;
        }

        return $row;
    }

    protected function set_created_by($row)
    {
        if (!array_key_exists($this->created_by_field, $row))
        {
            $row[$this->created_by_field] = config_item("auth_user_id");
        }

        return $row;
    }

    protected function set_deleted_by($id)
    {
        $this->dbw->where($this->primary_key, $id);
        $this->db->update($this->table_name, [$this->deleted_by_field => config_item("auth_user_id")]);
    }

    protected function set_modified_by($row)
    {
        if (!array_key_exists($this->modified_by_field, $row))
        {
            $row[$this->modified_by_field] = config_item("auth_user_id");
        }

        return $row;
    }

    protected function set_modified_on($row)
    {
        if (!array_key_exists($this->modified_field, $row))
        {
            $row[$this->modified_field] = date('Y-m-d H:m:i');
        }

        return $row;
    }

    protected function set_selectable_fields()
    {
        if(!empty($this->selectable_fields)){
            $this->db->select($this->selectable_fields);
        }

    }

    protected function set_select_dates(){
        if(!empty($when = $this->input->get("when"))){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where($this->filterable_date_field.'>=',$dates['start']);
            $this->db->where($this->filterable_date_field.'<=',$dates['end']);
        }
    }

    protected function set_join(){
        $this->db->join('users_details','user_key=receiver_id','left');
        $this->db->join('comm_reply','rep_msg_key=msg_key','left');
    }

    protected function set_ownership_select(){
        $this->db->where($this->business_field,$this->business);
        $this->db->where($this->branch_field,$this->branch);
    }

    protected function publish_event(){
        publishEventFlash('data-table-refresh');
    }

    protected function set_limit_offset(){
        if(!empty($when = $this->input->get("when"))){
            $dates = array();
            $rawdates = datesWhenCustom($when);
            $dates['start'] = $rawdates['start'];
            $dates['end'] = $rawdates['end'];
            $this->db->where($this->filterable_date_field.'>=',$dates['start']);
            $this->db->where($this->filterable_date_field.'<=',$dates['end']);
        }
    }

    public function getInbox($limit, $start) {
        $user_key = profile()->user_key;
        $this->db->order_by('msg_created', 'DESC');
        $this->db->order_by('msg_status', 'unread');
        $this->db->where('receiver_id', $user_key);
        $this->db->where('is_receiver_deleted', 0);
        $this->db->where('is_receiver_recycle', 0);
        $this->db->limit($limit, $start);
        $query = $this->db->get('comm_inbox');
        return $query->num_rows()>0 ? $query->result_array() : FALSE;
    }

    public function getRepliedMsg($limit, $start) {
        $user_key = profile()->user_key;
        $this->db->order_by('msg_created', 'DESC');
        $this->db->where('sender_id', $user_key);
        $this->db->where('is_sender_deleted', 0);
        $this->db->where('is_sender_recycle', 0);
        $this->db->where('msg_replied', 1);
        $this->db->limit($limit, $start);
        $query = $this->db->get('comm_inbox');
        return $query->num_rows()>0 ? $query->result_array() : FALSE;
    }

    public function getMarkedInbox($limit, $start) {
        $user_key = profile()->user_key;
        $this->db->order_by('msg_modified_on', 'DESC');
        $this->db->where('receiver_id', $user_key);
        $this->db->where('is_receiver_deleted', 0);
        $this->db->where('is_receiver_recycle', 0);
        $this->db->where('is_receiver_marked', 1);
        $this->db->limit($limit, $start);
        $query = $this->db->get('comm_inbox');
        return $query->num_rows()>0 ? $query->result_array() : FALSE;
    }

    public function getMarkedReplies($limit, $start) {
        $user_key = profile()->user_key;
        $this->db->order_by('msg_modified_on', 'DESC');
        $this->db->where('sender_id', $user_key);
        $this->db->where('is_sender_deleted', 0);
        $this->db->where('is_sender_recycle', 0);
        $this->db->where('is_sender_marked', 1);
        $this->db->where('msg_replied', 1);
        $this->db->limit($limit, $start);
        $query = $this->db->get('comm_inbox');
        return $query->num_rows()>0 ? $query->result_array() : FALSE;
    }

    public function getTrashInbox($limit, $start) {
        $user_key = profile()->user_key;
        $this->db->order_by('msg_modified_on', 'DESC');
        $this->db->where('receiver_id', $user_key);
        $this->db->where('is_receiver_deleted', 1);
        $this->db->where('is_receiver_recycle', 0);
        $this->db->limit($limit, $start);
        $query = $this->db->get('comm_inbox');
        return $query->num_rows()>0 ? $query->result_array() : FALSE;
    }

    public function getTrashReplies($limit, $start) {
        $user_key = profile()->user_key;
        $this->db->order_by('msg_modified_on', 'DESC');
        $this->db->where('sender_id', $user_key);
        $this->db->where('is_sender_deleted', 1);
        $this->db->where('is_sender_recycle', 0);
        $this->db->where('msg_replied', 1);
        $this->db->limit($limit, $start);
        $query = $this->db->get('comm_inbox');
        return $query->num_rows()>0 ? $query->result_array() : FALSE;
    }
}