<?php


class SentList_model extends MY_Model
{
    function getSentList($email)
    {
        $this->db->select('*');
        $this->db->order_by('sent_at', 'DESC');
        //$this->db->where('sender_id',$email);
        $this->db->where('is_trash',0);
        $this->db->where('is_recycle',0);
        $this->db->where('status','sent');
        $query = $this->db->get('comm_sent');
        return $query->num_rows()>0 ? $query->result_array() : FALSE;
    }

    function getDraftedList($email)
    {
        $this->db->select('*');
        $this->db->order_by('sent_at', 'DESC');
        $this->db->where('sender_id',$email);
        //$this->db->where('is_trash',0);
       // $this->db->where('is_recycle',0);
        $this->db->where('status','drafted');
        $query = $this->db->get('comm_sent');
        return $query->num_rows()>0 ? $query->result_array() : FALSE;
    }

    function getMsg($msg_id = FALSE)
    {

        if ($msg_id === FALSE)
        {
            $query = $this->db->get('comm_sent');
            return $query->result_array();
        }

        $query = $this->db->get_where('comm_sent', array('msg_id' => $msg_id));
        return $query->row_array();

    }

    function getDraft($msg_id = FALSE)
    {

        if ($msg_id === FALSE)
        {
            $query = $this->db->get('comm_sent');
            return $query->result_array();
        }

        $query = $this->db->get_where('comm_sent', array('msg_id' => $msg_id, 'status'=>'drafted'));
        return $query->row_array();

    }

    function countSent($email)
    {
        $this->db->select('*');
        $this->db->order_by('sent_at', 'DESC');
        $this->db->where('sender_id',$email);
        $this->db->where('is_trash',0);
        $this->db->where('is_recycle',0);
        $this->db->where('status','sent');
        $query = $this->db->get('comm_sent');
        return $query->num_rows();
    }

    function countDrafted($email)
    {
        $this->db->select('*');
        $this->db->order_by('sent_at', 'DESC');
        $this->db->where('sender_id',$email);
        $this->db->where('status','drafted');
        $query = $this->db->get('comm_sent');
        return $query->num_rows();
    }

    //filter older/newest sent messages
    function msgCategory($email, $flag)
    {
        if($flag == 'newest')
        {
            $this->db->select('*');
            $this->db->order_by('sent_at', 'DESC');
            $this->db->where('sender_id',$email);
            $this->db->where('is_trash',0);
            $this->db->where('is_recycle',0);
            $this->db->where('status','sent');
            $query = $this->db->get('comm_sent',10);
            return $query->num_rows()>0 ? $query->result_array() : FALSE;
        }
        elseif ($flag == 'older')
        {
            $this->db->select('*');
            $this->db->order_by('sent_at', 'ASC');
            $this->db->where('sender_id',$email);
            $this->db->where('is_trash',0);
            $this->db->where('is_recycle',0);
            $this->db->where('status','sent');
            $query = $this->db->get('comm_sent',10);
            return $query->num_rows()>0 ? $query->result_array() : FALSE;
        }
    }

    //filter older/newest drafted messages
    function filterDraftedMsg($email, $flag)
    {
        if($flag == 'newest')
        {
            $this->db->select('*');
            $this->db->order_by('sent_at', 'DESC');
            $this->db->where('sender_id',$email);
           // $this->db->where('is_trash',0);
           // $this->db->where('is_recycle',0);
            $this->db->where('status','drafted');
            $query = $this->db->get('comm_sent',10);
            return $query->num_rows()>0 ? $query->result_array() : FALSE;
        }
        elseif ($flag == 'older')
        {
            $this->db->select('*');
            $this->db->order_by('sent_at', 'ASC');
            $this->db->where('sender_id',$email);
            //$this->db->where('is_trash',0);
           // $this->db->where('is_recycle',0);
            $this->db->where('status','drafted');
            $query = $this->db->get('comm_sent',10);
            return $query->num_rows()>0 ? $query->result_array() : FALSE;
        }
    }

    function deleteMsg($msg)
    {
        $data = array('is_trash'=>1);
        $this->db->where('msg_id', $msg);
        $this->db->update('comm_sent',$data);
        return ($this->db->affected_rows()==1)? TRUE :FALSE;
    }

    //move outbox trashes to recycle folder
    function deleteTrash($msg,$email)
    {
        //$email = profile()->email;
        $data = array('is_trash'=>0,'is_recycle'=>1);
        $this->db->where('msg_id', $msg);
        $this->db->where('sender_id',$email);
        $this->db->update('comm_sent',$data);
        return ($this->db->affected_rows()==1)? TRUE :FALSE;
    }

    function getReply($msg)
    {
        $this->db->select('*');
        $this->db->order_by('reply_date', 'DESC');
        $this->db->where('msg_id',$msg);
        $query = $this->db->get('comm_reply');
        return $query->num_rows()>0 ? $query->result_array() : FALSE;
    }


    //function for pagination
    public function get_msg($limit, $start) {
        $email = profile()->email;
        $this->db->order_by('sent_at', 'DESC');
        $this->db->where('sender_id', $email);
        $this->db->where('status', 'sent');
        $this->db->where('is_trash',0);
        $this->db->where('is_recycle',0);
        $this->db->limit($limit, $start);
        $query = $this->db->get('comm_sent');
        return $query->num_rows()>0 ? $query->result_array() : FALSE;
    }
}