<?php


class ClockModel extends MY_Model {
    public $branch;
    public $business;

    public function __construct() {
        parent::__construct();
        $this->branch = runningBranch()->branch_key;
        $this->business = runningBusiness()->business_key;
    }

    public function clocks() {
        $this->db->order_by('wclock_id');
        //$this->db->where('wclock_branch_key',$this->branch);
        $this->db->where('wclock_business_key',$this->business);
        $this->db->where('date_format(wclock_date,"%Y-%m-%d")', 'CURDATE()', FALSE);
        $this->db->join('business','business.business_key=working_clock.wclock_business_key','left')
            ->join('users_details','users_details.user_key=working_clock.wclock_user_id');
        $query = $this->db->get( 'working_clock' );
        return $query->num_rows()>0 ? $query->result_array() : FALSE;
    }

    public function workingclockbyme($auth_user_id) {
        $this->db->join('business','business.business_key=working_clock.wclock_business_key','left')
            ->join('users_details','users_details.user_key=working_clock.wclock_user_id');
        $this->db->where('wclock_business_key',$this->business);
        $this->db->where('wclock_user_id', $auth_user_id);
        $this->db->where('date_format(wclock_date,"%Y-%m-%d")', 'CURDATE()', FALSE);
        $query = $this->db->get( 'working_clock' );
        return $query->num_rows()>0 ? $query->result_array() : FALSE;
    }

    public function noWorkingclockbyme($auth_user_id) {
        $yesterday = datesWhenCustom("yesterday");
        $this->db->join('business','business.business_key=working_clock.wclock_business_key','left')
            ->join('users_details','users_details.user_key=working_clock.wclock_user_id');
        $this->db->where('wclock_business_key',$this->business);
        $this->db->where('wclock_user_id', $auth_user_id);
        $this->db->where('wclock_time_out_status', 'No');
        $this->db->where('wclock_date', $yesterday['start']);
        $query = $this->db->get( 'working_clock' );
        return $query->num_rows()>0 ? TRUE : FALSE;
    }

    public function noWorkingclockbyme1($auth_user_id) {
        $yesterday = datesWhenCustom("yesterday");
        $this->db->where('wclock_business_key',$this->business);
        $this->db->where('wclock_user_id', $auth_user_id);
        $this->db->where('wclock_time_out_status', 'No');
        $this->db->where('wclock_date', $yesterday['start']);
        $query = $this->db->get( 'working_clock' );
        return $query->row();
    }

    public function select_one_out($auth_user_id){
        $yesterday = datesWhenCustom("yesterday");
        $this->db->join('business','business.business_key=working_clock.wclock_business_key','left')
            ->join('users_details','users_details.user_key=working_clock.wclock_user_id');
        $this->db->where('wclock_user_id', $auth_user_id);
        $this->db->where('wclock_time_out_status', 'No');
        $this->db->where('wclock_date', $yesterday['start']);
        $query = $this->db->from('working_clock')->get();
        return $query->row();
    }

    public function createWclock($data) {
        $data['wclock_key'] = $this->clockKey();
        $data['wclock_business_key'] = $this->business;
        $this->db->limit(1)
            ->insert('working_clock',$data);
        return ($this->db->affected_rows()==1)? TRUE : FALSE;
    }

    public function select_one_clock($key){
        $this->db->join('business','business.business_key=working_clock.wclock_business_key','left')
            ->join('users_details','users_details.user_key=working_clock.wclock_user_id');
        $query = $this->db->where('wclock_user_id', $key)->from('working_clock')->get();
        return $query->row();
    }

    public function clockBreak($clockKey,$data){
        $this->db->where('wclock_business_key',$this->business);
        $this->db->limit(1)
            ->where('wclock_key=',$clockKey)
            ->update('working_clock',$data );
        return ($this->db->affected_rows()== 1)? TRUE :FALSE;
    }

    function employeeClockUpdate($clock,$data){
        $this->db->where('wclock_key',$clock);
        $this->db->update('working_clock',$data);
        if($this->db->affected_rows()>0){
            return true;
        }
        return false;
    }

    public function deleteWClock($key) {
        $this->db->limit(1)
            ->where('wclock_key=',$key)
            ->delete('working_clock');
        return ($this->db->affected_rows()==1)? TRUE :FALSE;
    }

    public function show_all_data() {
        $this->db->select('*');
        $this->db->where('wclock_business_key',$this->business);
        $this->db->join('business','business.business_key=working_clock.wclock_business_key','left')
            ->join('users_details','users_details.user_key=working_clock.wclock_user_id');
        $this->db->from('working_clock');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
    }

    public function show_data_by_id($id) {
        $condition = "wclock_user_id =" . "'" . $id . "'";
        $this->db->select('*');
        $this->db->where('wclock_business_key',$this->business);
        $this->db->join('business','business.business_key=working_clock.wclock_business_key','left')
            ->join('users_details','users_details.user_key=working_clock.wclock_user_id');
        $this->db->from('working_clock');
        $this->db->where($condition);
        $this->db->limit(1);
        $query = $this->db->get();

        if ($query->num_rows() == 1) {
            return $query->result();
        } else {
            return false;
        }
    }

    public function show_data_by_date($date) {
        $condition = "wclock_date =" . "'" . $date . "'";
        $this->db->select('*');
        $this->db->where('wclock_business_key',$this->business);
        $this->db->join('business','business.business_key=working_clock.wclock_business_key','left')
            ->join('users_details','users_details.user_key=working_clock.wclock_user_id');
        $this->db->from('working_clock');
        $this->db->where($condition);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
    }

    public function show_data_by_date_range($data) {
        $condition = "wclock_date BETWEEN " . "'" . $data['date1'] . "'" . " AND " . "'" . $data['date2'] . "'";
        $this->db->select('*');
        $this->db->where('wclock_business_key',$this->business);
        $this->db->join('business','business.business_key=working_clock.wclock_business_key','left')
            ->join('users_details','users_details.user_key=working_clock.wclock_user_id');
        $this->db->from('working_clock');
        $this->db->where($condition);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
    }

    public function clockKey(){
        $random_unique_int = 2147483648 + mt_rand( -2147482448, 2147483647 );
        $query = $this->db->where( 'wclock_key', $random_unique_int )->get_where('working_clock');
        if( $query->num_rows() > 0 ) {
            $query->free_result();
            return $this->clockKey();
        }
        return $random_unique_int;
    }

}